/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateApplicationAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateApplicationAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateApplicationRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateApplicationResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateTrustedTokenIssuerRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateTrustedTokenIssuerResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAccessScopeRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAccessScopeResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAuthenticationMethodRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAuthenticationMethodResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationGrantRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationGrantResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteTrustedTokenIssuerRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteTrustedTokenIssuerResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationProviderRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationProviderResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeTrustedTokenIssuerRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeTrustedTokenIssuerResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAccessScopeRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAccessScopeResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAssignmentConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAssignmentConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAuthenticationMethodRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAuthenticationMethodResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationGrantRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationGrantResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationSessionConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationSessionConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersResponse;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAccessScopeRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAccessScopeResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAssignmentConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAssignmentConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAuthenticationMethodRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAuthenticationMethodResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationGrantRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationGrantResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationSessionConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationSessionConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateTrustedTokenIssuerRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateTrustedTokenIssuerResponse;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsForPrincipalPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAccessScopesPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsForPrincipalPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAuthenticationMethodsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationGrantsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationProvidersPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListTrustedTokenIssuersPublisher;

/**
 * Service client for accessing SSO Admin asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * IAM Identity Center is the Amazon Web Services solution for connecting your workforce users to Amazon Web Services
 * managed applications and other Amazon Web Services resources. You can connect your existing identity provider and
 * synchronize users and groups from your directory, or create and manage your users directly in IAM Identity Center.
 * You can then use IAM Identity Center for either or both of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * User access to applications
 * </p>
 * </li>
 * <li>
 * <p>
 * User access to Amazon Web Services accounts
 * </p>
 * </li>
 * </ul>
 * <p>
 * This guide provides information about single sign-on operations that you can use for access to applications and
 * Amazon Web Services accounts. For information about IAM Identity Center features, see the <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">IAM Identity Center User Guide</a>.
 * </p>
 * <note>
 * <p>
 * IAM Identity Center uses the <code>sso</code> and <code>identitystore</code> API namespaces.
 * </p>
 * </note>
 * <p>
 * Many API operations for IAM Identity Center rely on identifiers for users and groups, known as principals. For more
 * information about how to work with principals and principal IDs in IAM Identity Center, see the <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Identity Store API
 * Reference</a>.
 * </p>
 * <note>
 * <p>
 * Amazon Web Services provides SDKs that consist of libraries and sample code for various programming languages and
 * platforms (Java, Ruby, .Net, iOS, Android, and more). The SDKs provide a convenient way to create programmatic access
 * to IAM Identity Center and other Amazon Web Services services. For more information about the Amazon Web Services
 * SDKs, including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web
 * Services</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsoAdminAsyncClient extends AwsClient {
    String SERVICE_NAME = "sso";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "sso";

    /**
     * <p>
     * Attaches the specified customer managed policy to the specified <a>PermissionSet</a>.
     * </p>
     *
     * @param attachCustomerManagedPolicyReferenceToPermissionSetRequest
     * @return A Java Future containing the result of the AttachCustomerManagedPolicyReferenceToPermissionSet operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.AttachCustomerManagedPolicyReferenceToPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachCustomerManagedPolicyReferenceToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachCustomerManagedPolicyReferenceToPermissionSetResponse> attachCustomerManagedPolicyReferenceToPermissionSet(
            AttachCustomerManagedPolicyReferenceToPermissionSetRequest attachCustomerManagedPolicyReferenceToPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified customer managed policy to the specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder} avoiding the need to create one
     * manually via {@link AttachCustomerManagedPolicyReferenceToPermissionSetRequest#builder()}
     * </p>
     *
     * @param attachCustomerManagedPolicyReferenceToPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AttachCustomerManagedPolicyReferenceToPermissionSet operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.AttachCustomerManagedPolicyReferenceToPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachCustomerManagedPolicyReferenceToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachCustomerManagedPolicyReferenceToPermissionSetResponse> attachCustomerManagedPolicyReferenceToPermissionSet(
            Consumer<AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder> attachCustomerManagedPolicyReferenceToPermissionSetRequest) {
        return attachCustomerManagedPolicyReferenceToPermissionSet(AttachCustomerManagedPolicyReferenceToPermissionSetRequest
                .builder().applyMutation(attachCustomerManagedPolicyReferenceToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Attaches an Amazon Web Services managed policy ARN to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this operation. Calling <code>ProvisionPermissionSet</code>
     * applies the corresponding IAM policy updates to all assigned accounts.
     * </p>
     * </note>
     *
     * @param attachManagedPolicyToPermissionSetRequest
     * @return A Java Future containing the result of the AttachManagedPolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.AttachManagedPolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachManagedPolicyToPermissionSetResponse> attachManagedPolicyToPermissionSet(
            AttachManagedPolicyToPermissionSetRequest attachManagedPolicyToPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an Amazon Web Services managed policy ARN to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this operation. Calling <code>ProvisionPermissionSet</code>
     * applies the corresponding IAM policy updates to all assigned accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachManagedPolicyToPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link AttachManagedPolicyToPermissionSetRequest#builder()}
     * </p>
     *
     * @param attachManagedPolicyToPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AttachManagedPolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.AttachManagedPolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachManagedPolicyToPermissionSetResponse> attachManagedPolicyToPermissionSet(
            Consumer<AttachManagedPolicyToPermissionSetRequest.Builder> attachManagedPolicyToPermissionSetRequest) {
        return attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest.builder()
                .applyMutation(attachManagedPolicyToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * The term <i>principal</i> here refers to a user or group that is defined in IAM Identity Center.
     * </p>
     * </note> <note>
     * <p>
     * As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will
     * automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role
     * created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies
     * attached to roles in your accounts will not be updated automatically. In this case, you must call
     * <code> <a>ProvisionPermissionSet</a> </code> to make these updates.
     * </p>
     * </note> <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of
     * an assignment creation request.
     * </p>
     * </note>
     *
     * @param createAccountAssignmentRequest
     * @return A Java Future containing the result of the CreateAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccountAssignmentResponse> createAccountAssignment(
            CreateAccountAssignmentRequest createAccountAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * The term <i>principal</i> here refers to a user or group that is defined in IAM Identity Center.
     * </p>
     * </note> <note>
     * <p>
     * As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will
     * automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role
     * created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies
     * attached to roles in your accounts will not be updated automatically. In this case, you must call
     * <code> <a>ProvisionPermissionSet</a> </code> to make these updates.
     * </p>
     * </note> <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of
     * an assignment creation request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAccountAssignmentRequest#builder()}
     * </p>
     *
     * @param createAccountAssignmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccountAssignmentResponse> createAccountAssignment(
            Consumer<CreateAccountAssignmentRequest.Builder> createAccountAssignmentRequest) {
        return createAccountAssignment(CreateAccountAssignmentRequest.builder().applyMutation(createAccountAssignmentRequest)
                .build());
    }

    /**
     * <p>
     * Creates an OAuth 2.0 customer managed application in IAM Identity Center for the given application provider.
     * </p>
     * <note>
     * <p>
     * This API does not support creating SAML 2.0 customer managed applications or Amazon Web Services managed
     * applications. To learn how to create an Amazon Web Services managed application, see the application user guide.
     * You can create a SAML 2.0 customer managed application in the Amazon Web Services Management Console only. See <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/customermanagedapps-saml2-setup.html">Setting up
     * customer managed SAML 2.0 applications</a>. For more information on these application types, see <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/awsapps.html">Amazon Web Services managed
     * applications</a>.
     * </p>
     * </note>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an OAuth 2.0 customer managed application in IAM Identity Center for the given application provider.
     * </p>
     * <note>
     * <p>
     * This API does not support creating SAML 2.0 customer managed applications or Amazon Web Services managed
     * applications. To learn how to create an Amazon Web Services managed application, see the application user guide.
     * You can create a SAML 2.0 customer managed application in the Amazon Web Services Management Console only. See <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/customermanagedapps-saml2-setup.html">Setting up
     * customer managed SAML 2.0 applications</a>. For more information on these application types, see <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/awsapps.html">Amazon Web Services managed
     * applications</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.CreateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Grant application access to a user or group.
     * </p>
     *
     * @param createApplicationAssignmentRequest
     * @return A Java Future containing the result of the CreateApplicationAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateApplicationAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateApplicationAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationAssignmentResponse> createApplicationAssignment(
            CreateApplicationAssignmentRequest createApplicationAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grant application access to a user or group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationAssignmentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateApplicationAssignmentRequest#builder()}
     * </p>
     *
     * @param createApplicationAssignmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.CreateApplicationAssignmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateApplicationAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateApplicationAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateApplicationAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationAssignmentResponse> createApplicationAssignment(
            Consumer<CreateApplicationAssignmentRequest.Builder> createApplicationAssignmentRequest) {
        return createApplicationAssignment(CreateApplicationAssignmentRequest.builder()
                .applyMutation(createApplicationAssignmentRequest).build());
    }

    /**
     * <p>
     * Creates an instance of IAM Identity Center for a standalone Amazon Web Services account that is not managed by
     * Organizations or a member Amazon Web Services account in an organization. You can create only one instance per
     * account and across all Amazon Web Services Regions.
     * </p>
     * <p>
     * The CreateInstance request is rejected if the following apply:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The instance is created within the organization management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * An instance already exists in the same account.
     * </p>
     * </li>
     * </ul>
     *
     * @param createInstanceRequest
     * @return A Java Future containing the result of the CreateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstanceResponse> createInstance(CreateInstanceRequest createInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an instance of IAM Identity Center for a standalone Amazon Web Services account that is not managed by
     * Organizations or a member Amazon Web Services account in an organization. You can create only one instance per
     * account and across all Amazon Web Services Regions.
     * </p>
     * <p>
     * The CreateInstance request is rejected if the following apply:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The instance is created within the organization management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * An instance already exists in the same account.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInstanceRequest#builder()}
     * </p>
     *
     * @param createInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.CreateInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstanceResponse> createInstance(Consumer<CreateInstanceRequest.Builder> createInstanceRequest) {
        return createInstance(CreateInstanceRequest.builder().applyMutation(createInstanceRequest).build());
    }

    /**
     * <p>
     * Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You
     * can also specify new attributes to add to your ABAC configuration during the enabling process. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeInstanceAccessControlAttributeConfiguration</code> to validate
     * that <code>InstanceAccessControlAttributeConfiguration</code> was created.
     * </p>
     * </note>
     *
     * @param createInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the CreateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstanceAccessControlAttributeConfigurationResponse> createInstanceAccessControlAttributeConfiguration(
            CreateInstanceAccessControlAttributeConfigurationRequest createInstanceAccessControlAttributeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You
     * can also specify new attributes to add to your ABAC configuration during the enabling process. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeInstanceAccessControlAttributeConfiguration</code> to validate
     * that <code>InstanceAccessControlAttributeConfiguration</code> was created.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link CreateInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param createInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstanceAccessControlAttributeConfigurationResponse> createInstanceAccessControlAttributeConfiguration(
            Consumer<CreateInstanceAccessControlAttributeConfigurationRequest.Builder> createInstanceAccessControlAttributeConfigurationRequest) {
        return createInstanceAccessControlAttributeConfiguration(CreateInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(createInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a permission set within a specified IAM Identity Center instance.
     * </p>
     * <note>
     * <p>
     * To grant users and groups access to Amazon Web Services account resources, use
     * <code> <a>CreateAccountAssignment</a> </code>.
     * </p>
     * </note>
     *
     * @param createPermissionSetRequest
     * @return A Java Future containing the result of the CreatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePermissionSetResponse> createPermissionSet(
            CreatePermissionSetRequest createPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a permission set within a specified IAM Identity Center instance.
     * </p>
     * <note>
     * <p>
     * To grant users and groups access to Amazon Web Services account resources, use
     * <code> <a>CreateAccountAssignment</a> </code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePermissionSetRequest#builder()}
     * </p>
     *
     * @param createPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePermissionSetResponse> createPermissionSet(
            Consumer<CreatePermissionSetRequest.Builder> createPermissionSetRequest) {
        return createPermissionSet(CreatePermissionSetRequest.builder().applyMutation(createPermissionSetRequest).build());
    }

    /**
     * <p>
     * Creates a connection to a trusted token issuer in an instance of IAM Identity Center. A trusted token issuer
     * enables trusted identity propagation to be used with applications that authenticate outside of Amazon Web
     * Services.
     * </p>
     * <p>
     * This trusted token issuer describes an external identity provider (IdP) that can generate claims or assertions in
     * the form of access tokens for a user. Applications enabled for IAM Identity Center can use these tokens for
     * authentication.
     * </p>
     *
     * @param createTrustedTokenIssuerRequest
     * @return A Java Future containing the result of the CreateTrustedTokenIssuer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateTrustedTokenIssuer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateTrustedTokenIssuer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrustedTokenIssuerResponse> createTrustedTokenIssuer(
            CreateTrustedTokenIssuerRequest createTrustedTokenIssuerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection to a trusted token issuer in an instance of IAM Identity Center. A trusted token issuer
     * enables trusted identity propagation to be used with applications that authenticate outside of Amazon Web
     * Services.
     * </p>
     * <p>
     * This trusted token issuer describes an external identity provider (IdP) that can generate claims or assertions in
     * the form of access tokens for a user. Applications enabled for IAM Identity Center can use these tokens for
     * authentication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrustedTokenIssuerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTrustedTokenIssuerRequest#builder()}
     * </p>
     *
     * @param createTrustedTokenIssuerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.CreateTrustedTokenIssuerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrustedTokenIssuer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateTrustedTokenIssuer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateTrustedTokenIssuer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrustedTokenIssuerResponse> createTrustedTokenIssuer(
            Consumer<CreateTrustedTokenIssuerRequest.Builder> createTrustedTokenIssuerRequest) {
        return createTrustedTokenIssuer(CreateTrustedTokenIssuerRequest.builder().applyMutation(createTrustedTokenIssuerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentDeletionStatus</code> to describe the status of
     * an assignment deletion request.
     * </p>
     * </note>
     *
     * @param deleteAccountAssignmentRequest
     * @return A Java Future containing the result of the DeleteAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountAssignmentResponse> deleteAccountAssignment(
            DeleteAccountAssignmentRequest deleteAccountAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentDeletionStatus</code> to describe the status of
     * an assignment deletion request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccountAssignmentRequest#builder()}
     * </p>
     *
     * @param deleteAccountAssignmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountAssignmentResponse> deleteAccountAssignment(
            Consumer<DeleteAccountAssignmentRequest.Builder> deleteAccountAssignmentRequest) {
        return deleteAccountAssignment(DeleteAccountAssignmentRequest.builder().applyMutation(deleteAccountAssignmentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the association with the application. The connected service resource still exists.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association with the application. The connected service resource still exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes an IAM Identity Center access scope from an application.
     * </p>
     *
     * @param deleteApplicationAccessScopeRequest
     * @return A Java Future containing the result of the DeleteApplicationAccessScope operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplicationAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationAccessScopeResponse> deleteApplicationAccessScope(
            DeleteApplicationAccessScopeRequest deleteApplicationAccessScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an IAM Identity Center access scope from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationAccessScopeRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApplicationAccessScopeRequest#builder()}
     * </p>
     *
     * @param deleteApplicationAccessScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAccessScopeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteApplicationAccessScope operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplicationAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationAccessScopeResponse> deleteApplicationAccessScope(
            Consumer<DeleteApplicationAccessScopeRequest.Builder> deleteApplicationAccessScopeRequest) {
        return deleteApplicationAccessScope(DeleteApplicationAccessScopeRequest.builder()
                .applyMutation(deleteApplicationAccessScopeRequest).build());
    }

    /**
     * <p>
     * Revoke application access to an application by deleting application assignments for a user or group.
     * </p>
     *
     * @param deleteApplicationAssignmentRequest
     * @return A Java Future containing the result of the DeleteApplicationAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplicationAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationAssignmentResponse> deleteApplicationAssignment(
            DeleteApplicationAssignmentRequest deleteApplicationAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revoke application access to an application by deleting application assignments for a user or group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationAssignmentRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApplicationAssignmentRequest#builder()}
     * </p>
     *
     * @param deleteApplicationAssignmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAssignmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteApplicationAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplicationAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationAssignmentResponse> deleteApplicationAssignment(
            Consumer<DeleteApplicationAssignmentRequest.Builder> deleteApplicationAssignmentRequest) {
        return deleteApplicationAssignment(DeleteApplicationAssignmentRequest.builder()
                .applyMutation(deleteApplicationAssignmentRequest).build());
    }

    /**
     * <p>
     * Deletes an authentication method from an application.
     * </p>
     *
     * @param deleteApplicationAuthenticationMethodRequest
     * @return A Java Future containing the result of the DeleteApplicationAuthenticationMethod operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplicationAuthenticationMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAuthenticationMethod"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationAuthenticationMethodResponse> deleteApplicationAuthenticationMethod(
            DeleteApplicationAuthenticationMethodRequest deleteApplicationAuthenticationMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an authentication method from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteApplicationAuthenticationMethodRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteApplicationAuthenticationMethodRequest#builder()}
     * </p>
     *
     * @param deleteApplicationAuthenticationMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAuthenticationMethodRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteApplicationAuthenticationMethod operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplicationAuthenticationMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAuthenticationMethod"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationAuthenticationMethodResponse> deleteApplicationAuthenticationMethod(
            Consumer<DeleteApplicationAuthenticationMethodRequest.Builder> deleteApplicationAuthenticationMethodRequest) {
        return deleteApplicationAuthenticationMethod(DeleteApplicationAuthenticationMethodRequest.builder()
                .applyMutation(deleteApplicationAuthenticationMethodRequest).build());
    }

    /**
     * <p>
     * Deletes a grant from an application.
     * </p>
     *
     * @param deleteApplicationGrantRequest
     * @return A Java Future containing the result of the DeleteApplicationGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplicationGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationGrantResponse> deleteApplicationGrant(
            DeleteApplicationGrantRequest deleteApplicationGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a grant from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationGrantRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteApplicationGrantRequest#builder()}
     * </p>
     *
     * @param deleteApplicationGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApplicationGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteApplicationGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationGrantResponse> deleteApplicationGrant(
            Consumer<DeleteApplicationGrantRequest.Builder> deleteApplicationGrantRequest) {
        return deleteApplicationGrant(DeleteApplicationGrantRequest.builder().applyMutation(deleteApplicationGrantRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the inline policy from a specified permission set.
     * </p>
     *
     * @param deleteInlinePolicyFromPermissionSetRequest
     * @return A Java Future containing the result of the DeleteInlinePolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInlinePolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInlinePolicyFromPermissionSetResponse> deleteInlinePolicyFromPermissionSet(
            DeleteInlinePolicyFromPermissionSetRequest deleteInlinePolicyFromPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the inline policy from a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInlinePolicyFromPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInlinePolicyFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param deleteInlinePolicyFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteInlinePolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInlinePolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInlinePolicyFromPermissionSetResponse> deleteInlinePolicyFromPermissionSet(
            Consumer<DeleteInlinePolicyFromPermissionSetRequest.Builder> deleteInlinePolicyFromPermissionSetRequest) {
        return deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest.builder()
                .applyMutation(deleteInlinePolicyFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Deletes the instance of IAM Identity Center. Only the account that owns the instance can call this API. Neither
     * the delegated administrator nor member account can delete the organization instance, but those roles can delete
     * their own instance.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the instance of IAM Identity Center. Only the account that owns the instance can call this API. Neither
     * the delegated administrator nor member account can delete the organization instance, but those roles can delete
     * their own instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInstanceRequest#builder()}
     * </p>
     *
     * @param deleteInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceResponse> deleteInstance(Consumer<DeleteInstanceRequest.Builder> deleteInstanceRequest) {
        return deleteInstance(DeleteInstanceRequest.builder().applyMutation(deleteInstanceRequest).build());
    }

    /**
     * <p>
     * Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and
     * deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received
     * from an identity source and any custom attributes you have previously configured will not be passed. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     *
     * @param deleteInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the DeleteInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceAccessControlAttributeConfigurationResponse> deleteInstanceAccessControlAttributeConfiguration(
            DeleteInstanceAccessControlAttributeConfigurationRequest deleteInstanceAccessControlAttributeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and
     * deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received
     * from an identity source and any custom attributes you have previously configured will not be passed. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link DeleteInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceAccessControlAttributeConfigurationResponse> deleteInstanceAccessControlAttributeConfiguration(
            Consumer<DeleteInstanceAccessControlAttributeConfigurationRequest.Builder> deleteInstanceAccessControlAttributeConfigurationRequest) {
        return deleteInstanceAccessControlAttributeConfiguration(DeleteInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(deleteInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified permission set.
     * </p>
     *
     * @param deletePermissionSetRequest
     * @return A Java Future containing the result of the DeletePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeletePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePermissionSetResponse> deletePermissionSet(
            DeletePermissionSetRequest deletePermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePermissionSetRequest#builder()}
     * </p>
     *
     * @param deletePermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeletePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePermissionSetResponse> deletePermissionSet(
            Consumer<DeletePermissionSetRequest.Builder> deletePermissionSetRequest) {
        return deletePermissionSet(DeletePermissionSetRequest.builder().applyMutation(deletePermissionSetRequest).build());
    }

    /**
     * <p>
     * Deletes the permissions boundary from a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param deletePermissionsBoundaryFromPermissionSetRequest
     * @return A Java Future containing the result of the DeletePermissionsBoundaryFromPermissionSet operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeletePermissionsBoundaryFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionsBoundaryFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePermissionsBoundaryFromPermissionSetResponse> deletePermissionsBoundaryFromPermissionSet(
            DeletePermissionsBoundaryFromPermissionSetRequest deletePermissionsBoundaryFromPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the permissions boundary from a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeletePermissionsBoundaryFromPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link DeletePermissionsBoundaryFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param deletePermissionsBoundaryFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeletePermissionsBoundaryFromPermissionSet operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeletePermissionsBoundaryFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionsBoundaryFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePermissionsBoundaryFromPermissionSetResponse> deletePermissionsBoundaryFromPermissionSet(
            Consumer<DeletePermissionsBoundaryFromPermissionSetRequest.Builder> deletePermissionsBoundaryFromPermissionSetRequest) {
        return deletePermissionsBoundaryFromPermissionSet(DeletePermissionsBoundaryFromPermissionSetRequest.builder()
                .applyMutation(deletePermissionsBoundaryFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Deletes a trusted token issuer configuration from an instance of IAM Identity Center.
     * </p>
     * <note>
     * <p>
     * Deleting this trusted token issuer configuration will cause users to lose access to any applications that are
     * configured to use the trusted token issuer.
     * </p>
     * </note>
     *
     * @param deleteTrustedTokenIssuerRequest
     * @return A Java Future containing the result of the DeleteTrustedTokenIssuer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteTrustedTokenIssuer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteTrustedTokenIssuer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrustedTokenIssuerResponse> deleteTrustedTokenIssuer(
            DeleteTrustedTokenIssuerRequest deleteTrustedTokenIssuerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a trusted token issuer configuration from an instance of IAM Identity Center.
     * </p>
     * <note>
     * <p>
     * Deleting this trusted token issuer configuration will cause users to lose access to any applications that are
     * configured to use the trusted token issuer.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrustedTokenIssuerRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrustedTokenIssuerRequest#builder()}
     * </p>
     *
     * @param deleteTrustedTokenIssuerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DeleteTrustedTokenIssuerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTrustedTokenIssuer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteTrustedTokenIssuer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteTrustedTokenIssuer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrustedTokenIssuerResponse> deleteTrustedTokenIssuer(
            Consumer<DeleteTrustedTokenIssuerRequest.Builder> deleteTrustedTokenIssuerRequest) {
        return deleteTrustedTokenIssuer(DeleteTrustedTokenIssuerRequest.builder().applyMutation(deleteTrustedTokenIssuerRequest)
                .build());
    }

    /**
     * <p>
     * Describes the status of the assignment creation request.
     * </p>
     *
     * @param describeAccountAssignmentCreationStatusRequest
     * @return A Java Future containing the result of the DescribeAccountAssignmentCreationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentCreationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAssignmentCreationStatusResponse> describeAccountAssignmentCreationStatus(
            DescribeAccountAssignmentCreationStatusRequest describeAccountAssignmentCreationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the assignment creation request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAccountAssignmentCreationStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param describeAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAccountAssignmentCreationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentCreationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAssignmentCreationStatusResponse> describeAccountAssignmentCreationStatus(
            Consumer<DescribeAccountAssignmentCreationStatusRequest.Builder> describeAccountAssignmentCreationStatusRequest) {
        return describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(describeAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * Describes the status of the assignment deletion request.
     * </p>
     *
     * @param describeAccountAssignmentDeletionStatusRequest
     * @return A Java Future containing the result of the DescribeAccountAssignmentDeletionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentDeletionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAssignmentDeletionStatusResponse> describeAccountAssignmentDeletionStatus(
            DescribeAccountAssignmentDeletionStatusRequest describeAccountAssignmentDeletionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the assignment deletion request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAccountAssignmentDeletionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param describeAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAccountAssignmentDeletionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentDeletionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAssignmentDeletionStatusResponse> describeAccountAssignmentDeletionStatus(
            Consumer<DescribeAccountAssignmentDeletionStatusRequest.Builder> describeAccountAssignmentDeletionStatusRequest) {
        return describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(describeAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of an application associated with an instance of IAM Identity Center.
     * </p>
     *
     * @param describeApplicationRequest
     * @return A Java Future containing the result of the DescribeApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationResponse> describeApplication(
            DescribeApplicationRequest describeApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of an application associated with an instance of IAM Identity Center.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationRequest#builder()}
     * </p>
     *
     * @param describeApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationResponse> describeApplication(
            Consumer<DescribeApplicationRequest.Builder> describeApplicationRequest) {
        return describeApplication(DescribeApplicationRequest.builder().applyMutation(describeApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves a direct assignment of a user or group to an application. If the user doesn’t have a direct assignment
     * to the application, the user may still have access to the application through a group. Therefore, don’t use this
     * API to test access to an application for a user. Instead use <a>ListApplicationAssignmentsForPrincipal</a>.
     * </p>
     *
     * @param describeApplicationAssignmentRequest
     * @return A Java Future containing the result of the DescribeApplicationAssignment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeApplicationAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplicationAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationAssignmentResponse> describeApplicationAssignment(
            DescribeApplicationAssignmentRequest describeApplicationAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a direct assignment of a user or group to an application. If the user doesn’t have a direct assignment
     * to the application, the user may still have access to the application through a group. Therefore, don’t use this
     * API to test access to an application for a user. Instead use <a>ListApplicationAssignmentsForPrincipal</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationAssignmentRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationAssignmentRequest#builder()}
     * </p>
     *
     * @param describeApplicationAssignmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationAssignmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeApplicationAssignment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeApplicationAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplicationAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationAssignmentResponse> describeApplicationAssignment(
            Consumer<DescribeApplicationAssignmentRequest.Builder> describeApplicationAssignmentRequest) {
        return describeApplicationAssignment(DescribeApplicationAssignmentRequest.builder()
                .applyMutation(describeApplicationAssignmentRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a provider that can be used to connect an Amazon Web Services managed application or
     * customer managed application to IAM Identity Center.
     * </p>
     *
     * @param describeApplicationProviderRequest
     * @return A Java Future containing the result of the DescribeApplicationProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeApplicationProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplicationProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationProviderResponse> describeApplicationProvider(
            DescribeApplicationProviderRequest describeApplicationProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a provider that can be used to connect an Amazon Web Services managed application or
     * customer managed application to IAM Identity Center.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationProviderRequest#builder()}
     * </p>
     *
     * @param describeApplicationProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationProviderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeApplicationProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeApplicationProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplicationProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationProviderResponse> describeApplicationProvider(
            Consumer<DescribeApplicationProviderRequest.Builder> describeApplicationProviderRequest) {
        return describeApplicationProvider(DescribeApplicationProviderRequest.builder()
                .applyMutation(describeApplicationProviderRequest).build());
    }

    /**
     * <p>
     * Returns the details of an instance of IAM Identity Center. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The instance is in the process of being created. When the instance is ready for
     * use, DescribeInstance returns the status of <code>ACTIVE</code>. While the instance is in the
     * <code>CREATE_IN_PROGRESS</code> state, you can call only DescribeInstance and DeleteInstance operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> - The instance is being deleted. Returns <code>AccessDeniedException</code> after
     * the delete operation completes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The instance is active.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeInstanceRequest
     * @return A Java Future containing the result of the DescribeInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceResponse> describeInstance(DescribeInstanceRequest describeInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of an instance of IAM Identity Center. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The instance is in the process of being created. When the instance is ready for
     * use, DescribeInstance returns the status of <code>ACTIVE</code>. While the instance is in the
     * <code>CREATE_IN_PROGRESS</code> state, you can call only DescribeInstance and DeleteInstance operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> - The instance is being deleted. Returns <code>AccessDeniedException</code> after
     * the delete operation completes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The instance is active.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInstanceRequest#builder()}
     * </p>
     *
     * @param describeInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceResponse> describeInstance(
            Consumer<DescribeInstanceRequest.Builder> describeInstanceRequest) {
        return describeInstance(DescribeInstanceRequest.builder().applyMutation(describeInstanceRequest).build());
    }

    /**
     * <p>
     * Returns the list of IAM Identity Center identity store attributes that have been configured to work with
     * attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return
     * attributes configured and sent by an external identity provider. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center
     * User Guide</i>.
     * </p>
     *
     * @param describeInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the DescribeInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAccessControlAttributeConfigurationResponse> describeInstanceAccessControlAttributeConfiguration(
            DescribeInstanceAccessControlAttributeConfigurationRequest describeInstanceAccessControlAttributeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of IAM Identity Center identity store attributes that have been configured to work with
     * attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return
     * attributes configured and sent by an external identity provider. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one
     * manually via {@link DescribeInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAccessControlAttributeConfigurationResponse> describeInstanceAccessControlAttributeConfiguration(
            Consumer<DescribeInstanceAccessControlAttributeConfigurationRequest.Builder> describeInstanceAccessControlAttributeConfigurationRequest) {
        return describeInstanceAccessControlAttributeConfiguration(DescribeInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(describeInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the details of the permission set.
     * </p>
     *
     * @param describePermissionSetRequest
     * @return A Java Future containing the result of the DescribePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePermissionSetResponse> describePermissionSet(
            DescribePermissionSetRequest describePermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePermissionSetRequest#builder()}
     * </p>
     *
     * @param describePermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePermissionSetResponse> describePermissionSet(
            Consumer<DescribePermissionSetRequest.Builder> describePermissionSetRequest) {
        return describePermissionSet(DescribePermissionSetRequest.builder().applyMutation(describePermissionSetRequest).build());
    }

    /**
     * <p>
     * Describes the status for the given permission set provisioning request.
     * </p>
     *
     * @param describePermissionSetProvisioningStatusRequest
     * @return A Java Future containing the result of the DescribePermissionSetProvisioningStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSetProvisioningStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePermissionSetProvisioningStatusResponse> describePermissionSetProvisioningStatus(
            DescribePermissionSetProvisioningStatusRequest describePermissionSetProvisioningStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status for the given permission set provisioning request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribePermissionSetProvisioningStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribePermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param describePermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribePermissionSetProvisioningStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSetProvisioningStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePermissionSetProvisioningStatusResponse> describePermissionSetProvisioningStatus(
            Consumer<DescribePermissionSetProvisioningStatusRequest.Builder> describePermissionSetProvisioningStatusRequest) {
        return describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest.builder()
                .applyMutation(describePermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a trusted token issuer configuration stored in an instance of IAM Identity Center.
     * Details include the name of the trusted token issuer, the issuer URL, and the path of the source attribute and
     * the destination attribute for a trusted token issuer configuration.
     * </p>
     *
     * @param describeTrustedTokenIssuerRequest
     * @return A Java Future containing the result of the DescribeTrustedTokenIssuer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeTrustedTokenIssuer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeTrustedTokenIssuer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedTokenIssuerResponse> describeTrustedTokenIssuer(
            DescribeTrustedTokenIssuerRequest describeTrustedTokenIssuerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a trusted token issuer configuration stored in an instance of IAM Identity Center.
     * Details include the name of the trusted token issuer, the issuer URL, and the path of the source attribute and
     * the destination attribute for a trusted token issuer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustedTokenIssuerRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTrustedTokenIssuerRequest#builder()}
     * </p>
     *
     * @param describeTrustedTokenIssuerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DescribeTrustedTokenIssuerRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeTrustedTokenIssuer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeTrustedTokenIssuer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeTrustedTokenIssuer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedTokenIssuerResponse> describeTrustedTokenIssuer(
            Consumer<DescribeTrustedTokenIssuerRequest.Builder> describeTrustedTokenIssuerRequest) {
        return describeTrustedTokenIssuer(DescribeTrustedTokenIssuerRequest.builder()
                .applyMutation(describeTrustedTokenIssuerRequest).build());
    }

    /**
     * <p>
     * Detaches the specified customer managed policy from the specified <a>PermissionSet</a>.
     * </p>
     *
     * @param detachCustomerManagedPolicyReferenceFromPermissionSetRequest
     * @return A Java Future containing the result of the DetachCustomerManagedPolicyReferenceFromPermissionSet
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DetachCustomerManagedPolicyReferenceFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachCustomerManagedPolicyReferenceFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachCustomerManagedPolicyReferenceFromPermissionSetResponse> detachCustomerManagedPolicyReferenceFromPermissionSet(
            DetachCustomerManagedPolicyReferenceFromPermissionSetRequest detachCustomerManagedPolicyReferenceFromPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the specified customer managed policy from the specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.Builder} avoiding the need to create one
     * manually via {@link DetachCustomerManagedPolicyReferenceFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param detachCustomerManagedPolicyReferenceFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DetachCustomerManagedPolicyReferenceFromPermissionSet
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DetachCustomerManagedPolicyReferenceFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachCustomerManagedPolicyReferenceFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachCustomerManagedPolicyReferenceFromPermissionSetResponse> detachCustomerManagedPolicyReferenceFromPermissionSet(
            Consumer<DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.Builder> detachCustomerManagedPolicyReferenceFromPermissionSetRequest) {
        return detachCustomerManagedPolicyReferenceFromPermissionSet(DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
                .builder().applyMutation(detachCustomerManagedPolicyReferenceFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Detaches the attached Amazon Web Services managed policy ARN from the specified permission set.
     * </p>
     *
     * @param detachManagedPolicyFromPermissionSetRequest
     * @return A Java Future containing the result of the DetachManagedPolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DetachManagedPolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachManagedPolicyFromPermissionSetResponse> detachManagedPolicyFromPermissionSet(
            DetachManagedPolicyFromPermissionSetRequest detachManagedPolicyFromPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the attached Amazon Web Services managed policy ARN from the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DetachManagedPolicyFromPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link DetachManagedPolicyFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param detachManagedPolicyFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DetachManagedPolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DetachManagedPolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachManagedPolicyFromPermissionSetResponse> detachManagedPolicyFromPermissionSet(
            Consumer<DetachManagedPolicyFromPermissionSetRequest.Builder> detachManagedPolicyFromPermissionSetRequest) {
        return detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest.builder()
                .applyMutation(detachManagedPolicyFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Retrieves the authorized targets for an IAM Identity Center access scope for an application.
     * </p>
     *
     * @param getApplicationAccessScopeRequest
     * @return A Java Future containing the result of the GetApplicationAccessScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationAccessScopeResponse> getApplicationAccessScope(
            GetApplicationAccessScopeRequest getApplicationAccessScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the authorized targets for an IAM Identity Center access scope for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationAccessScopeRequest.Builder} avoiding
     * the need to create one manually via {@link GetApplicationAccessScopeRequest#builder()}
     * </p>
     *
     * @param getApplicationAccessScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.GetApplicationAccessScopeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetApplicationAccessScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationAccessScopeResponse> getApplicationAccessScope(
            Consumer<GetApplicationAccessScopeRequest.Builder> getApplicationAccessScopeRequest) {
        return getApplicationAccessScope(GetApplicationAccessScopeRequest.builder()
                .applyMutation(getApplicationAccessScopeRequest).build());
    }

    /**
     * <p>
     * Retrieves the configuration of <a>PutApplicationAssignmentConfiguration</a>.
     * </p>
     *
     * @param getApplicationAssignmentConfigurationRequest
     * @return A Java Future containing the result of the GetApplicationAssignmentConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationAssignmentConfigurationResponse> getApplicationAssignmentConfiguration(
            GetApplicationAssignmentConfigurationRequest getApplicationAssignmentConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration of <a>PutApplicationAssignmentConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetApplicationAssignmentConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetApplicationAssignmentConfigurationRequest#builder()}
     * </p>
     *
     * @param getApplicationAssignmentConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.GetApplicationAssignmentConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetApplicationAssignmentConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationAssignmentConfigurationResponse> getApplicationAssignmentConfiguration(
            Consumer<GetApplicationAssignmentConfigurationRequest.Builder> getApplicationAssignmentConfigurationRequest) {
        return getApplicationAssignmentConfiguration(GetApplicationAssignmentConfigurationRequest.builder()
                .applyMutation(getApplicationAssignmentConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves details about an authentication method used by an application.
     * </p>
     *
     * @param getApplicationAuthenticationMethodRequest
     * @return A Java Future containing the result of the GetApplicationAuthenticationMethod operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationAuthenticationMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAuthenticationMethod"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationAuthenticationMethodResponse> getApplicationAuthenticationMethod(
            GetApplicationAuthenticationMethodRequest getApplicationAuthenticationMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an authentication method used by an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationAuthenticationMethodRequest.Builder}
     * avoiding the need to create one manually via {@link GetApplicationAuthenticationMethodRequest#builder()}
     * </p>
     *
     * @param getApplicationAuthenticationMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.GetApplicationAuthenticationMethodRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetApplicationAuthenticationMethod operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationAuthenticationMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAuthenticationMethod"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationAuthenticationMethodResponse> getApplicationAuthenticationMethod(
            Consumer<GetApplicationAuthenticationMethodRequest.Builder> getApplicationAuthenticationMethodRequest) {
        return getApplicationAuthenticationMethod(GetApplicationAuthenticationMethodRequest.builder()
                .applyMutation(getApplicationAuthenticationMethodRequest).build());
    }

    /**
     * <p>
     * Retrieves details about an application grant.
     * </p>
     *
     * @param getApplicationGrantRequest
     * @return A Java Future containing the result of the GetApplicationGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetApplicationGrantResponse> getApplicationGrant(
            GetApplicationGrantRequest getApplicationGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an application grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationGrantRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationGrantRequest#builder()}
     * </p>
     *
     * @param getApplicationGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.GetApplicationGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApplicationGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetApplicationGrantResponse> getApplicationGrant(
            Consumer<GetApplicationGrantRequest.Builder> getApplicationGrantRequest) {
        return getApplicationGrant(GetApplicationGrantRequest.builder().applyMutation(getApplicationGrantRequest).build());
    }

    /**
     * <p>
     * Retrieves the session configuration for an application in IAM Identity Center.
     * </p>
     * <p>
     * The session configuration determines how users can access an application. This includes whether user background
     * sessions are enabled. User background sessions allow users to start a job on a supported Amazon Web Services
     * managed application without having to remain signed in to an active session while the job runs.
     * </p>
     *
     * @param getApplicationSessionConfigurationRequest
     * @return A Java Future containing the result of the GetApplicationSessionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationSessionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationSessionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationSessionConfigurationResponse> getApplicationSessionConfiguration(
            GetApplicationSessionConfigurationRequest getApplicationSessionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the session configuration for an application in IAM Identity Center.
     * </p>
     * <p>
     * The session configuration determines how users can access an application. This includes whether user background
     * sessions are enabled. User background sessions allow users to start a job on a supported Amazon Web Services
     * managed application without having to remain signed in to an active session while the job runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationSessionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetApplicationSessionConfigurationRequest#builder()}
     * </p>
     *
     * @param getApplicationSessionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.GetApplicationSessionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetApplicationSessionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetApplicationSessionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationSessionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationSessionConfigurationResponse> getApplicationSessionConfiguration(
            Consumer<GetApplicationSessionConfigurationRequest.Builder> getApplicationSessionConfigurationRequest) {
        return getApplicationSessionConfiguration(GetApplicationSessionConfigurationRequest.builder()
                .applyMutation(getApplicationSessionConfigurationRequest).build());
    }

    /**
     * <p>
     * Obtains the inline policy assigned to the permission set.
     * </p>
     *
     * @param getInlinePolicyForPermissionSetRequest
     * @return A Java Future containing the result of the GetInlinePolicyForPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetInlinePolicyForPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInlinePolicyForPermissionSetResponse> getInlinePolicyForPermissionSet(
            GetInlinePolicyForPermissionSetRequest getInlinePolicyForPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains the inline policy assigned to the permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInlinePolicyForPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link GetInlinePolicyForPermissionSetRequest#builder()}
     * </p>
     *
     * @param getInlinePolicyForPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetInlinePolicyForPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetInlinePolicyForPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInlinePolicyForPermissionSetResponse> getInlinePolicyForPermissionSet(
            Consumer<GetInlinePolicyForPermissionSetRequest.Builder> getInlinePolicyForPermissionSetRequest) {
        return getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest.builder()
                .applyMutation(getInlinePolicyForPermissionSetRequest).build());
    }

    /**
     * <p>
     * Obtains the permissions boundary for a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param getPermissionsBoundaryForPermissionSetRequest
     * @return A Java Future containing the result of the GetPermissionsBoundaryForPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetPermissionsBoundaryForPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetPermissionsBoundaryForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPermissionsBoundaryForPermissionSetResponse> getPermissionsBoundaryForPermissionSet(
            GetPermissionsBoundaryForPermissionSetRequest getPermissionsBoundaryForPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains the permissions boundary for a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetPermissionsBoundaryForPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link GetPermissionsBoundaryForPermissionSetRequest#builder()}
     * </p>
     *
     * @param getPermissionsBoundaryForPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetPermissionsBoundaryForPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetPermissionsBoundaryForPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetPermissionsBoundaryForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPermissionsBoundaryForPermissionSetResponse> getPermissionsBoundaryForPermissionSet(
            Consumer<GetPermissionsBoundaryForPermissionSetRequest.Builder> getPermissionsBoundaryForPermissionSetRequest) {
        return getPermissionsBoundaryForPermissionSet(GetPermissionsBoundaryForPermissionSetRequest.builder()
                .applyMutation(getPermissionsBoundaryForPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the status of the Amazon Web Services account assignment creation requests for a specified IAM Identity
     * Center instance.
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return A Java Future containing the result of the ListAccountAssignmentCreationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentCreationStatusResponse> listAccountAssignmentCreationStatus(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the Amazon Web Services account assignment creation requests for a specified IAM Identity
     * Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentCreationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAccountAssignmentCreationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentCreationStatusResponse> listAccountAssignmentCreationStatus(
            Consumer<ListAccountAssignmentCreationStatusRequest.Builder> listAccountAssignmentCreationStatusRequest) {
        return listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(listAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentCreationStatusPublisher listAccountAssignmentCreationStatusPaginator(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest) {
        return new ListAccountAssignmentCreationStatusPublisher(this, listAccountAssignmentCreationStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentCreationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentCreationStatusPublisher listAccountAssignmentCreationStatusPaginator(
            Consumer<ListAccountAssignmentCreationStatusRequest.Builder> listAccountAssignmentCreationStatusRequest) {
        return listAccountAssignmentCreationStatusPaginator(ListAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(listAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the Amazon Web Services account assignment deletion requests for a specified IAM Identity
     * Center instance.
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return A Java Future containing the result of the ListAccountAssignmentDeletionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentDeletionStatusResponse> listAccountAssignmentDeletionStatus(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the Amazon Web Services account assignment deletion requests for a specified IAM Identity
     * Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentDeletionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAccountAssignmentDeletionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentDeletionStatusResponse> listAccountAssignmentDeletionStatus(
            Consumer<ListAccountAssignmentDeletionStatusRequest.Builder> listAccountAssignmentDeletionStatusRequest) {
        return listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(listAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentDeletionStatusPublisher listAccountAssignmentDeletionStatusPaginator(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest) {
        return new ListAccountAssignmentDeletionStatusPublisher(this, listAccountAssignmentDeletionStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentDeletionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentDeletionStatusPublisher listAccountAssignmentDeletionStatusPaginator(
            Consumer<ListAccountAssignmentDeletionStatusRequest.Builder> listAccountAssignmentDeletionStatusRequest) {
        return listAccountAssignmentDeletionStatusPaginator(ListAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(listAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Lists the assignee of the specified Amazon Web Services account with the specified permission set.
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return A Java Future containing the result of the ListAccountAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentsResponse> listAccountAssignments(
            ListAccountAssignmentsRequest listAccountAssignmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assignee of the specified Amazon Web Services account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAssignmentsRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAccountAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentsResponse> listAccountAssignments(
            Consumer<ListAccountAssignmentsRequest.Builder> listAccountAssignmentsRequest) {
        return listAccountAssignments(ListAccountAssignmentsRequest.builder().applyMutation(listAccountAssignmentsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of the IAM Identity Center associated Amazon Web Services accounts that the principal has access
     * to. This action must be called from the management account containing your organization instance of IAM Identity
     * Center. This action is not valid for account instances of IAM Identity Center.
     * </p>
     *
     * @param listAccountAssignmentsForPrincipalRequest
     * @return A Java Future containing the result of the ListAccountAssignmentsForPrincipal operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentsForPrincipal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentsForPrincipal"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentsForPrincipalResponse> listAccountAssignmentsForPrincipal(
            ListAccountAssignmentsForPrincipalRequest listAccountAssignmentsForPrincipalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the IAM Identity Center associated Amazon Web Services accounts that the principal has access
     * to. This action must be called from the management account containing your organization instance of IAM Identity
     * Center. This action is not valid for account instances of IAM Identity Center.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentsForPrincipalRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentsForPrincipalRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentsForPrincipalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAccountAssignmentsForPrincipal operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentsForPrincipal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentsForPrincipal"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentsForPrincipalResponse> listAccountAssignmentsForPrincipal(
            Consumer<ListAccountAssignmentsForPrincipalRequest.Builder> listAccountAssignmentsForPrincipalRequest) {
        return listAccountAssignmentsForPrincipal(ListAccountAssignmentsForPrincipalRequest.builder()
                .applyMutation(listAccountAssignmentsForPrincipalRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentsForPrincipal(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsForPrincipalPublisher publisher = client.listAccountAssignmentsForPrincipalPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsForPrincipalPublisher publisher = client.listAccountAssignmentsForPrincipalPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentsForPrincipal(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentsForPrincipalRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentsForPrincipal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentsForPrincipal"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsForPrincipalPublisher listAccountAssignmentsForPrincipalPaginator(
            ListAccountAssignmentsForPrincipalRequest listAccountAssignmentsForPrincipalRequest) {
        return new ListAccountAssignmentsForPrincipalPublisher(this, listAccountAssignmentsForPrincipalRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentsForPrincipal(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsForPrincipalPublisher publisher = client.listAccountAssignmentsForPrincipalPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsForPrincipalPublisher publisher = client.listAccountAssignmentsForPrincipalPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentsForPrincipal(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentsForPrincipalRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentsForPrincipalRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentsForPrincipalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentsForPrincipal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentsForPrincipal"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsForPrincipalPublisher listAccountAssignmentsForPrincipalPaginator(
            Consumer<ListAccountAssignmentsForPrincipalRequest.Builder> listAccountAssignmentsForPrincipalRequest) {
        return listAccountAssignmentsForPrincipalPaginator(ListAccountAssignmentsForPrincipalRequest.builder()
                .applyMutation(listAccountAssignmentsForPrincipalRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsPublisher listAccountAssignmentsPaginator(
            ListAccountAssignmentsRequest listAccountAssignmentsRequest) {
        return new ListAccountAssignmentsPublisher(this, listAccountAssignmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAssignmentsRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsPublisher listAccountAssignmentsPaginator(
            Consumer<ListAccountAssignmentsRequest.Builder> listAccountAssignmentsRequest) {
        return listAccountAssignmentsPaginator(ListAccountAssignmentsRequest.builder()
                .applyMutation(listAccountAssignmentsRequest).build());
    }

    /**
     * <p>
     * Lists all the Amazon Web Services accounts where the specified permission set is provisioned.
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return A Java Future containing the result of the ListAccountsForProvisionedPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountsForProvisionedPermissionSetResponse> listAccountsForProvisionedPermissionSet(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the Amazon Web Services accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAccountsForProvisionedPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link ListAccountsForProvisionedPermissionSetRequest#builder()}
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAccountsForProvisionedPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountsForProvisionedPermissionSetResponse> listAccountsForProvisionedPermissionSet(
            Consumer<ListAccountsForProvisionedPermissionSetRequest.Builder> listAccountsForProvisionedPermissionSetRequest) {
        return listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest.builder()
                .applyMutation(listAccountsForProvisionedPermissionSetRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsForProvisionedPermissionSetPublisher listAccountsForProvisionedPermissionSetPaginator(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest) {
        return new ListAccountsForProvisionedPermissionSetPublisher(this, listAccountsForProvisionedPermissionSetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAccountsForProvisionedPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link ListAccountsForProvisionedPermissionSetRequest#builder()}
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsForProvisionedPermissionSetPublisher listAccountsForProvisionedPermissionSetPaginator(
            Consumer<ListAccountsForProvisionedPermissionSetRequest.Builder> listAccountsForProvisionedPermissionSetRequest) {
        return listAccountsForProvisionedPermissionSetPaginator(ListAccountsForProvisionedPermissionSetRequest.builder()
                .applyMutation(listAccountsForProvisionedPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the access scopes and authorized targets associated with an application.
     * </p>
     *
     * @param listApplicationAccessScopesRequest
     * @return A Java Future containing the result of the ListApplicationAccessScopes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAccessScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAccessScopes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationAccessScopesResponse> listApplicationAccessScopes(
            ListApplicationAccessScopesRequest listApplicationAccessScopesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the access scopes and authorized targets associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationAccessScopesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationAccessScopesRequest#builder()}
     * </p>
     *
     * @param listApplicationAccessScopesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListApplicationAccessScopes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAccessScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAccessScopes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationAccessScopesResponse> listApplicationAccessScopes(
            Consumer<ListApplicationAccessScopesRequest.Builder> listApplicationAccessScopesRequest) {
        return listApplicationAccessScopes(ListApplicationAccessScopesRequest.builder()
                .applyMutation(listApplicationAccessScopesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationAccessScopes(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAccessScopesPublisher publisher = client.listApplicationAccessScopesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAccessScopesPublisher publisher = client.listApplicationAccessScopesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationAccessScopes(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationAccessScopesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAccessScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAccessScopes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationAccessScopesPublisher listApplicationAccessScopesPaginator(
            ListApplicationAccessScopesRequest listApplicationAccessScopesRequest) {
        return new ListApplicationAccessScopesPublisher(this, listApplicationAccessScopesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationAccessScopes(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAccessScopesPublisher publisher = client.listApplicationAccessScopesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAccessScopesPublisher publisher = client.listApplicationAccessScopesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationAccessScopes(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationAccessScopesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationAccessScopesRequest#builder()}
     * </p>
     *
     * @param listApplicationAccessScopesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAccessScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAccessScopes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationAccessScopesPublisher listApplicationAccessScopesPaginator(
            Consumer<ListApplicationAccessScopesRequest.Builder> listApplicationAccessScopesRequest) {
        return listApplicationAccessScopesPaginator(ListApplicationAccessScopesRequest.builder()
                .applyMutation(listApplicationAccessScopesRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Web Services account users that are assigned to an application.
     * </p>
     *
     * @param listApplicationAssignmentsRequest
     * @return A Java Future containing the result of the ListApplicationAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationAssignmentsResponse> listApplicationAssignments(
            ListApplicationAssignmentsRequest listApplicationAssignmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Web Services account users that are assigned to an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationAssignmentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationAssignmentsRequest#builder()}
     * </p>
     *
     * @param listApplicationAssignmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListApplicationAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationAssignmentsResponse> listApplicationAssignments(
            Consumer<ListApplicationAssignmentsRequest.Builder> listApplicationAssignmentsRequest) {
        return listApplicationAssignments(ListApplicationAssignmentsRequest.builder()
                .applyMutation(listApplicationAssignmentsRequest).build());
    }

    /**
     * <p>
     * Lists the applications to which a specified principal is assigned. You must provide a filter when calling this
     * action from a member account against your organization instance of IAM Identity Center. A filter is not required
     * when called from the management account against an organization instance of IAM Identity Center, or from a member
     * account against an account instance of IAM Identity Center in the same account.
     * </p>
     *
     * @param listApplicationAssignmentsForPrincipalRequest
     * @return A Java Future containing the result of the ListApplicationAssignmentsForPrincipal operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAssignmentsForPrincipal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignmentsForPrincipal"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationAssignmentsForPrincipalResponse> listApplicationAssignmentsForPrincipal(
            ListApplicationAssignmentsForPrincipalRequest listApplicationAssignmentsForPrincipalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications to which a specified principal is assigned. You must provide a filter when calling this
     * action from a member account against your organization instance of IAM Identity Center. A filter is not required
     * when called from the management account against an organization instance of IAM Identity Center, or from a member
     * account against an account instance of IAM Identity Center in the same account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListApplicationAssignmentsForPrincipalRequest.Builder} avoiding the need to create one manually via
     * {@link ListApplicationAssignmentsForPrincipalRequest#builder()}
     * </p>
     *
     * @param listApplicationAssignmentsForPrincipalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListApplicationAssignmentsForPrincipal operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAssignmentsForPrincipal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignmentsForPrincipal"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationAssignmentsForPrincipalResponse> listApplicationAssignmentsForPrincipal(
            Consumer<ListApplicationAssignmentsForPrincipalRequest.Builder> listApplicationAssignmentsForPrincipalRequest) {
        return listApplicationAssignmentsForPrincipal(ListApplicationAssignmentsForPrincipalRequest.builder()
                .applyMutation(listApplicationAssignmentsForPrincipalRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationAssignmentsForPrincipal(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsForPrincipalPublisher publisher = client.listApplicationAssignmentsForPrincipalPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsForPrincipalPublisher publisher = client.listApplicationAssignmentsForPrincipalPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationAssignmentsForPrincipal(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationAssignmentsForPrincipalRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAssignmentsForPrincipal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignmentsForPrincipal"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationAssignmentsForPrincipalPublisher listApplicationAssignmentsForPrincipalPaginator(
            ListApplicationAssignmentsForPrincipalRequest listApplicationAssignmentsForPrincipalRequest) {
        return new ListApplicationAssignmentsForPrincipalPublisher(this, listApplicationAssignmentsForPrincipalRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationAssignmentsForPrincipal(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsForPrincipalPublisher publisher = client.listApplicationAssignmentsForPrincipalPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsForPrincipalPublisher publisher = client.listApplicationAssignmentsForPrincipalPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationAssignmentsForPrincipal(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListApplicationAssignmentsForPrincipalRequest.Builder} avoiding the need to create one manually via
     * {@link ListApplicationAssignmentsForPrincipalRequest#builder()}
     * </p>
     *
     * @param listApplicationAssignmentsForPrincipalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAssignmentsForPrincipal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignmentsForPrincipal"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationAssignmentsForPrincipalPublisher listApplicationAssignmentsForPrincipalPaginator(
            Consumer<ListApplicationAssignmentsForPrincipalRequest.Builder> listApplicationAssignmentsForPrincipalRequest) {
        return listApplicationAssignmentsForPrincipalPaginator(ListApplicationAssignmentsForPrincipalRequest.builder()
                .applyMutation(listApplicationAssignmentsForPrincipalRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationAssignments(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsPublisher publisher = client.listApplicationAssignmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsPublisher publisher = client.listApplicationAssignmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationAssignments(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationAssignmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationAssignmentsPublisher listApplicationAssignmentsPaginator(
            ListApplicationAssignmentsRequest listApplicationAssignmentsRequest) {
        return new ListApplicationAssignmentsPublisher(this, listApplicationAssignmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationAssignments(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsPublisher publisher = client.listApplicationAssignmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAssignmentsPublisher publisher = client.listApplicationAssignmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationAssignments(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationAssignmentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationAssignmentsRequest#builder()}
     * </p>
     *
     * @param listApplicationAssignmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationAssignmentsPublisher listApplicationAssignmentsPaginator(
            Consumer<ListApplicationAssignmentsRequest.Builder> listApplicationAssignmentsRequest) {
        return listApplicationAssignmentsPaginator(ListApplicationAssignmentsRequest.builder()
                .applyMutation(listApplicationAssignmentsRequest).build());
    }

    /**
     * <p>
     * Lists all of the authentication methods supported by the specified application.
     * </p>
     *
     * @param listApplicationAuthenticationMethodsRequest
     * @return A Java Future containing the result of the ListApplicationAuthenticationMethods operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAuthenticationMethods
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAuthenticationMethods"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationAuthenticationMethodsResponse> listApplicationAuthenticationMethods(
            ListApplicationAuthenticationMethodsRequest listApplicationAuthenticationMethodsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the authentication methods supported by the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListApplicationAuthenticationMethodsRequest.Builder} avoiding the need to create one manually via
     * {@link ListApplicationAuthenticationMethodsRequest#builder()}
     * </p>
     *
     * @param listApplicationAuthenticationMethodsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListApplicationAuthenticationMethods operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAuthenticationMethods
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAuthenticationMethods"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationAuthenticationMethodsResponse> listApplicationAuthenticationMethods(
            Consumer<ListApplicationAuthenticationMethodsRequest.Builder> listApplicationAuthenticationMethodsRequest) {
        return listApplicationAuthenticationMethods(ListApplicationAuthenticationMethodsRequest.builder()
                .applyMutation(listApplicationAuthenticationMethodsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationAuthenticationMethods(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAuthenticationMethodsPublisher publisher = client.listApplicationAuthenticationMethodsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAuthenticationMethodsPublisher publisher = client.listApplicationAuthenticationMethodsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationAuthenticationMethods(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationAuthenticationMethodsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAuthenticationMethods
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAuthenticationMethods"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationAuthenticationMethodsPublisher listApplicationAuthenticationMethodsPaginator(
            ListApplicationAuthenticationMethodsRequest listApplicationAuthenticationMethodsRequest) {
        return new ListApplicationAuthenticationMethodsPublisher(this, listApplicationAuthenticationMethodsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationAuthenticationMethods(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAuthenticationMethodsPublisher publisher = client.listApplicationAuthenticationMethodsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationAuthenticationMethodsPublisher publisher = client.listApplicationAuthenticationMethodsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationAuthenticationMethods(software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListApplicationAuthenticationMethodsRequest.Builder} avoiding the need to create one manually via
     * {@link ListApplicationAuthenticationMethodsRequest#builder()}
     * </p>
     *
     * @param listApplicationAuthenticationMethodsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationAuthenticationMethods
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAuthenticationMethods"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationAuthenticationMethodsPublisher listApplicationAuthenticationMethodsPaginator(
            Consumer<ListApplicationAuthenticationMethodsRequest.Builder> listApplicationAuthenticationMethodsRequest) {
        return listApplicationAuthenticationMethodsPaginator(ListApplicationAuthenticationMethodsRequest.builder()
                .applyMutation(listApplicationAuthenticationMethodsRequest).build());
    }

    /**
     * <p>
     * List the grants associated with an application.
     * </p>
     *
     * @param listApplicationGrantsRequest
     * @return A Java Future containing the result of the ListApplicationGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationGrantsResponse> listApplicationGrants(
            ListApplicationGrantsRequest listApplicationGrantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the grants associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListApplicationGrantsRequest#builder()}
     * </p>
     *
     * @param listApplicationGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplicationGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationGrantsResponse> listApplicationGrants(
            Consumer<ListApplicationGrantsRequest.Builder> listApplicationGrantsRequest) {
        return listApplicationGrants(ListApplicationGrantsRequest.builder().applyMutation(listApplicationGrantsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationGrants(software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationGrantsPublisher publisher = client.listApplicationGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationGrantsPublisher publisher = client.listApplicationGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationGrants(software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationGrantsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationGrantsPublisher listApplicationGrantsPaginator(
            ListApplicationGrantsRequest listApplicationGrantsRequest) {
        return new ListApplicationGrantsPublisher(this, listApplicationGrantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationGrants(software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationGrantsPublisher publisher = client.listApplicationGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationGrantsPublisher publisher = client.listApplicationGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationGrants(software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListApplicationGrantsRequest#builder()}
     * </p>
     *
     * @param listApplicationGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationGrantsPublisher listApplicationGrantsPaginator(
            Consumer<ListApplicationGrantsRequest.Builder> listApplicationGrantsRequest) {
        return listApplicationGrantsPaginator(ListApplicationGrantsRequest.builder().applyMutation(listApplicationGrantsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the application providers configured in the IAM Identity Center identity store.
     * </p>
     *
     * @param listApplicationProvidersRequest
     * @return A Java Future containing the result of the ListApplicationProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationProvidersResponse> listApplicationProviders(
            ListApplicationProvidersRequest listApplicationProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the application providers configured in the IAM Identity Center identity store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationProvidersRequest#builder()}
     * </p>
     *
     * @param listApplicationProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplicationProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationProvidersResponse> listApplicationProviders(
            Consumer<ListApplicationProvidersRequest.Builder> listApplicationProvidersRequest) {
        return listApplicationProviders(ListApplicationProvidersRequest.builder().applyMutation(listApplicationProvidersRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationProviders(software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationProvidersPublisher publisher = client.listApplicationProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationProvidersPublisher publisher = client.listApplicationProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationProviders(software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationProvidersPublisher listApplicationProvidersPaginator(
            ListApplicationProvidersRequest listApplicationProvidersRequest) {
        return new ListApplicationProvidersPublisher(this, listApplicationProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationProviders(software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationProvidersPublisher publisher = client.listApplicationProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationProvidersPublisher publisher = client.listApplicationProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationProviders(software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationProvidersRequest#builder()}
     * </p>
     *
     * @param listApplicationProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplicationProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationProvidersPublisher listApplicationProvidersPaginator(
            Consumer<ListApplicationProvidersRequest.Builder> listApplicationProvidersRequest) {
        return listApplicationProvidersPaginator(ListApplicationProvidersRequest.builder()
                .applyMutation(listApplicationProvidersRequest).build());
    }

    /**
     * <p>
     * Lists all applications associated with the instance of IAM Identity Center. When listing applications for an
     * organization instance in the management account, member accounts must use the <code>applicationAccount</code>
     * parameter to filter the list to only applications created from that account. When listing applications for an
     * account instance in the same member account, a filter is not required.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all applications associated with the instance of IAM Identity Center. When listing applications for an
     * organization instance in the management account, member accounts must use the <code>applicationAccount</code>
     * parameter to filter the list to only applications created from that account. When listing applications for an
     * account instance in the same member account, a filter is not required.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest)} operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        return new ListApplicationsPublisher(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists all customer managed policies attached to a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     * @return A Java Future containing the result of the ListCustomerManagedPolicyReferencesInPermissionSet operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomerManagedPolicyReferencesInPermissionSetResponse> listCustomerManagedPolicyReferencesInPermissionSet(
            ListCustomerManagedPolicyReferencesInPermissionSetRequest listCustomerManagedPolicyReferencesInPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all customer managed policies attached to a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder} avoiding the need to create one
     * manually via {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCustomerManagedPolicyReferencesInPermissionSet operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomerManagedPolicyReferencesInPermissionSetResponse> listCustomerManagedPolicyReferencesInPermissionSet(
            Consumer<ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder> listCustomerManagedPolicyReferencesInPermissionSetRequest) {
        return listCustomerManagedPolicyReferencesInPermissionSet(ListCustomerManagedPolicyReferencesInPermissionSetRequest
                .builder().applyMutation(listCustomerManagedPolicyReferencesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetPublisher publisher = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetPublisher publisher = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomerManagedPolicyReferencesInPermissionSetPublisher listCustomerManagedPolicyReferencesInPermissionSetPaginator(
            ListCustomerManagedPolicyReferencesInPermissionSetRequest listCustomerManagedPolicyReferencesInPermissionSetRequest) {
        return new ListCustomerManagedPolicyReferencesInPermissionSetPublisher(this,
                listCustomerManagedPolicyReferencesInPermissionSetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetPublisher publisher = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetPublisher publisher = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder} avoiding the need to create one
     * manually via {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomerManagedPolicyReferencesInPermissionSetPublisher listCustomerManagedPolicyReferencesInPermissionSetPaginator(
            Consumer<ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder> listCustomerManagedPolicyReferencesInPermissionSetRequest) {
        return listCustomerManagedPolicyReferencesInPermissionSetPaginator(ListCustomerManagedPolicyReferencesInPermissionSetRequest
                .builder().applyMutation(listCustomerManagedPolicyReferencesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the details of the organization and account instances of IAM Identity Center that were created in or
     * visible to the account calling this API.
     * </p>
     *
     * @param listInstancesRequest
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of the organization and account instances of IAM Identity Center that were created in or
     * visible to the account calling this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(ListInstancesRequest listInstancesRequest) {
        return new ListInstancesPublisher(this, listInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Web Services managed policy that is attached to a specified permission set.
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return A Java Future containing the result of the ListManagedPoliciesInPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedPoliciesInPermissionSetResponse> listManagedPoliciesInPermissionSet(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Web Services managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedPoliciesInPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedPoliciesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListManagedPoliciesInPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedPoliciesInPermissionSetResponse> listManagedPoliciesInPermissionSet(
            Consumer<ListManagedPoliciesInPermissionSetRequest.Builder> listManagedPoliciesInPermissionSetRequest) {
        return listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest.builder()
                .applyMutation(listManagedPoliciesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedPoliciesInPermissionSetPublisher listManagedPoliciesInPermissionSetPaginator(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest) {
        return new ListManagedPoliciesInPermissionSetPublisher(this, listManagedPoliciesInPermissionSetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedPoliciesInPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedPoliciesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedPoliciesInPermissionSetPublisher listManagedPoliciesInPermissionSetPaginator(
            Consumer<ListManagedPoliciesInPermissionSetRequest.Builder> listManagedPoliciesInPermissionSetRequest) {
        return listManagedPoliciesInPermissionSetPaginator(ListManagedPoliciesInPermissionSetRequest.builder()
                .applyMutation(listManagedPoliciesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return A Java Future containing the result of the ListPermissionSetProvisioningStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetProvisioningStatusResponse> listPermissionSetProvisioningStatus(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetProvisioningStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListPermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListPermissionSetProvisioningStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetProvisioningStatusResponse> listPermissionSetProvisioningStatus(
            Consumer<ListPermissionSetProvisioningStatusRequest.Builder> listPermissionSetProvisioningStatusRequest) {
        return listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest.builder()
                .applyMutation(listPermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetProvisioningStatusPublisher listPermissionSetProvisioningStatusPaginator(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest) {
        return new ListPermissionSetProvisioningStatusPublisher(this, listPermissionSetProvisioningStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetProvisioningStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListPermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetProvisioningStatusPublisher listPermissionSetProvisioningStatusPaginator(
            Consumer<ListPermissionSetProvisioningStatusRequest.Builder> listPermissionSetProvisioningStatusRequest) {
        return listPermissionSetProvisioningStatusPaginator(ListPermissionSetProvisioningStatusRequest.builder()
                .applyMutation(listPermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return A Java Future containing the result of the ListPermissionSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetsResponse> listPermissionSets(ListPermissionSetsRequest listPermissionSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionSetsRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPermissionSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetsResponse> listPermissionSets(
            Consumer<ListPermissionSetsRequest.Builder> listPermissionSetsRequest) {
        return listPermissionSets(ListPermissionSetsRequest.builder().applyMutation(listPermissionSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionSetsPublisher listPermissionSetsPaginator(ListPermissionSetsRequest listPermissionSetsRequest) {
        return new ListPermissionSetsPublisher(this, listPermissionSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionSetsRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionSetsPublisher listPermissionSetsPaginator(
            Consumer<ListPermissionSetsRequest.Builder> listPermissionSetsRequest) {
        return listPermissionSetsPaginator(ListPermissionSetsRequest.builder().applyMutation(listPermissionSetsRequest).build());
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified Amazon Web Services account.
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return A Java Future containing the result of the ListPermissionSetsProvisionedToAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetsProvisionedToAccountResponse> listPermissionSetsProvisionedToAccount(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPermissionSetsProvisionedToAccountRequest.Builder} avoiding the need to create one manually via
     * {@link ListPermissionSetsProvisionedToAccountRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListPermissionSetsProvisionedToAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetsProvisionedToAccountResponse> listPermissionSetsProvisionedToAccount(
            Consumer<ListPermissionSetsProvisionedToAccountRequest.Builder> listPermissionSetsProvisionedToAccountRequest) {
        return listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest.builder()
                .applyMutation(listPermissionSetsProvisionedToAccountRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetsProvisionedToAccountPublisher listPermissionSetsProvisionedToAccountPaginator(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest) {
        return new ListPermissionSetsProvisionedToAccountPublisher(this, listPermissionSetsProvisionedToAccountRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPermissionSetsProvisionedToAccountRequest.Builder} avoiding the need to create one manually via
     * {@link ListPermissionSetsProvisionedToAccountRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetsProvisionedToAccountPublisher listPermissionSetsProvisionedToAccountPaginator(
            Consumer<ListPermissionSetsProvisionedToAccountRequest.Builder> listPermissionSetsProvisionedToAccountRequest) {
        return listPermissionSetsProvisionedToAccountPaginator(ListPermissionSetsProvisionedToAccountRequest.builder()
                .applyMutation(listPermissionSetsProvisionedToAccountRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the trusted token issuers configured in an instance of IAM Identity Center.
     * </p>
     *
     * @param listTrustedTokenIssuersRequest
     * @return A Java Future containing the result of the ListTrustedTokenIssuers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTrustedTokenIssuers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTrustedTokenIssuers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrustedTokenIssuersResponse> listTrustedTokenIssuers(
            ListTrustedTokenIssuersRequest listTrustedTokenIssuersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the trusted token issuers configured in an instance of IAM Identity Center.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustedTokenIssuersRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrustedTokenIssuersRequest#builder()}
     * </p>
     *
     * @param listTrustedTokenIssuersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTrustedTokenIssuers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTrustedTokenIssuers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTrustedTokenIssuers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrustedTokenIssuersResponse> listTrustedTokenIssuers(
            Consumer<ListTrustedTokenIssuersRequest.Builder> listTrustedTokenIssuersRequest) {
        return listTrustedTokenIssuers(ListTrustedTokenIssuersRequest.builder().applyMutation(listTrustedTokenIssuersRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustedTokenIssuers(software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTrustedTokenIssuersPublisher publisher = client.listTrustedTokenIssuersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTrustedTokenIssuersPublisher publisher = client.listTrustedTokenIssuersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustedTokenIssuers(software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustedTokenIssuersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTrustedTokenIssuers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTrustedTokenIssuers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustedTokenIssuersPublisher listTrustedTokenIssuersPaginator(
            ListTrustedTokenIssuersRequest listTrustedTokenIssuersRequest) {
        return new ListTrustedTokenIssuersPublisher(this, listTrustedTokenIssuersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustedTokenIssuers(software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTrustedTokenIssuersPublisher publisher = client.listTrustedTokenIssuersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTrustedTokenIssuersPublisher publisher = client.listTrustedTokenIssuersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustedTokenIssuers(software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustedTokenIssuersRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrustedTokenIssuersRequest#builder()}
     * </p>
     *
     * @param listTrustedTokenIssuersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTrustedTokenIssuers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTrustedTokenIssuers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustedTokenIssuersPublisher listTrustedTokenIssuersPaginator(
            Consumer<ListTrustedTokenIssuersRequest.Builder> listTrustedTokenIssuersRequest) {
        return listTrustedTokenIssuersPaginator(ListTrustedTokenIssuersRequest.builder()
                .applyMutation(listTrustedTokenIssuersRequest).build());
    }

    /**
     * <p>
     * The process by which a specified permission set is provisioned to the specified target.
     * </p>
     *
     * @param provisionPermissionSetRequest
     * @return A Java Future containing the result of the ProvisionPermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ProvisionPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ProvisionPermissionSetResponse> provisionPermissionSet(
            ProvisionPermissionSetRequest provisionPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The process by which a specified permission set is provisioned to the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionPermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link ProvisionPermissionSetRequest#builder()}
     * </p>
     *
     * @param provisionPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ProvisionPermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ProvisionPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ProvisionPermissionSetResponse> provisionPermissionSet(
            Consumer<ProvisionPermissionSetRequest.Builder> provisionPermissionSetRequest) {
        return provisionPermissionSet(ProvisionPermissionSetRequest.builder().applyMutation(provisionPermissionSetRequest)
                .build());
    }

    /**
     * <p>
     * Adds or updates the list of authorized targets for an IAM Identity Center access scope for an application.
     * </p>
     *
     * @param putApplicationAccessScopeRequest
     * @return A Java Future containing the result of the PutApplicationAccessScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationAccessScopeResponse> putApplicationAccessScope(
            PutApplicationAccessScopeRequest putApplicationAccessScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates the list of authorized targets for an IAM Identity Center access scope for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutApplicationAccessScopeRequest.Builder} avoiding
     * the need to create one manually via {@link PutApplicationAccessScopeRequest#builder()}
     * </p>
     *
     * @param putApplicationAccessScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.PutApplicationAccessScopeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutApplicationAccessScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationAccessScopeResponse> putApplicationAccessScope(
            Consumer<PutApplicationAccessScopeRequest.Builder> putApplicationAccessScopeRequest) {
        return putApplicationAccessScope(PutApplicationAccessScopeRequest.builder()
                .applyMutation(putApplicationAccessScopeRequest).build());
    }

    /**
     * <p>
     * Configure how users gain access to an application. If <code>AssignmentsRequired</code> is <code>true</code>
     * (default value), users don’t have access to the application unless an assignment is created using the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
     * >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application. If an
     * assignment is created using <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
     * >CreateApplicationAssignment</a>., the user retains access if <code>AssignmentsRequired</code> is set to
     * <code>true</code>.
     * </p>
     *
     * @param putApplicationAssignmentConfigurationRequest
     * @return A Java Future containing the result of the PutApplicationAssignmentConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationAssignmentConfigurationResponse> putApplicationAssignmentConfiguration(
            PutApplicationAssignmentConfigurationRequest putApplicationAssignmentConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configure how users gain access to an application. If <code>AssignmentsRequired</code> is <code>true</code>
     * (default value), users don’t have access to the application unless an assignment is created using the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
     * >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application. If an
     * assignment is created using <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
     * >CreateApplicationAssignment</a>., the user retains access if <code>AssignmentsRequired</code> is set to
     * <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutApplicationAssignmentConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutApplicationAssignmentConfigurationRequest#builder()}
     * </p>
     *
     * @param putApplicationAssignmentConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.PutApplicationAssignmentConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutApplicationAssignmentConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationAssignmentConfigurationResponse> putApplicationAssignmentConfiguration(
            Consumer<PutApplicationAssignmentConfigurationRequest.Builder> putApplicationAssignmentConfigurationRequest) {
        return putApplicationAssignmentConfiguration(PutApplicationAssignmentConfigurationRequest.builder()
                .applyMutation(putApplicationAssignmentConfigurationRequest).build());
    }

    /**
     * <p>
     * Adds or updates an authentication method for an application.
     * </p>
     *
     * @param putApplicationAuthenticationMethodRequest
     * @return A Java Future containing the result of the PutApplicationAuthenticationMethod operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationAuthenticationMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAuthenticationMethod"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationAuthenticationMethodResponse> putApplicationAuthenticationMethod(
            PutApplicationAuthenticationMethodRequest putApplicationAuthenticationMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates an authentication method for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutApplicationAuthenticationMethodRequest.Builder}
     * avoiding the need to create one manually via {@link PutApplicationAuthenticationMethodRequest#builder()}
     * </p>
     *
     * @param putApplicationAuthenticationMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.PutApplicationAuthenticationMethodRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutApplicationAuthenticationMethod operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationAuthenticationMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAuthenticationMethod"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationAuthenticationMethodResponse> putApplicationAuthenticationMethod(
            Consumer<PutApplicationAuthenticationMethodRequest.Builder> putApplicationAuthenticationMethodRequest) {
        return putApplicationAuthenticationMethod(PutApplicationAuthenticationMethodRequest.builder()
                .applyMutation(putApplicationAuthenticationMethodRequest).build());
    }

    /**
     * <p>
     * Creates a configuration for an application to use grants. Conceptually grants are authorization to request
     * actions related to tokens. This configuration will be used when parties are requesting and receiving tokens
     * during the trusted identity propagation process. For more information on the IAM Identity Center supported grant
     * workflows, see <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/customermanagedapps-saml2-oauth2.html">SAML 2.0
     * and OAuth 2.0</a>.
     * </p>
     * <p>
     * A grant is created between your applications and Identity Center instance which enables an application to use
     * specified mechanisms to obtain tokens. These tokens are used by your applications to gain access to Amazon Web
     * Services resources on behalf of users. The following elements are within these exchanges:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Requester</b> - The application requesting access to Amazon Web Services resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Subject</b> - Typically the user that is requesting access to Amazon Web Services resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Grant</b> - Conceptually, a grant is authorization to access Amazon Web Services resources. These grants
     * authorize token generation for authenticating access to the requester and for the request to make requests on
     * behalf of the subjects. There are four types of grants:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AuthorizationCode</b> - Allows an application to request authorization through a series of user-agent
     * redirects.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>JWT bearer </b> - Authorizes an application to exchange a JSON Web Token that came from an external identity
     * provider. To learn more, see <a href="https://datatracker.ietf.org/doc/html/rfc6749">RFC 6479</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Refresh token</b> - Enables application to request new access tokens to replace expiring or expired access
     * tokens.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Exchange token</b> - A grant that requests tokens from the authorization server by providing a ‘subject’ token
     * with access scope authorizing trusted identity propagation to this application. To learn more, see <a
     * href="https://datatracker.ietf.org/doc/html/rfc8693">RFC 8693</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Authorization server</b> - IAM Identity Center requests tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * User credentials are never shared directly within these exchanges. Instead, applications use grants to request
     * access tokens from IAM Identity Center. For more information, see <a
     * href="https://datatracker.ietf.org/doc/html/rfc6749">RFC 6479</a>.
     * </p>
     * <p class="title">
     * <b>Use cases</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Connecting to custom applications.
     * </p>
     * </li>
     * <li>
     * <p>
     * Configuring an Amazon Web Services service to make calls to another Amazon Web Services services using JWT
     * tokens.
     * </p>
     * </li>
     * </ul>
     *
     * @param putApplicationGrantRequest
     * @return A Java Future containing the result of the PutApplicationGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutApplicationGrantResponse> putApplicationGrant(
            PutApplicationGrantRequest putApplicationGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration for an application to use grants. Conceptually grants are authorization to request
     * actions related to tokens. This configuration will be used when parties are requesting and receiving tokens
     * during the trusted identity propagation process. For more information on the IAM Identity Center supported grant
     * workflows, see <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/customermanagedapps-saml2-oauth2.html">SAML 2.0
     * and OAuth 2.0</a>.
     * </p>
     * <p>
     * A grant is created between your applications and Identity Center instance which enables an application to use
     * specified mechanisms to obtain tokens. These tokens are used by your applications to gain access to Amazon Web
     * Services resources on behalf of users. The following elements are within these exchanges:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Requester</b> - The application requesting access to Amazon Web Services resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Subject</b> - Typically the user that is requesting access to Amazon Web Services resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Grant</b> - Conceptually, a grant is authorization to access Amazon Web Services resources. These grants
     * authorize token generation for authenticating access to the requester and for the request to make requests on
     * behalf of the subjects. There are four types of grants:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AuthorizationCode</b> - Allows an application to request authorization through a series of user-agent
     * redirects.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>JWT bearer </b> - Authorizes an application to exchange a JSON Web Token that came from an external identity
     * provider. To learn more, see <a href="https://datatracker.ietf.org/doc/html/rfc6749">RFC 6479</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Refresh token</b> - Enables application to request new access tokens to replace expiring or expired access
     * tokens.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Exchange token</b> - A grant that requests tokens from the authorization server by providing a ‘subject’ token
     * with access scope authorizing trusted identity propagation to this application. To learn more, see <a
     * href="https://datatracker.ietf.org/doc/html/rfc8693">RFC 8693</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Authorization server</b> - IAM Identity Center requests tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * User credentials are never shared directly within these exchanges. Instead, applications use grants to request
     * access tokens from IAM Identity Center. For more information, see <a
     * href="https://datatracker.ietf.org/doc/html/rfc6749">RFC 6479</a>.
     * </p>
     * <p class="title">
     * <b>Use cases</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Connecting to custom applications.
     * </p>
     * </li>
     * <li>
     * <p>
     * Configuring an Amazon Web Services service to make calls to another Amazon Web Services services using JWT
     * tokens.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutApplicationGrantRequest.Builder} avoiding the
     * need to create one manually via {@link PutApplicationGrantRequest#builder()}
     * </p>
     *
     * @param putApplicationGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.PutApplicationGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutApplicationGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutApplicationGrantResponse> putApplicationGrant(
            Consumer<PutApplicationGrantRequest.Builder> putApplicationGrantRequest) {
        return putApplicationGrant(PutApplicationGrantRequest.builder().applyMutation(putApplicationGrantRequest).build());
    }

    /**
     * <p>
     * Updates the session configuration for an application in IAM Identity Center.
     * </p>
     * <p>
     * The session configuration determines how users can access an application. This includes whether user background
     * sessions are enabled. User background sessions allow users to start a job on a supported Amazon Web Services
     * managed application without having to remain signed in to an active session while the job runs.
     * </p>
     *
     * @param putApplicationSessionConfigurationRequest
     * @return A Java Future containing the result of the PutApplicationSessionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationSessionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationSessionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationSessionConfigurationResponse> putApplicationSessionConfiguration(
            PutApplicationSessionConfigurationRequest putApplicationSessionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the session configuration for an application in IAM Identity Center.
     * </p>
     * <p>
     * The session configuration determines how users can access an application. This includes whether user background
     * sessions are enabled. User background sessions allow users to start a job on a supported Amazon Web Services
     * managed application without having to remain signed in to an active session while the job runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutApplicationSessionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutApplicationSessionConfigurationRequest#builder()}
     * </p>
     *
     * @param putApplicationSessionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.PutApplicationSessionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutApplicationSessionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutApplicationSessionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationSessionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationSessionConfigurationResponse> putApplicationSessionConfiguration(
            Consumer<PutApplicationSessionConfigurationRequest.Builder> putApplicationSessionConfigurationRequest) {
        return putApplicationSessionConfiguration(PutApplicationSessionConfigurationRequest.builder()
                .applyMutation(putApplicationSessionConfigurationRequest).build());
    }

    /**
     * <p>
     * Attaches an inline policy to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note>
     *
     * @param putInlinePolicyToPermissionSetRequest
     * @return A Java Future containing the result of the PutInlinePolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutInlinePolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInlinePolicyToPermissionSetResponse> putInlinePolicyToPermissionSet(
            PutInlinePolicyToPermissionSetRequest putInlinePolicyToPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an inline policy to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInlinePolicyToPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link PutInlinePolicyToPermissionSetRequest#builder()}
     * </p>
     *
     * @param putInlinePolicyToPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutInlinePolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutInlinePolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInlinePolicyToPermissionSetResponse> putInlinePolicyToPermissionSet(
            Consumer<PutInlinePolicyToPermissionSetRequest.Builder> putInlinePolicyToPermissionSetRequest) {
        return putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest.builder()
                .applyMutation(putInlinePolicyToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Attaches an Amazon Web Services managed or customer managed policy to the specified <a>PermissionSet</a> as a
     * permissions boundary.
     * </p>
     *
     * @param putPermissionsBoundaryToPermissionSetRequest
     * @return A Java Future containing the result of the PutPermissionsBoundaryToPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutPermissionsBoundaryToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutPermissionsBoundaryToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutPermissionsBoundaryToPermissionSetResponse> putPermissionsBoundaryToPermissionSet(
            PutPermissionsBoundaryToPermissionSetRequest putPermissionsBoundaryToPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an Amazon Web Services managed or customer managed policy to the specified <a>PermissionSet</a> as a
     * permissions boundary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutPermissionsBoundaryToPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link PutPermissionsBoundaryToPermissionSetRequest#builder()}
     * </p>
     *
     * @param putPermissionsBoundaryToPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutPermissionsBoundaryToPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutPermissionsBoundaryToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutPermissionsBoundaryToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutPermissionsBoundaryToPermissionSetResponse> putPermissionsBoundaryToPermissionSet(
            Consumer<PutPermissionsBoundaryToPermissionSetRequest.Builder> putPermissionsBoundaryToPermissionSetRequest) {
        return putPermissionsBoundaryToPermissionSet(PutPermissionsBoundaryToPermissionSetRequest.builder()
                .applyMutation(putPermissionsBoundaryToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Associates a set of tags with a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of tags with a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates application properties.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates application properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.UpdateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Update the details for the instance of IAM Identity Center that is owned by the Amazon Web Services account.
     * </p>
     *
     * @param updateInstanceRequest
     * @return A Java Future containing the result of the UpdateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInstanceResponse> updateInstance(UpdateInstanceRequest updateInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the details for the instance of IAM Identity Center that is owned by the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInstanceRequest#builder()}
     * </p>
     *
     * @param updateInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInstanceResponse> updateInstance(Consumer<UpdateInstanceRequest.Builder> updateInstanceRequest) {
        return updateInstance(UpdateInstanceRequest.builder().applyMutation(updateInstanceRequest).build());
    }

    /**
     * <p>
     * Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance
     * for attributes-based access control (ABAC). When using an external identity provider as an identity source, you
     * can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity
     * Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the
     * attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see
     * <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity
     * Center User Guide</i>.
     * </p>
     *
     * @param updateInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the UpdateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInstanceAccessControlAttributeConfigurationResponse> updateInstanceAccessControlAttributeConfiguration(
            UpdateInstanceAccessControlAttributeConfigurationRequest updateInstanceAccessControlAttributeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance
     * for attributes-based access control (ABAC). When using an external identity provider as an identity source, you
     * can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity
     * Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the
     * attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see
     * <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity
     * Center User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link UpdateInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param updateInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInstanceAccessControlAttributeConfigurationResponse> updateInstanceAccessControlAttributeConfiguration(
            Consumer<UpdateInstanceAccessControlAttributeConfigurationRequest.Builder> updateInstanceAccessControlAttributeConfigurationRequest) {
        return updateInstanceAccessControlAttributeConfiguration(UpdateInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(updateInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing permission set.
     * </p>
     *
     * @param updatePermissionSetRequest
     * @return A Java Future containing the result of the UpdatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePermissionSetResponse> updatePermissionSet(
            UpdatePermissionSetRequest updatePermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePermissionSetRequest#builder()}
     * </p>
     *
     * @param updatePermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePermissionSetResponse> updatePermissionSet(
            Consumer<UpdatePermissionSetRequest.Builder> updatePermissionSetRequest) {
        return updatePermissionSet(UpdatePermissionSetRequest.builder().applyMutation(updatePermissionSetRequest).build());
    }

    /**
     * <p>
     * Updates the name of the trusted token issuer, or the path of a source attribute or destination attribute for a
     * trusted token issuer configuration.
     * </p>
     * <note>
     * <p>
     * Updating this trusted token issuer configuration might cause users to lose access to any applications that are
     * configured to use the trusted token issuer.
     * </p>
     * </note>
     *
     * @param updateTrustedTokenIssuerRequest
     * @return A Java Future containing the result of the UpdateTrustedTokenIssuer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateTrustedTokenIssuer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateTrustedTokenIssuer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrustedTokenIssuerResponse> updateTrustedTokenIssuer(
            UpdateTrustedTokenIssuerRequest updateTrustedTokenIssuerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of the trusted token issuer, or the path of a source attribute or destination attribute for a
     * trusted token issuer configuration.
     * </p>
     * <note>
     * <p>
     * Updating this trusted token issuer configuration might cause users to lose access to any applications that are
     * configured to use the trusted token issuer.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrustedTokenIssuerRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateTrustedTokenIssuerRequest#builder()}
     * </p>
     *
     * @param updateTrustedTokenIssuerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssoadmin.model.UpdateTrustedTokenIssuerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTrustedTokenIssuer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateTrustedTokenIssuer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateTrustedTokenIssuer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrustedTokenIssuerResponse> updateTrustedTokenIssuer(
            Consumer<UpdateTrustedTokenIssuerRequest.Builder> updateTrustedTokenIssuerRequest) {
        return updateTrustedTokenIssuer(UpdateTrustedTokenIssuerRequest.builder().applyMutation(updateTrustedTokenIssuerRequest)
                .build());
    }

    @Override
    default SsoAdminServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SsoAdminAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsoAdminAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsoAdminAsyncClient}.
     */
    static SsoAdminAsyncClientBuilder builder() {
        return new DefaultSsoAdminAsyncClientBuilder();
    }
}
