/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.GrantItem;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsResponse;

public class ListApplicationGrantsPublisher
implements SdkPublisher<ListApplicationGrantsResponse> {
    private final SsoAdminAsyncClient client;
    private final ListApplicationGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationGrantsPublisher(SsoAdminAsyncClient client, ListApplicationGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationGrantsPublisher(SsoAdminAsyncClient client, ListApplicationGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationGrantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationGrantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GrantItem> grants() {
        Function<ListApplicationGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grants() != null) {
                return response.grants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationGrantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationGrantsResponseFetcher
    implements AsyncPageFetcher<ListApplicationGrantsResponse> {
        private ListApplicationGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationGrantsResponse> nextPage(ListApplicationGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationGrantsPublisher.this.client.listApplicationGrants(ListApplicationGrantsPublisher.this.firstRequest);
            }
            return ListApplicationGrantsPublisher.this.client.listApplicationGrants((ListApplicationGrantsRequest)((Object)ListApplicationGrantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

