/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.GrantItem;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsResponse;

public class ListApplicationGrantsIterable
implements SdkIterable<ListApplicationGrantsResponse> {
    private final SsoAdminClient client;
    private final ListApplicationGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationGrantsIterable(SsoAdminClient client, ListApplicationGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationGrantsResponseFetcher();
    }

    public Iterator<ListApplicationGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GrantItem> grants() {
        Function<ListApplicationGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grants() != null) {
                return response.grants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationGrantsResponseFetcher
    implements SyncPageFetcher<ListApplicationGrantsResponse> {
        private ListApplicationGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationGrantsResponse nextPage(ListApplicationGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationGrantsIterable.this.client.listApplicationGrants(ListApplicationGrantsIterable.this.firstRequest);
            }
            return ListApplicationGrantsIterable.this.client.listApplicationGrants((ListApplicationGrantsRequest)((Object)ListApplicationGrantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

