/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssoadmin.model.IamAuthenticationMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationMethod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationMethod> {
    private static final SdkField<IamAuthenticationMethod> IAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Iam").getter(AuthenticationMethod.getter(AuthenticationMethod::iam)).setter(AuthenticationMethod.setter(Builder::iam)).constructor(IamAuthenticationMethod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iam").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Iam", IAM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final IamAuthenticationMethod iam;
    private final Type type;

    private AuthenticationMethod(BuilderImpl builder) {
        this.iam = builder.iam;
        this.type = builder.type;
    }

    public final IamAuthenticationMethod iam() {
        return this.iam;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iam());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMethod)) {
            return false;
        }
        AuthenticationMethod other = (AuthenticationMethod)obj;
        return Objects.equals(this.iam(), other.iam());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationMethod").add("Iam", (Object)this.iam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Iam": {
                return Optional.ofNullable(clazz.cast(this.iam()));
            }
        }
        return Optional.empty();
    }

    public static AuthenticationMethod fromIam(IamAuthenticationMethod iam) {
        return (AuthenticationMethod)AuthenticationMethod.builder().iam(iam).build();
    }

    public static AuthenticationMethod fromIam(Consumer<IamAuthenticationMethod.Builder> iam) {
        IamAuthenticationMethod.Builder builder = IamAuthenticationMethod.builder();
        iam.accept(builder);
        return AuthenticationMethod.fromIam((IamAuthenticationMethod)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationMethod, T> g) {
        return obj -> g.apply((AuthenticationMethod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        IAM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IamAuthenticationMethod iam;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationMethod model) {
            this.iam(model.iam);
        }

        public final IamAuthenticationMethod.Builder getIam() {
            return this.iam != null ? this.iam.toBuilder() : null;
        }

        public final void setIam(IamAuthenticationMethod.BuilderImpl iam) {
            IamAuthenticationMethod oldValue = this.iam;
            this.iam = iam != null ? iam.build() : null;
            this.handleUnionValueChange(Type.IAM, oldValue, this.iam);
        }

        @Override
        public final Builder iam(IamAuthenticationMethod iam) {
            IamAuthenticationMethod oldValue = this.iam;
            this.iam = iam;
            this.handleUnionValueChange(Type.IAM, oldValue, this.iam);
            return this;
        }

        public AuthenticationMethod build() {
            return new AuthenticationMethod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationMethod> {
        public Builder iam(IamAuthenticationMethod var1);

        default public Builder iam(Consumer<IamAuthenticationMethod.Builder> iam) {
            return this.iam((IamAuthenticationMethod)((IamAuthenticationMethod.Builder)IamAuthenticationMethod.builder().applyMutation(iam)).build());
        }
    }
}

