/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignment;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentListCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountAssignmentsResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListAccountAssignmentsResponse> {
    private static final SdkField<List<AccountAssignment>> ACCOUNT_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAccountAssignmentsResponse.getter(ListAccountAssignmentsResponse::accountAssignments)).setter(ListAccountAssignmentsResponse.setter(Builder::accountAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountAssignment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAccountAssignmentsResponse.getter(ListAccountAssignmentsResponse::nextToken)).setter(ListAccountAssignmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ASSIGNMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccountAssignment> accountAssignments;
    private final String nextToken;

    private ListAccountAssignmentsResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssignments = builder.accountAssignments;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAccountAssignments() {
        return this.accountAssignments != null && !(this.accountAssignments instanceof SdkAutoConstructList);
    }

    public List<AccountAssignment> accountAssignments() {
        return this.accountAssignments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssignmentsResponse)) {
            return false;
        }
        ListAccountAssignmentsResponse other = (ListAccountAssignmentsResponse)((Object)obj);
        return Objects.equals(this.accountAssignments(), other.accountAssignments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAccountAssignmentsResponse").add("AccountAssignments", this.accountAssignments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAssignments": {
                return Optional.ofNullable(clazz.cast(this.accountAssignments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssignmentsResponse, T> g) {
        return obj -> g.apply((ListAccountAssignmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<AccountAssignment> accountAssignments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssignmentsResponse model) {
            super(model);
            this.accountAssignments(model.accountAssignments);
            this.nextToken(model.nextToken);
        }

        public final Collection<AccountAssignment.Builder> getAccountAssignments() {
            return this.accountAssignments != null ? (Collection)this.accountAssignments.stream().map(AccountAssignment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAssignments(Collection<AccountAssignment> accountAssignments) {
            this.accountAssignments = AccountAssignmentListCopier.copy(accountAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignments(AccountAssignment ... accountAssignments) {
            this.accountAssignments(Arrays.asList(accountAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignments(Consumer<AccountAssignment.Builder> ... accountAssignments) {
            this.accountAssignments(Stream.of(accountAssignments).map(c -> (AccountAssignment)((AccountAssignment.Builder)AccountAssignment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountAssignments(Collection<AccountAssignment.BuilderImpl> accountAssignments) {
            this.accountAssignments = AccountAssignmentListCopier.copyFromBuilder(accountAssignments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccountAssignmentsResponse build() {
            return new ListAccountAssignmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountAssignmentsResponse> {
        public Builder accountAssignments(Collection<AccountAssignment> var1);

        public Builder accountAssignments(AccountAssignment ... var1);

        public Builder accountAssignments(Consumer<AccountAssignment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

