/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sso.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the role credentials that are assigned to the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoleCredentials implements SdkPojo, Serializable, ToCopyableBuilder<RoleCredentials.Builder, RoleCredentials> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessKeyId").getter(getter(RoleCredentials::accessKeyId)).setter(setter(Builder::accessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyId").build()).build();

    private static final SdkField<String> SECRET_ACCESS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretAccessKey").getter(getter(RoleCredentials::secretAccessKey))
            .setter(setter(Builder::secretAccessKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretAccessKey").build()).build();

    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionToken").getter(getter(RoleCredentials::sessionToken)).setter(setter(Builder::sessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()).build();

    private static final SdkField<Long> EXPIRATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("expiration")
            .getter(getter(RoleCredentials::expiration)).setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD,
            SECRET_ACCESS_KEY_FIELD, SESSION_TOKEN_FIELD, EXPIRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessKeyId;

    private final String secretAccessKey;

    private final String sessionToken;

    private final Long expiration;

    private RoleCredentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * The identifier used for the temporary security credentials. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary
     * Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
     * </p>
     * 
     * @return The identifier used for the temporary security credentials. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
     *         Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
     */
    public final String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The key that is used to sign the request. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary
     * Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
     * </p>
     * 
     * @return The key that is used to sign the request. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
     *         Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
     */
    public final String secretAccessKey() {
        return secretAccessKey;
    }

    /**
     * <p>
     * The token used for temporary credentials. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary
     * Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
     * </p>
     * 
     * @return The token used for temporary credentials. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
     *         Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
     */
    public final String sessionToken() {
        return sessionToken;
    }

    /**
     * <p>
     * The date on which temporary security credentials expire.
     * </p>
     * 
     * @return The date on which temporary security credentials expire.
     */
    public final Long expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleCredentials)) {
            return false;
        }
        RoleCredentials other = (RoleCredentials) obj;
        return Objects.equals(accessKeyId(), other.accessKeyId()) && Objects.equals(secretAccessKey(), other.secretAccessKey())
                && Objects.equals(sessionToken(), other.sessionToken()) && Objects.equals(expiration(), other.expiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoleCredentials").add("AccessKeyId", accessKeyId())
                .add("SecretAccessKey", secretAccessKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SessionToken", sessionToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Expiration", expiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessKeyId":
            return Optional.ofNullable(clazz.cast(accessKeyId()));
        case "secretAccessKey":
            return Optional.ofNullable(clazz.cast(secretAccessKey()));
        case "sessionToken":
            return Optional.ofNullable(clazz.cast(sessionToken()));
        case "expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessKeyId", ACCESS_KEY_ID_FIELD);
        map.put("secretAccessKey", SECRET_ACCESS_KEY_FIELD);
        map.put("sessionToken", SESSION_TOKEN_FIELD);
        map.put("expiration", EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoleCredentials, T> g) {
        return obj -> g.apply((RoleCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoleCredentials> {
        /**
         * <p>
         * The identifier used for the temporary security credentials. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
         * Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
         * </p>
         * 
         * @param accessKeyId
         *        The identifier used for the temporary security credentials. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
         *        Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The key that is used to sign the request. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
         * Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
         * </p>
         * 
         * @param secretAccessKey
         *        The key that is used to sign the request. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
         *        Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretAccessKey(String secretAccessKey);

        /**
         * <p>
         * The token used for temporary credentials. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
         * Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.
         * </p>
         * 
         * @param sessionToken
         *        The token used for temporary credentials. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using
         *        Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        /**
         * <p>
         * The date on which temporary security credentials expire.
         * </p>
         * 
         * @param expiration
         *        The date on which temporary security credentials expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Long expiration);
    }

    static final class BuilderImpl implements Builder {
        private String accessKeyId;

        private String secretAccessKey;

        private String sessionToken;

        private Long expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleCredentials model) {
            accessKeyId(model.accessKeyId);
            secretAccessKey(model.secretAccessKey);
            sessionToken(model.sessionToken);
            expiration(model.expiration);
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getSecretAccessKey() {
            return secretAccessKey;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final Long getExpiration() {
            return expiration;
        }

        public final void setExpiration(Long expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Long expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public RoleCredentials build() {
            return new RoleCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
