/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sso.DefaultSsoAsyncClient;
import software.amazon.awssdk.services.sso.DefaultSsoBaseClientBuilder;
import software.amazon.awssdk.services.sso.SsoAsyncClient;
import software.amazon.awssdk.services.sso.SsoAsyncClientBuilder;
import software.amazon.awssdk.services.sso.SsoServiceClientConfiguration;
import software.amazon.awssdk.services.sso.endpoints.SsoEndpointProvider;

@SdkInternalApi
final class DefaultSsoAsyncClientBuilder
extends DefaultSsoBaseClientBuilder<SsoAsyncClientBuilder, SsoAsyncClient>
implements SsoAsyncClientBuilder {
    DefaultSsoAsyncClientBuilder() {
    }

    @Override
    public DefaultSsoAsyncClientBuilder endpointProvider(SsoEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsoAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSsoAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SsoServiceClientConfiguration serviceClientConfiguration = SsoServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSsoAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

