/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsResponse;
import software.amazon.awssdk.services.ssmsap.model.RuleResult;

public class ListSubCheckRuleResultsPublisher
implements SdkPublisher<ListSubCheckRuleResultsResponse> {
    private final SsmSapAsyncClient client;
    private final ListSubCheckRuleResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubCheckRuleResultsPublisher(SsmSapAsyncClient client, ListSubCheckRuleResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubCheckRuleResultsPublisher(SsmSapAsyncClient client, ListSubCheckRuleResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubCheckRuleResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubCheckRuleResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RuleResult> ruleResults() {
        Function<ListSubCheckRuleResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleResults() != null) {
                return response.ruleResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSubCheckRuleResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubCheckRuleResultsResponseFetcher
    implements AsyncPageFetcher<ListSubCheckRuleResultsResponse> {
        private ListSubCheckRuleResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubCheckRuleResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubCheckRuleResultsResponse> nextPage(ListSubCheckRuleResultsResponse previousPage) {
            if (previousPage == null) {
                return ListSubCheckRuleResultsPublisher.this.client.listSubCheckRuleResults(ListSubCheckRuleResultsPublisher.this.firstRequest);
            }
            return ListSubCheckRuleResultsPublisher.this.client.listSubCheckRuleResults((ListSubCheckRuleResultsRequest)((Object)ListSubCheckRuleResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

