/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsResponse;
import software.amazon.awssdk.services.ssmsap.model.RuleResult;

public class ListSubCheckRuleResultsIterable
implements SdkIterable<ListSubCheckRuleResultsResponse> {
    private final SsmSapClient client;
    private final ListSubCheckRuleResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubCheckRuleResultsIterable(SsmSapClient client, ListSubCheckRuleResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubCheckRuleResultsResponseFetcher();
    }

    public Iterator<ListSubCheckRuleResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleResult> ruleResults() {
        Function<ListSubCheckRuleResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleResults() != null) {
                return response.ruleResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubCheckRuleResultsResponseFetcher
    implements SyncPageFetcher<ListSubCheckRuleResultsResponse> {
        private ListSubCheckRuleResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubCheckRuleResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubCheckRuleResultsResponse nextPage(ListSubCheckRuleResultsResponse previousPage) {
            if (previousPage == null) {
                return ListSubCheckRuleResultsIterable.this.client.listSubCheckRuleResults(ListSubCheckRuleResultsIterable.this.firstRequest);
            }
            return ListSubCheckRuleResultsIterable.this.client.listSubCheckRuleResults((ListSubCheckRuleResultsRequest)((Object)ListSubCheckRuleResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

