/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckType;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckTypeListCopier;
import software.amazon.awssdk.services.ssmsap.model.SsmSapRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartConfigurationChecksRequest
extends SsmSapRequest
implements ToCopyableBuilder<Builder, StartConfigurationChecksRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(StartConfigurationChecksRequest.getter(StartConfigurationChecksRequest::applicationId)).setter(StartConfigurationChecksRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<List<String>> CONFIGURATION_CHECK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationCheckIds").getter(StartConfigurationChecksRequest.getter(StartConfigurationChecksRequest::configurationCheckIdsAsStrings)).setter(StartConfigurationChecksRequest.setter(Builder::configurationCheckIdsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CONFIGURATION_CHECK_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartConfigurationChecksRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final List<String> configurationCheckIds;

    private StartConfigurationChecksRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configurationCheckIds = builder.configurationCheckIds;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final List<ConfigurationCheckType> configurationCheckIds() {
        return ConfigurationCheckTypeListCopier.copyStringToEnum(this.configurationCheckIds);
    }

    public final boolean hasConfigurationCheckIds() {
        return this.configurationCheckIds != null && !(this.configurationCheckIds instanceof SdkAutoConstructList);
    }

    public final List<String> configurationCheckIdsAsStrings() {
        return this.configurationCheckIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationCheckIds() ? this.configurationCheckIdsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigurationChecksRequest)) {
            return false;
        }
        StartConfigurationChecksRequest other = (StartConfigurationChecksRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && this.hasConfigurationCheckIds() == other.hasConfigurationCheckIds() && Objects.equals(this.configurationCheckIdsAsStrings(), other.configurationCheckIdsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"StartConfigurationChecksRequest").add("ApplicationId", (Object)this.applicationId()).add("ConfigurationCheckIds", this.hasConfigurationCheckIds() ? this.configurationCheckIdsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ConfigurationCheckIds": {
                return Optional.ofNullable(clazz.cast(this.configurationCheckIdsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ConfigurationCheckIds", CONFIGURATION_CHECK_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartConfigurationChecksRequest, T> g) {
        return obj -> g.apply((StartConfigurationChecksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private List<String> configurationCheckIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigurationChecksRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.configurationCheckIdsWithStrings(model.configurationCheckIds);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Collection<String> getConfigurationCheckIds() {
            if (this.configurationCheckIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurationCheckIds;
        }

        public final void setConfigurationCheckIds(Collection<String> configurationCheckIds) {
            this.configurationCheckIds = ConfigurationCheckTypeListCopier.copy(configurationCheckIds);
        }

        @Override
        public final Builder configurationCheckIdsWithStrings(Collection<String> configurationCheckIds) {
            this.configurationCheckIds = ConfigurationCheckTypeListCopier.copy(configurationCheckIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationCheckIdsWithStrings(String ... configurationCheckIds) {
            this.configurationCheckIdsWithStrings(Arrays.asList(configurationCheckIds));
            return this;
        }

        @Override
        public final Builder configurationCheckIds(Collection<ConfigurationCheckType> configurationCheckIds) {
            this.configurationCheckIds = ConfigurationCheckTypeListCopier.copyEnumToString(configurationCheckIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationCheckIds(ConfigurationCheckType ... configurationCheckIds) {
            this.configurationCheckIds(Arrays.asList(configurationCheckIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConfigurationChecksRequest build() {
            return new StartConfigurationChecksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmSapRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartConfigurationChecksRequest> {
        public Builder applicationId(String var1);

        public Builder configurationCheckIdsWithStrings(Collection<String> var1);

        public Builder configurationCheckIdsWithStrings(String ... var1);

        public Builder configurationCheckIds(Collection<ConfigurationCheckType> var1);

        public Builder configurationCheckIds(ConfigurationCheckType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

