/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.ConnectedEntityType;
import software.amazon.awssdk.services.ssmsap.model.SsmSapRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopApplicationRequest
extends SsmSapRequest
implements ToCopyableBuilder<Builder, StopApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(StopApplicationRequest.getter(StopApplicationRequest::applicationId)).setter(StopApplicationRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> STOP_CONNECTED_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StopConnectedEntity").getter(StopApplicationRequest.getter(StopApplicationRequest::stopConnectedEntityAsString)).setter(StopApplicationRequest.setter(Builder::stopConnectedEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopConnectedEntity").build()}).build();
    private static final SdkField<Boolean> INCLUDE_EC2_INSTANCE_SHUTDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeEc2InstanceShutdown").getter(StopApplicationRequest.getter(StopApplicationRequest::includeEc2InstanceShutdown)).setter(StopApplicationRequest.setter(Builder::includeEc2InstanceShutdown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeEc2InstanceShutdown").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, STOP_CONNECTED_ENTITY_FIELD, INCLUDE_EC2_INSTANCE_SHUTDOWN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StopApplicationRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String stopConnectedEntity;
    private final Boolean includeEc2InstanceShutdown;

    private StopApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.stopConnectedEntity = builder.stopConnectedEntity;
        this.includeEc2InstanceShutdown = builder.includeEc2InstanceShutdown;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final ConnectedEntityType stopConnectedEntity() {
        return ConnectedEntityType.fromValue(this.stopConnectedEntity);
    }

    public final String stopConnectedEntityAsString() {
        return this.stopConnectedEntity;
    }

    public final Boolean includeEc2InstanceShutdown() {
        return this.includeEc2InstanceShutdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopConnectedEntityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeEc2InstanceShutdown());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopApplicationRequest)) {
            return false;
        }
        StopApplicationRequest other = (StopApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.stopConnectedEntityAsString(), other.stopConnectedEntityAsString()) && Objects.equals(this.includeEc2InstanceShutdown(), other.includeEc2InstanceShutdown());
    }

    public final String toString() {
        return ToString.builder((String)"StopApplicationRequest").add("ApplicationId", (Object)this.applicationId()).add("StopConnectedEntity", (Object)this.stopConnectedEntityAsString()).add("IncludeEc2InstanceShutdown", (Object)this.includeEc2InstanceShutdown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "StopConnectedEntity": {
                return Optional.ofNullable(clazz.cast(this.stopConnectedEntityAsString()));
            }
            case "IncludeEc2InstanceShutdown": {
                return Optional.ofNullable(clazz.cast(this.includeEc2InstanceShutdown()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("StopConnectedEntity", STOP_CONNECTED_ENTITY_FIELD);
        map.put("IncludeEc2InstanceShutdown", INCLUDE_EC2_INSTANCE_SHUTDOWN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopApplicationRequest, T> g) {
        return obj -> g.apply((StopApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String stopConnectedEntity;
        private Boolean includeEc2InstanceShutdown;

        private BuilderImpl() {
        }

        private BuilderImpl(StopApplicationRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.stopConnectedEntity(model.stopConnectedEntity);
            this.includeEc2InstanceShutdown(model.includeEc2InstanceShutdown);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getStopConnectedEntity() {
            return this.stopConnectedEntity;
        }

        public final void setStopConnectedEntity(String stopConnectedEntity) {
            this.stopConnectedEntity = stopConnectedEntity;
        }

        @Override
        public final Builder stopConnectedEntity(String stopConnectedEntity) {
            this.stopConnectedEntity = stopConnectedEntity;
            return this;
        }

        @Override
        public final Builder stopConnectedEntity(ConnectedEntityType stopConnectedEntity) {
            this.stopConnectedEntity(stopConnectedEntity == null ? null : stopConnectedEntity.toString());
            return this;
        }

        public final Boolean getIncludeEc2InstanceShutdown() {
            return this.includeEc2InstanceShutdown;
        }

        public final void setIncludeEc2InstanceShutdown(Boolean includeEc2InstanceShutdown) {
            this.includeEc2InstanceShutdown = includeEc2InstanceShutdown;
        }

        @Override
        public final Builder includeEc2InstanceShutdown(Boolean includeEc2InstanceShutdown) {
            this.includeEc2InstanceShutdown = includeEc2InstanceShutdown;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopApplicationRequest build() {
            return new StopApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmSapRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopApplicationRequest> {
        public Builder applicationId(String var1);

        public Builder stopConnectedEntity(String var1);

        public Builder stopConnectedEntity(ConnectedEntityType var1);

        public Builder includeEc2InstanceShutdown(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

