/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.ApplicationCredential;
import software.amazon.awssdk.services.ssmsap.model.ApplicationCredentialListCopier;
import software.amazon.awssdk.services.ssmsap.model.BackintConfig;
import software.amazon.awssdk.services.ssmsap.model.SsmSapRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationSettingsRequest
extends SsmSapRequest
implements ToCopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateApplicationSettingsRequest.getter(UpdateApplicationSettingsRequest::applicationId)).setter(UpdateApplicationSettingsRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<List<ApplicationCredential>> CREDENTIALS_TO_ADD_OR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CredentialsToAddOrUpdate").getter(UpdateApplicationSettingsRequest.getter(UpdateApplicationSettingsRequest::credentialsToAddOrUpdate)).setter(UpdateApplicationSettingsRequest.setter(Builder::credentialsToAddOrUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialsToAddOrUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ApplicationCredential>> CREDENTIALS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CredentialsToRemove").getter(UpdateApplicationSettingsRequest.getter(UpdateApplicationSettingsRequest::credentialsToRemove)).setter(UpdateApplicationSettingsRequest.setter(Builder::credentialsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BackintConfig> BACKINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Backint").getter(UpdateApplicationSettingsRequest.getter(UpdateApplicationSettingsRequest::backint)).setter(UpdateApplicationSettingsRequest.setter(Builder::backint)).constructor(BackintConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backint").build()}).build();
    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseArn").getter(UpdateApplicationSettingsRequest.getter(UpdateApplicationSettingsRequest::databaseArn)).setter(UpdateApplicationSettingsRequest.setter(Builder::databaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CREDENTIALS_TO_ADD_OR_UPDATE_FIELD, CREDENTIALS_TO_REMOVE_FIELD, BACKINT_FIELD, DATABASE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApplicationSettingsRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final List<ApplicationCredential> credentialsToAddOrUpdate;
    private final List<ApplicationCredential> credentialsToRemove;
    private final BackintConfig backint;
    private final String databaseArn;

    private UpdateApplicationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.credentialsToAddOrUpdate = builder.credentialsToAddOrUpdate;
        this.credentialsToRemove = builder.credentialsToRemove;
        this.backint = builder.backint;
        this.databaseArn = builder.databaseArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final boolean hasCredentialsToAddOrUpdate() {
        return this.credentialsToAddOrUpdate != null && !(this.credentialsToAddOrUpdate instanceof SdkAutoConstructList);
    }

    public final List<ApplicationCredential> credentialsToAddOrUpdate() {
        return this.credentialsToAddOrUpdate;
    }

    public final boolean hasCredentialsToRemove() {
        return this.credentialsToRemove != null && !(this.credentialsToRemove instanceof SdkAutoConstructList);
    }

    public final List<ApplicationCredential> credentialsToRemove() {
        return this.credentialsToRemove;
    }

    public final BackintConfig backint() {
        return this.backint;
    }

    public final String databaseArn() {
        return this.databaseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentialsToAddOrUpdate() ? this.credentialsToAddOrUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentialsToRemove() ? this.credentialsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backint());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationSettingsRequest)) {
            return false;
        }
        UpdateApplicationSettingsRequest other = (UpdateApplicationSettingsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && this.hasCredentialsToAddOrUpdate() == other.hasCredentialsToAddOrUpdate() && Objects.equals(this.credentialsToAddOrUpdate(), other.credentialsToAddOrUpdate()) && this.hasCredentialsToRemove() == other.hasCredentialsToRemove() && Objects.equals(this.credentialsToRemove(), other.credentialsToRemove()) && Objects.equals(this.backint(), other.backint()) && Objects.equals(this.databaseArn(), other.databaseArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationSettingsRequest").add("ApplicationId", (Object)this.applicationId()).add("CredentialsToAddOrUpdate", this.hasCredentialsToAddOrUpdate() ? this.credentialsToAddOrUpdate() : null).add("CredentialsToRemove", this.hasCredentialsToRemove() ? this.credentialsToRemove() : null).add("Backint", (Object)this.backint()).add("DatabaseArn", (Object)this.databaseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CredentialsToAddOrUpdate": {
                return Optional.ofNullable(clazz.cast(this.credentialsToAddOrUpdate()));
            }
            case "CredentialsToRemove": {
                return Optional.ofNullable(clazz.cast(this.credentialsToRemove()));
            }
            case "Backint": {
                return Optional.ofNullable(clazz.cast(this.backint()));
            }
            case "DatabaseArn": {
                return Optional.ofNullable(clazz.cast(this.databaseArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("CredentialsToAddOrUpdate", CREDENTIALS_TO_ADD_OR_UPDATE_FIELD);
        map.put("CredentialsToRemove", CREDENTIALS_TO_REMOVE_FIELD);
        map.put("Backint", BACKINT_FIELD);
        map.put("DatabaseArn", DATABASE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationSettingsRequest, T> g) {
        return obj -> g.apply((UpdateApplicationSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private List<ApplicationCredential> credentialsToAddOrUpdate = DefaultSdkAutoConstructList.getInstance();
        private List<ApplicationCredential> credentialsToRemove = DefaultSdkAutoConstructList.getInstance();
        private BackintConfig backint;
        private String databaseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationSettingsRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.credentialsToAddOrUpdate(model.credentialsToAddOrUpdate);
            this.credentialsToRemove(model.credentialsToRemove);
            this.backint(model.backint);
            this.databaseArn(model.databaseArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final List<ApplicationCredential.Builder> getCredentialsToAddOrUpdate() {
            List<ApplicationCredential.Builder> result = ApplicationCredentialListCopier.copyToBuilder(this.credentialsToAddOrUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialsToAddOrUpdate(Collection<ApplicationCredential.BuilderImpl> credentialsToAddOrUpdate) {
            this.credentialsToAddOrUpdate = ApplicationCredentialListCopier.copyFromBuilder(credentialsToAddOrUpdate);
        }

        @Override
        public final Builder credentialsToAddOrUpdate(Collection<ApplicationCredential> credentialsToAddOrUpdate) {
            this.credentialsToAddOrUpdate = ApplicationCredentialListCopier.copy(credentialsToAddOrUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialsToAddOrUpdate(ApplicationCredential ... credentialsToAddOrUpdate) {
            this.credentialsToAddOrUpdate(Arrays.asList(credentialsToAddOrUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialsToAddOrUpdate(Consumer<ApplicationCredential.Builder> ... credentialsToAddOrUpdate) {
            this.credentialsToAddOrUpdate(Stream.of(credentialsToAddOrUpdate).map(c -> (ApplicationCredential)((ApplicationCredential.Builder)ApplicationCredential.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ApplicationCredential.Builder> getCredentialsToRemove() {
            List<ApplicationCredential.Builder> result = ApplicationCredentialListCopier.copyToBuilder(this.credentialsToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialsToRemove(Collection<ApplicationCredential.BuilderImpl> credentialsToRemove) {
            this.credentialsToRemove = ApplicationCredentialListCopier.copyFromBuilder(credentialsToRemove);
        }

        @Override
        public final Builder credentialsToRemove(Collection<ApplicationCredential> credentialsToRemove) {
            this.credentialsToRemove = ApplicationCredentialListCopier.copy(credentialsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialsToRemove(ApplicationCredential ... credentialsToRemove) {
            this.credentialsToRemove(Arrays.asList(credentialsToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialsToRemove(Consumer<ApplicationCredential.Builder> ... credentialsToRemove) {
            this.credentialsToRemove(Stream.of(credentialsToRemove).map(c -> (ApplicationCredential)((ApplicationCredential.Builder)ApplicationCredential.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BackintConfig.Builder getBackint() {
            return this.backint != null ? this.backint.toBuilder() : null;
        }

        public final void setBackint(BackintConfig.BuilderImpl backint) {
            this.backint = backint != null ? backint.build() : null;
        }

        @Override
        public final Builder backint(BackintConfig backint) {
            this.backint = backint;
            return this;
        }

        public final String getDatabaseArn() {
            return this.databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationSettingsRequest build() {
            return new UpdateApplicationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmSapRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
        public Builder applicationId(String var1);

        public Builder credentialsToAddOrUpdate(Collection<ApplicationCredential> var1);

        public Builder credentialsToAddOrUpdate(ApplicationCredential ... var1);

        public Builder credentialsToAddOrUpdate(Consumer<ApplicationCredential.Builder> ... var1);

        public Builder credentialsToRemove(Collection<ApplicationCredential> var1);

        public Builder credentialsToRemove(ApplicationCredential ... var1);

        public Builder credentialsToRemove(Consumer<ApplicationCredential.Builder> ... var1);

        public Builder backint(BackintConfig var1);

        default public Builder backint(Consumer<BackintConfig.Builder> backint) {
            return this.backint((BackintConfig)((BackintConfig.Builder)BackintConfig.builder().applyMutation(backint)).build());
        }

        public Builder databaseArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

