/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourcePermissionRequest extends SsmSapRequest implements
        ToCopyableBuilder<DeleteResourcePermissionRequest.Builder, DeleteResourcePermissionRequest> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(DeleteResourcePermissionRequest::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResourceArn").getter(getter(DeleteResourcePermissionRequest::sourceResourceArn))
            .setter(setter(Builder::sourceResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DeleteResourcePermissionRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            SOURCE_RESOURCE_ARN_FIELD, RESOURCE_ARN_FIELD));

    private final String actionType;

    private final String sourceResourceArn;

    private final String resourceArn;

    private DeleteResourcePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.actionType = builder.actionType;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * Delete or restore the permissions on the target database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link PermissionActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return Delete or restore the permissions on the target database.
     * @see PermissionActionType
     */
    public final PermissionActionType actionType() {
        return PermissionActionType.fromValue(actionType);
    }

    /**
     * <p>
     * Delete or restore the permissions on the target database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link PermissionActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return Delete or restore the permissions on the target database.
     * @see PermissionActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source resource.
     */
    public final String sourceResourceArn() {
        return sourceResourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourcePermissionRequest)) {
            return false;
        }
        DeleteResourcePermissionRequest other = (DeleteResourcePermissionRequest) obj;
        return Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(sourceResourceArn(), other.sourceResourceArn())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourcePermissionRequest").add("ActionType", actionTypeAsString())
                .add("SourceResourceArn", sourceResourceArn()).add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "SourceResourceArn":
            return Optional.ofNullable(clazz.cast(sourceResourceArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourcePermissionRequest, T> g) {
        return obj -> g.apply((DeleteResourcePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteResourcePermissionRequest> {
        /**
         * <p>
         * Delete or restore the permissions on the target database.
         * </p>
         * 
         * @param actionType
         *        Delete or restore the permissions on the target database.
         * @see PermissionActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * Delete or restore the permissions on the target database.
         * </p>
         * 
         * @param actionType
         *        Delete or restore the permissions on the target database.
         * @see PermissionActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionActionType
         */
        Builder actionType(PermissionActionType actionType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source resource.
         * </p>
         * 
         * @param sourceResourceArn
         *        The Amazon Resource Name (ARN) of the source resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceArn(String sourceResourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmSapRequest.BuilderImpl implements Builder {
        private String actionType;

        private String sourceResourceArn;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourcePermissionRequest model) {
            super(model);
            actionType(model.actionType);
            sourceResourceArn(model.sourceResourceArn);
            resourceArn(model.resourceArn);
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(PermissionActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getSourceResourceArn() {
            return sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourcePermissionRequest build() {
            return new DeleteResourcePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
