/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summarized description of the status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusSummary implements SdkPojo, Serializable, ToCopyableBuilder<StatusSummary.Builder, StatusSummary> {
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt")
            .getter(getter(StatusSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StatusSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StatusDetails")
            .getter(getter(StatusSummary::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(StatusSummary::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> STATUS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusType").getter(getter(StatusSummary::statusTypeAsString)).setter(setter(Builder::statusType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_UPDATED_AT_FIELD,
            STATUS_FIELD, STATUS_DETAILS_FIELD, STATUS_MESSAGE_FIELD, STATUS_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant lastUpdatedAt;

    private final String status;

    private final Map<String, String> statusDetails;

    private final String statusMessage;

    private final String statusType;

    private StatusSummary(BuilderImpl builder) {
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.statusMessage = builder.statusMessage;
        this.statusType = builder.statusType;
    }

    /**
     * <p>
     * The datetime stamp when the status was last updated.
     * </p>
     * 
     * @return The datetime stamp when the status was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusDetails() {
        return statusDetails != null && !(statusDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details about the status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusDetails} method.
     * </p>
     * 
     * @return Details about the status.
     */
    public final Map<String, String> statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * When applicable, returns an informational message relevant to the current status and status type of the status
     * summary object. We don't recommend implementing parsing logic around this value since the messages returned can
     * vary in format.
     * </p>
     * 
     * @return When applicable, returns an informational message relevant to the current status and status type of the
     *         status summary object. We don't recommend implementing parsing logic around this value since the messages
     *         returned can vary in format.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The type of a status summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusType} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusTypeAsString}.
     * </p>
     * 
     * @return The type of a status summary.
     * @see StatusType
     */
    public final StatusType statusType() {
        return StatusType.fromValue(statusType);
    }

    /**
     * <p>
     * The type of a status summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusType} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusTypeAsString}.
     * </p>
     * 
     * @return The type of a status summary.
     * @see StatusType
     */
    public final String statusTypeAsString() {
        return statusType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusDetails() ? statusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(statusTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusSummary)) {
            return false;
        }
        StatusSummary other = (StatusSummary) obj;
        return Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasStatusDetails() == other.hasStatusDetails() && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(statusTypeAsString(), other.statusTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusSummary").add("LastUpdatedAt", lastUpdatedAt()).add("Status", statusAsString())
                .add("StatusDetails", hasStatusDetails() ? statusDetails() : null).add("StatusMessage", statusMessage())
                .add("StatusType", statusTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "StatusType":
            return Optional.ofNullable(clazz.cast(statusTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusDetails", STATUS_DETAILS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("StatusType", STATUS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatusSummary, T> g) {
        return obj -> g.apply((StatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusSummary> {
        /**
         * <p>
         * The datetime stamp when the status was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The datetime stamp when the status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The current status.
         * </p>
         * 
         * @param status
         *        The current status.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The current status.
         * </p>
         * 
         * @param status
         *        The current status.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Details about the status.
         * </p>
         * 
         * @param statusDetails
         *        Details about the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(Map<String, String> statusDetails);

        /**
         * <p>
         * When applicable, returns an informational message relevant to the current status and status type of the
         * status summary object. We don't recommend implementing parsing logic around this value since the messages
         * returned can vary in format.
         * </p>
         * 
         * @param statusMessage
         *        When applicable, returns an informational message relevant to the current status and status type of
         *        the status summary object. We don't recommend implementing parsing logic around this value since the
         *        messages returned can vary in format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The type of a status summary.
         * </p>
         * 
         * @param statusType
         *        The type of a status summary.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder statusType(String statusType);

        /**
         * <p>
         * The type of a status summary.
         * </p>
         * 
         * @param statusType
         *        The type of a status summary.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder statusType(StatusType statusType);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastUpdatedAt;

        private String status;

        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();

        private String statusMessage;

        private String statusType;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusSummary model) {
            lastUpdatedAt(model.lastUpdatedAt);
            status(model.status);
            statusDetails(model.statusDetails);
            statusMessage(model.statusMessage);
            statusType(model.statusType);
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getStatusDetails() {
            if (statusDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return statusDetails;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = StatusDetailsCopier.copy(statusDetails);
        }

        @Override
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = StatusDetailsCopier.copy(statusDetails);
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStatusType() {
            return statusType;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        @Override
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        @Override
        public final Builder statusType(StatusType statusType) {
            this.statusType(statusType == null ? null : statusType.toString());
            return this;
        }

        @Override
        public StatusSummary build() {
            return new StatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
