/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmquicksetup.SsmQuickSetupClient;
import software.amazon.awssdk.services.ssmquicksetup.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationManagerSummary;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse;

public class ListConfigurationManagersIterable
implements SdkIterable<ListConfigurationManagersResponse> {
    private final SsmQuickSetupClient client;
    private final ListConfigurationManagersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationManagersIterable(SsmQuickSetupClient client, ListConfigurationManagersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationManagersResponseFetcher();
    }

    public Iterator<ListConfigurationManagersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationManagerSummary> configurationManagersList() {
        Function<ListConfigurationManagersResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationManagersList() != null) {
                return response.configurationManagersList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationManagersResponseFetcher
    implements SyncPageFetcher<ListConfigurationManagersResponse> {
        private ListConfigurationManagersResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationManagersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationManagersResponse nextPage(ListConfigurationManagersResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationManagersIterable.this.client.listConfigurationManagers(ListConfigurationManagersIterable.this.firstRequest);
            }
            return ListConfigurationManagersIterable.this.client.listConfigurationManagers((ListConfigurationManagersRequest)((Object)ListConfigurationManagersIterable.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

