/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationDefinitionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationDefinitionInput> {
    private static final SdkField<String> LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalDeploymentAdministrationRoleArn").getter(ConfigurationDefinitionInput.getter(ConfigurationDefinitionInput::localDeploymentAdministrationRoleArn)).setter(ConfigurationDefinitionInput.setter(Builder::localDeploymentAdministrationRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeploymentAdministrationRoleArn").build()}).build();
    private static final SdkField<String> LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalDeploymentExecutionRoleName").getter(ConfigurationDefinitionInput.getter(ConfigurationDefinitionInput::localDeploymentExecutionRoleName)).setter(ConfigurationDefinitionInput.setter(Builder::localDeploymentExecutionRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeploymentExecutionRoleName").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(ConfigurationDefinitionInput.getter(ConfigurationDefinitionInput::parameters)).setter(ConfigurationDefinitionInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ConfigurationDefinitionInput.getter(ConfigurationDefinitionInput::type)).setter(ConfigurationDefinitionInput.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersion").getter(ConfigurationDefinitionInput.getter(ConfigurationDefinitionInput::typeVersion)).setter(ConfigurationDefinitionInput.setter(Builder::typeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD, LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD, PARAMETERS_FIELD, TYPE_FIELD, TYPE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationDefinitionInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String localDeploymentAdministrationRoleArn;
    private final String localDeploymentExecutionRoleName;
    private final Map<String, String> parameters;
    private final String type;
    private final String typeVersion;

    private ConfigurationDefinitionInput(BuilderImpl builder) {
        this.localDeploymentAdministrationRoleArn = builder.localDeploymentAdministrationRoleArn;
        this.localDeploymentExecutionRoleName = builder.localDeploymentExecutionRoleName;
        this.parameters = builder.parameters;
        this.type = builder.type;
        this.typeVersion = builder.typeVersion;
    }

    public final String localDeploymentAdministrationRoleArn() {
        return this.localDeploymentAdministrationRoleArn;
    }

    public final String localDeploymentExecutionRoleName() {
        return this.localDeploymentExecutionRoleName;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final String type() {
        return this.type;
    }

    public final String typeVersion() {
        return this.typeVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localDeploymentAdministrationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.localDeploymentExecutionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationDefinitionInput)) {
            return false;
        }
        ConfigurationDefinitionInput other = (ConfigurationDefinitionInput)obj;
        return Objects.equals(this.localDeploymentAdministrationRoleArn(), other.localDeploymentAdministrationRoleArn()) && Objects.equals(this.localDeploymentExecutionRoleName(), other.localDeploymentExecutionRoleName()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.typeVersion(), other.typeVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationDefinitionInput").add("LocalDeploymentAdministrationRoleArn", (Object)this.localDeploymentAdministrationRoleArn()).add("LocalDeploymentExecutionRoleName", (Object)this.localDeploymentExecutionRoleName()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Type", (Object)this.type()).add("TypeVersion", (Object)this.typeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalDeploymentAdministrationRoleArn": {
                return Optional.ofNullable(clazz.cast(this.localDeploymentAdministrationRoleArn()));
            }
            case "LocalDeploymentExecutionRoleName": {
                return Optional.ofNullable(clazz.cast(this.localDeploymentExecutionRoleName()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "TypeVersion": {
                return Optional.ofNullable(clazz.cast(this.typeVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocalDeploymentAdministrationRoleArn", LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD);
        map.put("LocalDeploymentExecutionRoleName", LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("TypeVersion", TYPE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationDefinitionInput, T> g) {
        return obj -> g.apply((ConfigurationDefinitionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localDeploymentAdministrationRoleArn;
        private String localDeploymentExecutionRoleName;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String type;
        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationDefinitionInput model) {
            this.localDeploymentAdministrationRoleArn(model.localDeploymentAdministrationRoleArn);
            this.localDeploymentExecutionRoleName(model.localDeploymentExecutionRoleName);
            this.parameters(model.parameters);
            this.type(model.type);
            this.typeVersion(model.typeVersion);
        }

        public final String getLocalDeploymentAdministrationRoleArn() {
            return this.localDeploymentAdministrationRoleArn;
        }

        public final void setLocalDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
        }

        @Override
        public final Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
            return this;
        }

        public final String getLocalDeploymentExecutionRoleName() {
            return this.localDeploymentExecutionRoleName;
        }

        public final void setLocalDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
        }

        @Override
        public final Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypeVersion() {
            return this.typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        public ConfigurationDefinitionInput build() {
            return new ConfigurationDefinitionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationDefinitionInput> {
        public Builder localDeploymentAdministrationRoleArn(String var1);

        public Builder localDeploymentExecutionRoleName(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder type(String var1);

        public Builder typeVersion(String var1);
    }
}

