/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmquicksetup.model.Filter;
import software.amazon.awssdk.services.ssmquicksetup.model.FiltersListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationManagersRequest
extends SsmQuickSetupRequest
implements ToCopyableBuilder<Builder, ListConfigurationManagersRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(ListConfigurationManagersRequest.getter(ListConfigurationManagersRequest::filters)).setter(ListConfigurationManagersRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListConfigurationManagersRequest.getter(ListConfigurationManagersRequest::maxItems)).setter(ListConfigurationManagersRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<String> STARTING_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingToken").getter(ListConfigurationManagersRequest.getter(ListConfigurationManagersRequest::startingToken)).setter(ListConfigurationManagersRequest.setter(Builder::startingToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, MAX_ITEMS_FIELD, STARTING_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConfigurationManagersRequest.memberNameToFieldInitializer();
    private final List<Filter> filters;
    private final Integer maxItems;
    private final String startingToken;

    private ListConfigurationManagersRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxItems = builder.maxItems;
        this.startingToken = builder.startingToken;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String startingToken() {
        return this.startingToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationManagersRequest)) {
            return false;
        }
        ListConfigurationManagersRequest other = (ListConfigurationManagersRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.startingToken(), other.startingToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationManagersRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("MaxItems", (Object)this.maxItems()).add("StartingToken", (Object)this.startingToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "StartingToken": {
                return Optional.ofNullable(clazz.cast(this.startingToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("StartingToken", STARTING_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationManagersRequest, T> g) {
        return obj -> g.apply((ListConfigurationManagersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupRequest.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxItems;
        private String startingToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationManagersRequest model) {
            super(model);
            this.filters(model.filters);
            this.maxItems(model.maxItems);
            this.startingToken(model.startingToken);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getStartingToken() {
            return this.startingToken;
        }

        public final void setStartingToken(String startingToken) {
            this.startingToken = startingToken;
        }

        @Override
        public final Builder startingToken(String startingToken) {
            this.startingToken = startingToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConfigurationManagersRequest build() {
            return new ListConfigurationManagersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmQuickSetupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationManagersRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxItems(Integer var1);

        public Builder startingToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

