/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationParametersMapCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfigurationDefinitionRequest
extends SsmQuickSetupRequest
implements ToCopyableBuilder<Builder, UpdateConfigurationDefinitionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateConfigurationDefinitionRequest.getter(UpdateConfigurationDefinitionRequest::id)).setter(UpdateConfigurationDefinitionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<String> LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalDeploymentAdministrationRoleArn").getter(UpdateConfigurationDefinitionRequest.getter(UpdateConfigurationDefinitionRequest::localDeploymentAdministrationRoleArn)).setter(UpdateConfigurationDefinitionRequest.setter(Builder::localDeploymentAdministrationRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeploymentAdministrationRoleArn").build()}).build();
    private static final SdkField<String> LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalDeploymentExecutionRoleName").getter(UpdateConfigurationDefinitionRequest.getter(UpdateConfigurationDefinitionRequest::localDeploymentExecutionRoleName)).setter(UpdateConfigurationDefinitionRequest.setter(Builder::localDeploymentExecutionRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeploymentExecutionRoleName").build()}).build();
    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagerArn").getter(UpdateConfigurationDefinitionRequest.getter(UpdateConfigurationDefinitionRequest::managerArn)).setter(UpdateConfigurationDefinitionRequest.setter(Builder::managerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ManagerArn").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(UpdateConfigurationDefinitionRequest.getter(UpdateConfigurationDefinitionRequest::parameters)).setter(UpdateConfigurationDefinitionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersion").getter(UpdateConfigurationDefinitionRequest.getter(UpdateConfigurationDefinitionRequest::typeVersion)).setter(UpdateConfigurationDefinitionRequest.setter(Builder::typeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD, LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD, MANAGER_ARN_FIELD, PARAMETERS_FIELD, TYPE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConfigurationDefinitionRequest.memberNameToFieldInitializer();
    private final String id;
    private final String localDeploymentAdministrationRoleArn;
    private final String localDeploymentExecutionRoleName;
    private final String managerArn;
    private final Map<String, String> parameters;
    private final String typeVersion;

    private UpdateConfigurationDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.localDeploymentAdministrationRoleArn = builder.localDeploymentAdministrationRoleArn;
        this.localDeploymentExecutionRoleName = builder.localDeploymentExecutionRoleName;
        this.managerArn = builder.managerArn;
        this.parameters = builder.parameters;
        this.typeVersion = builder.typeVersion;
    }

    public final String id() {
        return this.id;
    }

    public final String localDeploymentAdministrationRoleArn() {
        return this.localDeploymentAdministrationRoleArn;
    }

    public final String localDeploymentExecutionRoleName() {
        return this.localDeploymentExecutionRoleName;
    }

    public final String managerArn() {
        return this.managerArn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final String typeVersion() {
        return this.typeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.localDeploymentAdministrationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.localDeploymentExecutionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationDefinitionRequest)) {
            return false;
        }
        UpdateConfigurationDefinitionRequest other = (UpdateConfigurationDefinitionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.localDeploymentAdministrationRoleArn(), other.localDeploymentAdministrationRoleArn()) && Objects.equals(this.localDeploymentExecutionRoleName(), other.localDeploymentExecutionRoleName()) && Objects.equals(this.managerArn(), other.managerArn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.typeVersion(), other.typeVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConfigurationDefinitionRequest").add("Id", (Object)this.id()).add("LocalDeploymentAdministrationRoleArn", (Object)this.localDeploymentAdministrationRoleArn()).add("LocalDeploymentExecutionRoleName", (Object)this.localDeploymentExecutionRoleName()).add("ManagerArn", (Object)this.managerArn()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("TypeVersion", (Object)this.typeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LocalDeploymentAdministrationRoleArn": {
                return Optional.ofNullable(clazz.cast(this.localDeploymentAdministrationRoleArn()));
            }
            case "LocalDeploymentExecutionRoleName": {
                return Optional.ofNullable(clazz.cast(this.localDeploymentExecutionRoleName()));
            }
            case "ManagerArn": {
                return Optional.ofNullable(clazz.cast(this.managerArn()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "TypeVersion": {
                return Optional.ofNullable(clazz.cast(this.typeVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("LocalDeploymentAdministrationRoleArn", LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD);
        map.put("LocalDeploymentExecutionRoleName", LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD);
        map.put("ManagerArn", MANAGER_ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("TypeVersion", TYPE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupRequest.BuilderImpl
    implements Builder {
        private String id;
        private String localDeploymentAdministrationRoleArn;
        private String localDeploymentExecutionRoleName;
        private String managerArn;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationDefinitionRequest model) {
            super(model);
            this.id(model.id);
            this.localDeploymentAdministrationRoleArn(model.localDeploymentAdministrationRoleArn);
            this.localDeploymentExecutionRoleName(model.localDeploymentExecutionRoleName);
            this.managerArn(model.managerArn);
            this.parameters(model.parameters);
            this.typeVersion(model.typeVersion);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLocalDeploymentAdministrationRoleArn() {
            return this.localDeploymentAdministrationRoleArn;
        }

        public final void setLocalDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
        }

        @Override
        public final Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
            return this;
        }

        public final String getLocalDeploymentExecutionRoleName() {
            return this.localDeploymentExecutionRoleName;
        }

        public final void setLocalDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
        }

        @Override
        public final Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
            return this;
        }

        public final String getManagerArn() {
            return this.managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
            return this;
        }

        public final String getTypeVersion() {
            return this.typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationDefinitionRequest build() {
            return new UpdateConfigurationDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmQuickSetupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfigurationDefinitionRequest> {
        public Builder id(String var1);

        public Builder localDeploymentAdministrationRoleArn(String var1);

        public Builder localDeploymentExecutionRoleName(String var1);

        public Builder managerArn(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder typeVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

