/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmquicksetup.SsmQuickSetupClient;
import software.amazon.awssdk.services.ssmquicksetup.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationSummary;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsResponse;

public class ListConfigurationsIterable
implements SdkIterable<ListConfigurationsResponse> {
    private final SsmQuickSetupClient client;
    private final ListConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationsIterable(SsmQuickSetupClient client, ListConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationsResponseFetcher();
    }

    public Iterator<ListConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationSummary> configurationsList() {
        Function<ListConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationsList() != null) {
                return response.configurationsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationsResponseFetcher
    implements SyncPageFetcher<ListConfigurationsResponse> {
        private ListConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationsResponse nextPage(ListConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationsIterable.this.client.listConfigurations(ListConfigurationsIterable.this.firstRequest);
            }
            return ListConfigurationsIterable.this.client.listConfigurations((ListConfigurationsRequest)((Object)ListConfigurationsIterable.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

