/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationDefinitionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationDefinitionSummary> {
    private static final SdkField<Map<String, String>> FIRST_CLASS_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FirstClassParameters").getter(ConfigurationDefinitionSummary.getter(ConfigurationDefinitionSummary::firstClassParameters)).setter(ConfigurationDefinitionSummary.setter(Builder::firstClassParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstClassParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConfigurationDefinitionSummary.getter(ConfigurationDefinitionSummary::id)).setter(ConfigurationDefinitionSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ConfigurationDefinitionSummary.getter(ConfigurationDefinitionSummary::type)).setter(ConfigurationDefinitionSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersion").getter(ConfigurationDefinitionSummary.getter(ConfigurationDefinitionSummary::typeVersion)).setter(ConfigurationDefinitionSummary.setter(Builder::typeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_CLASS_PARAMETERS_FIELD, ID_FIELD, TYPE_FIELD, TYPE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FirstClassParameters", FIRST_CLASS_PARAMETERS_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("TypeVersion", TYPE_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, String> firstClassParameters;
    private final String id;
    private final String type;
    private final String typeVersion;

    private ConfigurationDefinitionSummary(BuilderImpl builder) {
        this.firstClassParameters = builder.firstClassParameters;
        this.id = builder.id;
        this.type = builder.type;
        this.typeVersion = builder.typeVersion;
    }

    public final boolean hasFirstClassParameters() {
        return this.firstClassParameters != null && !(this.firstClassParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> firstClassParameters() {
        return this.firstClassParameters;
    }

    public final String id() {
        return this.id;
    }

    public final String type() {
        return this.type;
    }

    public final String typeVersion() {
        return this.typeVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirstClassParameters() ? this.firstClassParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationDefinitionSummary)) {
            return false;
        }
        ConfigurationDefinitionSummary other = (ConfigurationDefinitionSummary)obj;
        return this.hasFirstClassParameters() == other.hasFirstClassParameters() && Objects.equals(this.firstClassParameters(), other.firstClassParameters()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.typeVersion(), other.typeVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationDefinitionSummary").add("FirstClassParameters", this.hasFirstClassParameters() ? this.firstClassParameters() : null).add("Id", (Object)this.id()).add("Type", (Object)this.type()).add("TypeVersion", (Object)this.typeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirstClassParameters": {
                return Optional.ofNullable(clazz.cast(this.firstClassParameters()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "TypeVersion": {
                return Optional.ofNullable(clazz.cast(this.typeVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationDefinitionSummary, T> g) {
        return obj -> g.apply((ConfigurationDefinitionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> firstClassParameters = DefaultSdkAutoConstructMap.getInstance();
        private String id;
        private String type;
        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationDefinitionSummary model) {
            this.firstClassParameters(model.firstClassParameters);
            this.id(model.id);
            this.type(model.type);
            this.typeVersion(model.typeVersion);
        }

        public final Map<String, String> getFirstClassParameters() {
            if (this.firstClassParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.firstClassParameters;
        }

        public final void setFirstClassParameters(Map<String, String> firstClassParameters) {
            this.firstClassParameters = ConfigurationParametersMapCopier.copy(firstClassParameters);
        }

        @Override
        public final Builder firstClassParameters(Map<String, String> firstClassParameters) {
            this.firstClassParameters = ConfigurationParametersMapCopier.copy(firstClassParameters);
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypeVersion() {
            return this.typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        public ConfigurationDefinitionSummary build() {
            return new ConfigurationDefinitionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationDefinitionSummary> {
        public Builder firstClassParameters(Map<String, String> var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder typeVersion(String var1);
    }
}

