/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionInput;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionsInputListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationManagerRequest
extends SsmQuickSetupRequest
implements ToCopyableBuilder<Builder, CreateConfigurationManagerRequest> {
    private static final SdkField<List<ConfigurationDefinitionInput>> CONFIGURATION_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationDefinitions").getter(CreateConfigurationManagerRequest.getter(CreateConfigurationManagerRequest::configurationDefinitions)).setter(CreateConfigurationManagerRequest.setter(Builder::configurationDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationDefinitionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateConfigurationManagerRequest.getter(CreateConfigurationManagerRequest::description)).setter(CreateConfigurationManagerRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConfigurationManagerRequest.getter(CreateConfigurationManagerRequest::name)).setter(CreateConfigurationManagerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateConfigurationManagerRequest.getter(CreateConfigurationManagerRequest::tags)).setter(CreateConfigurationManagerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_DEFINITIONS_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationDefinitions", CONFIGURATION_DEFINITIONS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final List<ConfigurationDefinitionInput> configurationDefinitions;
    private final String description;
    private final String name;
    private final Map<String, String> tags;

    private CreateConfigurationManagerRequest(BuilderImpl builder) {
        super(builder);
        this.configurationDefinitions = builder.configurationDefinitions;
        this.description = builder.description;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final boolean hasConfigurationDefinitions() {
        return this.configurationDefinitions != null && !(this.configurationDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationDefinitionInput> configurationDefinitions() {
        return this.configurationDefinitions;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationDefinitions() ? this.configurationDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationManagerRequest)) {
            return false;
        }
        CreateConfigurationManagerRequest other = (CreateConfigurationManagerRequest)((Object)obj);
        return this.hasConfigurationDefinitions() == other.hasConfigurationDefinitions() && Objects.equals(this.configurationDefinitions(), other.configurationDefinitions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfigurationManagerRequest").add("ConfigurationDefinitions", this.hasConfigurationDefinitions() ? this.configurationDefinitions() : null).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationDefinitions": {
                return Optional.ofNullable(clazz.cast(this.configurationDefinitions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationManagerRequest, T> g) {
        return obj -> g.apply((CreateConfigurationManagerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupRequest.BuilderImpl
    implements Builder {
        private List<ConfigurationDefinitionInput> configurationDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationManagerRequest model) {
            super(model);
            this.configurationDefinitions(model.configurationDefinitions);
            this.description(model.description);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final List<ConfigurationDefinitionInput.Builder> getConfigurationDefinitions() {
            List<ConfigurationDefinitionInput.Builder> result = ConfigurationDefinitionsInputListCopier.copyToBuilder(this.configurationDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationDefinitions(Collection<ConfigurationDefinitionInput.BuilderImpl> configurationDefinitions) {
            this.configurationDefinitions = ConfigurationDefinitionsInputListCopier.copyFromBuilder(configurationDefinitions);
        }

        @Override
        public final Builder configurationDefinitions(Collection<ConfigurationDefinitionInput> configurationDefinitions) {
            this.configurationDefinitions = ConfigurationDefinitionsInputListCopier.copy(configurationDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitions(ConfigurationDefinitionInput ... configurationDefinitions) {
            this.configurationDefinitions(Arrays.asList(configurationDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitions(Consumer<ConfigurationDefinitionInput.Builder> ... configurationDefinitions) {
            this.configurationDefinitions(Stream.of(configurationDefinitions).map(c -> (ConfigurationDefinitionInput)((ConfigurationDefinitionInput.Builder)ConfigurationDefinitionInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationManagerRequest build() {
            return new CreateConfigurationManagerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmQuickSetupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigurationManagerRequest> {
        public Builder configurationDefinitions(Collection<ConfigurationDefinitionInput> var1);

        public Builder configurationDefinitions(ConfigurationDefinitionInput ... var1);

        public Builder configurationDefinitions(Consumer<ConfigurationDefinitionInput.Builder> ... var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

