/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinition;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionsListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.StatusSummariesListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary;
import software.amazon.awssdk.services.ssmquicksetup.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigurationManagerResponse
extends SsmQuickSetupResponse
implements ToCopyableBuilder<Builder, GetConfigurationManagerResponse> {
    private static final SdkField<List<ConfigurationDefinition>> CONFIGURATION_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationDefinitions").getter(GetConfigurationManagerResponse.getter(GetConfigurationManagerResponse::configurationDefinitions)).setter(GetConfigurationManagerResponse.setter(Builder::configurationDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetConfigurationManagerResponse.getter(GetConfigurationManagerResponse::createdAt)).setter(GetConfigurationManagerResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetConfigurationManagerResponse.getter(GetConfigurationManagerResponse::description)).setter(GetConfigurationManagerResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedAt").getter(GetConfigurationManagerResponse.getter(GetConfigurationManagerResponse::lastModifiedAt)).setter(GetConfigurationManagerResponse.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagerArn").getter(GetConfigurationManagerResponse.getter(GetConfigurationManagerResponse::managerArn)).setter(GetConfigurationManagerResponse.setter(Builder::managerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagerArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetConfigurationManagerResponse.getter(GetConfigurationManagerResponse::name)).setter(GetConfigurationManagerResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<StatusSummary>> STATUS_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusSummaries").getter(GetConfigurationManagerResponse.getter(GetConfigurationManagerResponse::statusSummaries)).setter(GetConfigurationManagerResponse.setter(Builder::statusSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetConfigurationManagerResponse.getter(GetConfigurationManagerResponse::tags)).setter(GetConfigurationManagerResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_DEFINITIONS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_AT_FIELD, MANAGER_ARN_FIELD, NAME_FIELD, STATUS_SUMMARIES_FIELD, TAGS_FIELD));
    private final List<ConfigurationDefinition> configurationDefinitions;
    private final Instant createdAt;
    private final String description;
    private final Instant lastModifiedAt;
    private final String managerArn;
    private final String name;
    private final List<StatusSummary> statusSummaries;
    private final Map<String, String> tags;

    private GetConfigurationManagerResponse(BuilderImpl builder) {
        super(builder);
        this.configurationDefinitions = builder.configurationDefinitions;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.managerArn = builder.managerArn;
        this.name = builder.name;
        this.statusSummaries = builder.statusSummaries;
        this.tags = builder.tags;
    }

    public final boolean hasConfigurationDefinitions() {
        return this.configurationDefinitions != null && !(this.configurationDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationDefinition> configurationDefinitions() {
        return this.configurationDefinitions;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String managerArn() {
        return this.managerArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasStatusSummaries() {
        return this.statusSummaries != null && !(this.statusSummaries instanceof SdkAutoConstructList);
    }

    public final List<StatusSummary> statusSummaries() {
        return this.statusSummaries;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationDefinitions() ? this.configurationDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusSummaries() ? this.statusSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationManagerResponse)) {
            return false;
        }
        GetConfigurationManagerResponse other = (GetConfigurationManagerResponse)((Object)obj);
        return this.hasConfigurationDefinitions() == other.hasConfigurationDefinitions() && Objects.equals(this.configurationDefinitions(), other.configurationDefinitions()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.managerArn(), other.managerArn()) && Objects.equals(this.name(), other.name()) && this.hasStatusSummaries() == other.hasStatusSummaries() && Objects.equals(this.statusSummaries(), other.statusSummaries()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfigurationManagerResponse").add("ConfigurationDefinitions", this.hasConfigurationDefinitions() ? this.configurationDefinitions() : null).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("ManagerArn", (Object)this.managerArn()).add("Name", (Object)this.name()).add("StatusSummaries", this.hasStatusSummaries() ? this.statusSummaries() : null).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationDefinitions": {
                return Optional.ofNullable(clazz.cast(this.configurationDefinitions()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "ManagerArn": {
                return Optional.ofNullable(clazz.cast(this.managerArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StatusSummaries": {
                return Optional.ofNullable(clazz.cast(this.statusSummaries()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationManagerResponse, T> g) {
        return obj -> g.apply((GetConfigurationManagerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationDefinition> configurationDefinitions = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String description;
        private Instant lastModifiedAt;
        private String managerArn;
        private String name;
        private List<StatusSummary> statusSummaries = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationManagerResponse model) {
            super(model);
            this.configurationDefinitions(model.configurationDefinitions);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastModifiedAt(model.lastModifiedAt);
            this.managerArn(model.managerArn);
            this.name(model.name);
            this.statusSummaries(model.statusSummaries);
            this.tags(model.tags);
        }

        public final List<ConfigurationDefinition.Builder> getConfigurationDefinitions() {
            List<ConfigurationDefinition.Builder> result = ConfigurationDefinitionsListCopier.copyToBuilder(this.configurationDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationDefinitions(Collection<ConfigurationDefinition.BuilderImpl> configurationDefinitions) {
            this.configurationDefinitions = ConfigurationDefinitionsListCopier.copyFromBuilder(configurationDefinitions);
        }

        @Override
        public final Builder configurationDefinitions(Collection<ConfigurationDefinition> configurationDefinitions) {
            this.configurationDefinitions = ConfigurationDefinitionsListCopier.copy(configurationDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitions(ConfigurationDefinition ... configurationDefinitions) {
            this.configurationDefinitions(Arrays.asList(configurationDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitions(Consumer<ConfigurationDefinition.Builder> ... configurationDefinitions) {
            this.configurationDefinitions(Stream.of(configurationDefinitions).map(c -> (ConfigurationDefinition)((ConfigurationDefinition.Builder)ConfigurationDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getManagerArn() {
            return this.managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<StatusSummary.Builder> getStatusSummaries() {
            List<StatusSummary.Builder> result = StatusSummariesListCopier.copyToBuilder(this.statusSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaries(Collection<StatusSummary.BuilderImpl> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copyFromBuilder(statusSummaries);
        }

        @Override
        public final Builder statusSummaries(Collection<StatusSummary> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copy(statusSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(StatusSummary ... statusSummaries) {
            this.statusSummaries(Arrays.asList(statusSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(Consumer<StatusSummary.Builder> ... statusSummaries) {
            this.statusSummaries(Stream.of(statusSummaries).map(c -> (StatusSummary)((StatusSummary.Builder)StatusSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetConfigurationManagerResponse build() {
            return new GetConfigurationManagerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmQuickSetupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigurationManagerResponse> {
        public Builder configurationDefinitions(Collection<ConfigurationDefinition> var1);

        public Builder configurationDefinitions(ConfigurationDefinition ... var1);

        public Builder configurationDefinitions(Consumer<ConfigurationDefinition.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder managerArn(String var1);

        public Builder name(String var1);

        public Builder statusSummaries(Collection<StatusSummary> var1);

        public Builder statusSummaries(StatusSummary ... var1);

        public Builder statusSummaries(Consumer<StatusSummary.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

