/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceCode {
    SSM_INCIDENTS("ssm-incidents"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceCode> VALUE_MAP;
    private final String value;

    private ServiceCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceCode> knownValues() {
        EnumSet<ServiceCode> knownValues = EnumSet.allOf(ServiceCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceCode.class, ServiceCode::toString);
    }
}

