/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem;
import software.amazon.awssdk.services.ssmincidents.model.NotificationTargetSetCopier;
import software.amazon.awssdk.services.ssmincidents.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncidentTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IncidentTemplate> {
    private static final SdkField<String> DEDUPE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dedupeString").getter(IncidentTemplate.getter(IncidentTemplate::dedupeString)).setter(IncidentTemplate.setter(Builder::dedupeString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedupeString").build()}).build();
    private static final SdkField<Integer> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("impact").getter(IncidentTemplate.getter(IncidentTemplate::impact)).setter(IncidentTemplate.setter(Builder::impact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impact").build()}).build();
    private static final SdkField<Map<String, String>> INCIDENT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("incidentTags").getter(IncidentTemplate.getter(IncidentTemplate::incidentTags)).setter(IncidentTemplate.setter(Builder::incidentTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<NotificationTargetItem>> NOTIFICATION_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationTargets").getter(IncidentTemplate.getter(IncidentTemplate::notificationTargets)).setter(IncidentTemplate.setter(Builder::notificationTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationTargetItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summary").getter(IncidentTemplate.getter(IncidentTemplate::summary)).setter(IncidentTemplate.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(IncidentTemplate.getter(IncidentTemplate::title)).setter(IncidentTemplate.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEDUPE_STRING_FIELD, IMPACT_FIELD, INCIDENT_TAGS_FIELD, NOTIFICATION_TARGETS_FIELD, SUMMARY_FIELD, TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IncidentTemplate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dedupeString;
    private final Integer impact;
    private final Map<String, String> incidentTags;
    private final List<NotificationTargetItem> notificationTargets;
    private final String summary;
    private final String title;

    private IncidentTemplate(BuilderImpl builder) {
        this.dedupeString = builder.dedupeString;
        this.impact = builder.impact;
        this.incidentTags = builder.incidentTags;
        this.notificationTargets = builder.notificationTargets;
        this.summary = builder.summary;
        this.title = builder.title;
    }

    public final String dedupeString() {
        return this.dedupeString;
    }

    public final Integer impact() {
        return this.impact;
    }

    public final boolean hasIncidentTags() {
        return this.incidentTags != null && !(this.incidentTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> incidentTags() {
        return this.incidentTags;
    }

    public final boolean hasNotificationTargets() {
        return this.notificationTargets != null && !(this.notificationTargets instanceof SdkAutoConstructList);
    }

    public final List<NotificationTargetItem> notificationTargets() {
        return this.notificationTargets;
    }

    public final String summary() {
        return this.summary;
    }

    public final String title() {
        return this.title;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dedupeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.impact());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidentTags() ? this.incidentTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationTargets() ? this.notificationTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentTemplate)) {
            return false;
        }
        IncidentTemplate other = (IncidentTemplate)obj;
        return Objects.equals(this.dedupeString(), other.dedupeString()) && Objects.equals(this.impact(), other.impact()) && this.hasIncidentTags() == other.hasIncidentTags() && Objects.equals(this.incidentTags(), other.incidentTags()) && this.hasNotificationTargets() == other.hasNotificationTargets() && Objects.equals(this.notificationTargets(), other.notificationTargets()) && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"IncidentTemplate").add("DedupeString", (Object)this.dedupeString()).add("Impact", (Object)this.impact()).add("IncidentTags", this.hasIncidentTags() ? this.incidentTags() : null).add("NotificationTargets", this.hasNotificationTargets() ? this.notificationTargets() : null).add("Summary", (Object)this.summary()).add("Title", (Object)this.title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dedupeString": {
                return Optional.ofNullable(clazz.cast(this.dedupeString()));
            }
            case "impact": {
                return Optional.ofNullable(clazz.cast(this.impact()));
            }
            case "incidentTags": {
                return Optional.ofNullable(clazz.cast(this.incidentTags()));
            }
            case "notificationTargets": {
                return Optional.ofNullable(clazz.cast(this.notificationTargets()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dedupeString", DEDUPE_STRING_FIELD);
        map.put("impact", IMPACT_FIELD);
        map.put("incidentTags", INCIDENT_TAGS_FIELD);
        map.put("notificationTargets", NOTIFICATION_TARGETS_FIELD);
        map.put("summary", SUMMARY_FIELD);
        map.put("title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncidentTemplate, T> g) {
        return obj -> g.apply((IncidentTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dedupeString;
        private Integer impact;
        private Map<String, String> incidentTags = DefaultSdkAutoConstructMap.getInstance();
        private List<NotificationTargetItem> notificationTargets = DefaultSdkAutoConstructList.getInstance();
        private String summary;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(IncidentTemplate model) {
            this.dedupeString(model.dedupeString);
            this.impact(model.impact);
            this.incidentTags(model.incidentTags);
            this.notificationTargets(model.notificationTargets);
            this.summary(model.summary);
            this.title(model.title);
        }

        public final String getDedupeString() {
            return this.dedupeString;
        }

        public final void setDedupeString(String dedupeString) {
            this.dedupeString = dedupeString;
        }

        @Override
        public final Builder dedupeString(String dedupeString) {
            this.dedupeString = dedupeString;
            return this;
        }

        public final Integer getImpact() {
            return this.impact;
        }

        public final void setImpact(Integer impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(Integer impact) {
            this.impact = impact;
            return this;
        }

        public final Map<String, String> getIncidentTags() {
            if (this.incidentTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.incidentTags;
        }

        public final void setIncidentTags(Map<String, String> incidentTags) {
            this.incidentTags = TagMapCopier.copy(incidentTags);
        }

        @Override
        public final Builder incidentTags(Map<String, String> incidentTags) {
            this.incidentTags = TagMapCopier.copy(incidentTags);
            return this;
        }

        public final List<NotificationTargetItem.Builder> getNotificationTargets() {
            List<NotificationTargetItem.Builder> result = NotificationTargetSetCopier.copyToBuilder(this.notificationTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationTargets(Collection<NotificationTargetItem.BuilderImpl> notificationTargets) {
            this.notificationTargets = NotificationTargetSetCopier.copyFromBuilder(notificationTargets);
        }

        @Override
        public final Builder notificationTargets(Collection<NotificationTargetItem> notificationTargets) {
            this.notificationTargets = NotificationTargetSetCopier.copy(notificationTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTargets(NotificationTargetItem ... notificationTargets) {
            this.notificationTargets(Arrays.asList(notificationTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTargets(Consumer<NotificationTargetItem.Builder> ... notificationTargets) {
            this.notificationTargets(Stream.of(notificationTargets).map(c -> (NotificationTargetItem)((NotificationTargetItem.Builder)NotificationTargetItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public IncidentTemplate build() {
            return new IncidentTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IncidentTemplate> {
        public Builder dedupeString(String var1);

        public Builder impact(Integer var1);

        public Builder incidentTags(Map<String, String> var1);

        public Builder notificationTargets(Collection<NotificationTargetItem> var1);

        public Builder notificationTargets(NotificationTargetItem ... var1);

        public Builder notificationTargets(Consumer<NotificationTargetItem.Builder> ... var1);

        public Builder summary(String var1);

        public Builder title(String var1);
    }
}

