/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansResponse;
import software.amazon.awssdk.services.ssmincidents.model.ResponsePlanSummary;

public class ListResponsePlansPublisher
implements SdkPublisher<ListResponsePlansResponse> {
    private final SsmIncidentsAsyncClient client;
    private final ListResponsePlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResponsePlansPublisher(SsmIncidentsAsyncClient client, ListResponsePlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResponsePlansPublisher(SsmIncidentsAsyncClient client, ListResponsePlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResponsePlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResponsePlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResponsePlanSummary> responsePlanSummaries() {
        Function<ListResponsePlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.responsePlanSummaries() != null) {
                return response.responsePlanSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResponsePlansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResponsePlansResponseFetcher
    implements AsyncPageFetcher<ListResponsePlansResponse> {
        private ListResponsePlansResponseFetcher() {
        }

        public boolean hasNextPage(ListResponsePlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResponsePlansResponse> nextPage(ListResponsePlansResponse previousPage) {
            if (previousPage == null) {
                return ListResponsePlansPublisher.this.client.listResponsePlans(ListResponsePlansPublisher.this.firstRequest);
            }
            return ListResponsePlansPublisher.this.client.listResponsePlans((ListResponsePlansRequest)((Object)ListResponsePlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

