/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.RelatedItem;
import software.amazon.awssdk.services.ssmincidents.model.RelatedItemListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRelatedItemsResponse
extends SsmIncidentsResponse
implements ToCopyableBuilder<Builder, ListRelatedItemsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRelatedItemsResponse.getter(ListRelatedItemsResponse::nextToken)).setter(ListRelatedItemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RelatedItem>> RELATED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedItems").getter(ListRelatedItemsResponse.getter(ListRelatedItemsResponse::relatedItems)).setter(ListRelatedItemsResponse.setter(Builder::relatedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RELATED_ITEMS_FIELD));
    private final String nextToken;
    private final List<RelatedItem> relatedItems;

    private ListRelatedItemsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.relatedItems = builder.relatedItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRelatedItems() {
        return this.relatedItems != null && !(this.relatedItems instanceof SdkAutoConstructList);
    }

    public final List<RelatedItem> relatedItems() {
        return this.relatedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedItems() ? this.relatedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRelatedItemsResponse)) {
            return false;
        }
        ListRelatedItemsResponse other = (ListRelatedItemsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRelatedItems() == other.hasRelatedItems() && Objects.equals(this.relatedItems(), other.relatedItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListRelatedItemsResponse").add("NextToken", (Object)this.nextToken()).add("RelatedItems", this.hasRelatedItems() ? this.relatedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "relatedItems": {
                return Optional.ofNullable(clazz.cast(this.relatedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRelatedItemsResponse, T> g) {
        return obj -> g.apply((ListRelatedItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RelatedItem> relatedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRelatedItemsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.relatedItems(model.relatedItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RelatedItem.Builder> getRelatedItems() {
            List<RelatedItem.Builder> result = RelatedItemListCopier.copyToBuilder(this.relatedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedItems(Collection<RelatedItem.BuilderImpl> relatedItems) {
            this.relatedItems = RelatedItemListCopier.copyFromBuilder(relatedItems);
        }

        @Override
        public final Builder relatedItems(Collection<RelatedItem> relatedItems) {
            this.relatedItems = RelatedItemListCopier.copy(relatedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedItems(RelatedItem ... relatedItems) {
            this.relatedItems(Arrays.asList(relatedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedItems(Consumer<RelatedItem.Builder> ... relatedItems) {
            this.relatedItems(Stream.of(relatedItems).map(c -> (RelatedItem)((RelatedItem.Builder)RelatedItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRelatedItemsResponse build() {
            return new ListRelatedItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmIncidentsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRelatedItemsResponse> {
        public Builder nextToken(String var1);

        public Builder relatedItems(Collection<RelatedItem> var1);

        public Builder relatedItems(RelatedItem ... var1);

        public Builder relatedItems(Consumer<RelatedItem.Builder> ... var1);
    }
}

