/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.AttributeValueList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Condition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Condition> {
    private static final SdkField<Instant> AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("after").getter(Condition.getter(Condition::after)).setter(Condition.setter(Builder::after)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("after").build()}).build();
    private static final SdkField<Instant> BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("before").getter(Condition.getter(Condition::before)).setter(Condition.setter(Builder::before)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("before").build()}).build();
    private static final SdkField<AttributeValueList> EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("equals").getter(Condition.getter(Condition::equalsValue)).setter(Condition.setter(Builder::equalsValue)).constructor(AttributeValueList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_FIELD, BEFORE_FIELD, EQUALS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant after;
    private final Instant before;
    private final AttributeValueList equalsValue;
    private final Type type;

    private Condition(BuilderImpl builder) {
        this.after = builder.after;
        this.before = builder.before;
        this.equalsValue = builder.equalsValue;
        this.type = builder.type;
    }

    public final Instant after() {
        return this.after;
    }

    public final Instant before() {
        return this.before;
    }

    public final AttributeValueList equalsValue() {
        return this.equalsValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.after());
        hashCode = 31 * hashCode + Objects.hashCode(this.before());
        hashCode = 31 * hashCode + Objects.hashCode(this.equalsValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        return Objects.equals(this.after(), other.after()) && Objects.equals(this.before(), other.before()) && Objects.equals(this.equalsValue(), other.equalsValue());
    }

    public final String toString() {
        return ToString.builder((String)"Condition").add("After", (Object)this.after()).add("Before", (Object)this.before()).add("Equals", (Object)this.equalsValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "after": {
                return Optional.ofNullable(clazz.cast(this.after()));
            }
            case "before": {
                return Optional.ofNullable(clazz.cast(this.before()));
            }
            case "equals": {
                return Optional.ofNullable(clazz.cast(this.equalsValue()));
            }
        }
        return Optional.empty();
    }

    public static Condition fromAfter(Instant after) {
        return (Condition)Condition.builder().after(after).build();
    }

    public static Condition fromBefore(Instant before) {
        return (Condition)Condition.builder().before(before).build();
    }

    public static Condition fromEqualsValue(AttributeValueList equalsValue) {
        return (Condition)Condition.builder().equalsValue(equalsValue).build();
    }

    public static Condition fromEqualsValue(Consumer<AttributeValueList.Builder> equalsValue) {
        AttributeValueList.Builder builder = AttributeValueList.builder();
        equalsValue.accept(builder);
        return Condition.fromEqualsValue((AttributeValueList)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AFTER,
        BEFORE,
        EQUALS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Instant after;
        private Instant before;
        private AttributeValueList equalsValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            this.after(model.after);
            this.before(model.before);
            this.equalsValue(model.equalsValue);
        }

        public final Instant getAfter() {
            return this.after;
        }

        public final void setAfter(Instant after) {
            Instant oldValue = this.after;
            this.after = after;
            this.handleUnionValueChange(Type.AFTER, oldValue, this.after);
        }

        @Override
        public final Builder after(Instant after) {
            Instant oldValue = this.after;
            this.after = after;
            this.handleUnionValueChange(Type.AFTER, oldValue, this.after);
            return this;
        }

        public final Instant getBefore() {
            return this.before;
        }

        public final void setBefore(Instant before) {
            Instant oldValue = this.before;
            this.before = before;
            this.handleUnionValueChange(Type.BEFORE, oldValue, this.before);
        }

        @Override
        public final Builder before(Instant before) {
            Instant oldValue = this.before;
            this.before = before;
            this.handleUnionValueChange(Type.BEFORE, oldValue, this.before);
            return this;
        }

        public final AttributeValueList.Builder getEqualsValue() {
            return this.equalsValue != null ? this.equalsValue.toBuilder() : null;
        }

        public final void setEqualsValue(AttributeValueList.BuilderImpl equalsValue) {
            AttributeValueList oldValue = this.equalsValue;
            this.equalsValue = equalsValue != null ? equalsValue.build() : null;
            this.handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
        }

        @Override
        public final Builder equalsValue(AttributeValueList equalsValue) {
            AttributeValueList oldValue = this.equalsValue;
            this.equalsValue = equalsValue;
            this.handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
            return this;
        }

        public Condition build() {
            return new Condition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Condition> {
        public Builder after(Instant var1);

        public Builder before(Instant var1);

        public Builder equalsValue(AttributeValueList var1);

        default public Builder equalsValue(Consumer<AttributeValueList.Builder> equalsValue) {
            return this.equalsValue((AttributeValueList)((AttributeValueList.Builder)AttributeValueList.builder().applyMutation(equalsValue)).build());
        }
    }
}

