/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.VariableType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamicSsmParameterValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamicSsmParameterValue> {
    private static final SdkField<String> VARIABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("variable").getter(DynamicSsmParameterValue.getter(DynamicSsmParameterValue::variableAsString)).setter(DynamicSsmParameterValue.setter(Builder::variable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String variable;
    private final Type type;

    private DynamicSsmParameterValue(BuilderImpl builder) {
        this.variable = builder.variable;
        this.type = builder.type;
    }

    public final VariableType variable() {
        return VariableType.fromValue(this.variable);
    }

    public final String variableAsString() {
        return this.variable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variableAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicSsmParameterValue)) {
            return false;
        }
        DynamicSsmParameterValue other = (DynamicSsmParameterValue)obj;
        return Objects.equals(this.variableAsString(), other.variableAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DynamicSsmParameterValue").add("Variable", (Object)this.variableAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variable": {
                return Optional.ofNullable(clazz.cast(this.variableAsString()));
            }
        }
        return Optional.empty();
    }

    public static DynamicSsmParameterValue fromVariable(String variable) {
        return (DynamicSsmParameterValue)DynamicSsmParameterValue.builder().variable(variable).build();
    }

    public static DynamicSsmParameterValue fromVariable(VariableType variable) {
        return (DynamicSsmParameterValue)DynamicSsmParameterValue.builder().variable(variable).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamicSsmParameterValue, T> g) {
        return obj -> g.apply((DynamicSsmParameterValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        VARIABLE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String variable;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicSsmParameterValue model) {
            this.variable(model.variable);
        }

        public final String getVariable() {
            return this.variable;
        }

        public final void setVariable(String variable) {
            String oldValue = this.variable;
            this.variable = variable;
            this.handleUnionValueChange(Type.VARIABLE, oldValue, this.variable);
        }

        @Override
        public final Builder variable(String variable) {
            String oldValue = this.variable;
            this.variable = variable;
            this.handleUnionValueChange(Type.VARIABLE, oldValue, this.variable);
            return this;
        }

        @Override
        public final Builder variable(VariableType variable) {
            this.variable(variable == null ? null : variable.toString());
            return this;
        }

        public DynamicSsmParameterValue build() {
            return new DynamicSsmParameterValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamicSsmParameterValue> {
        public Builder variable(String var1);

        public Builder variable(VariableType var1);
    }
}

