/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsClient;
import software.amazon.awssdk.services.ssmincidents.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsResponse;

public class ListReplicationSetsIterable
implements SdkIterable<ListReplicationSetsResponse> {
    private final SsmIncidentsClient client;
    private final ListReplicationSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReplicationSetsIterable(SsmIncidentsClient client, ListReplicationSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReplicationSetsResponseFetcher();
    }

    public Iterator<ListReplicationSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> replicationSetArns() {
        Function<ListReplicationSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicationSetArns() != null) {
                return response.replicationSetArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReplicationSetsResponseFetcher
    implements SyncPageFetcher<ListReplicationSetsResponse> {
        private ListReplicationSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListReplicationSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReplicationSetsResponse nextPage(ListReplicationSetsResponse previousPage) {
            if (previousPage == null) {
                return ListReplicationSetsIterable.this.client.listReplicationSets(ListReplicationSetsIterable.this.firstRequest);
            }
            return ListReplicationSetsIterable.this.client.listReplicationSets((ListReplicationSetsRequest)((Object)ListReplicationSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

