/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsClient;
import software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansResponse;
import software.amazon.awssdk.services.ssmincidents.model.ResponsePlanSummary;

public class ListResponsePlansIterable
implements SdkIterable<ListResponsePlansResponse> {
    private final SsmIncidentsClient client;
    private final ListResponsePlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResponsePlansIterable(SsmIncidentsClient client, ListResponsePlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResponsePlansResponseFetcher();
    }

    public Iterator<ListResponsePlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResponsePlanSummary> responsePlanSummaries() {
        Function<ListResponsePlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.responsePlanSummaries() != null) {
                return response.responsePlanSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResponsePlansResponseFetcher
    implements SyncPageFetcher<ListResponsePlansResponse> {
        private ListResponsePlansResponseFetcher() {
        }

        public boolean hasNextPage(ListResponsePlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResponsePlansResponse nextPage(ListResponsePlansResponse previousPage) {
            if (previousPage == null) {
                return ListResponsePlansIterable.this.client.listResponsePlans(ListResponsePlansIterable.this.firstRequest);
            }
            return ListResponsePlansIterable.this.client.listResponsePlans((ListResponsePlansRequest)((Object)ListResponsePlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

