/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsResponse;
import software.amazon.awssdk.services.ssmincidents.model.RelatedItem;

public class ListRelatedItemsPublisher
implements SdkPublisher<ListRelatedItemsResponse> {
    private final SsmIncidentsAsyncClient client;
    private final ListRelatedItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRelatedItemsPublisher(SsmIncidentsAsyncClient client, ListRelatedItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRelatedItemsPublisher(SsmIncidentsAsyncClient client, ListRelatedItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRelatedItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRelatedItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RelatedItem> relatedItems() {
        Function<ListRelatedItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedItems() != null) {
                return response.relatedItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRelatedItemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRelatedItemsResponseFetcher
    implements AsyncPageFetcher<ListRelatedItemsResponse> {
        private ListRelatedItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListRelatedItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRelatedItemsResponse> nextPage(ListRelatedItemsResponse previousPage) {
            if (previousPage == null) {
                return ListRelatedItemsPublisher.this.client.listRelatedItems(ListRelatedItemsPublisher.this.firstRequest);
            }
            return ListRelatedItemsPublisher.this.client.listRelatedItems((ListRelatedItemsRequest)((Object)ListRelatedItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

