/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsClient;
import software.amazon.awssdk.services.ssmincidents.model.EventSummary;
import software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsResponse;

public class ListTimelineEventsIterable
implements SdkIterable<ListTimelineEventsResponse> {
    private final SsmIncidentsClient client;
    private final ListTimelineEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTimelineEventsIterable(SsmIncidentsClient client, ListTimelineEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTimelineEventsResponseFetcher();
    }

    public Iterator<ListTimelineEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventSummary> eventSummaries() {
        Function<ListTimelineEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventSummaries() != null) {
                return response.eventSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTimelineEventsResponseFetcher
    implements SyncPageFetcher<ListTimelineEventsResponse> {
        private ListTimelineEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListTimelineEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTimelineEventsResponse nextPage(ListTimelineEventsResponse previousPage) {
            if (previousPage == null) {
                return ListTimelineEventsIterable.this.client.listTimelineEvents(ListTimelineEventsIterable.this.firstRequest);
            }
            return ListTimelineEventsIterable.this.client.listTimelineEvents((ListTimelineEventsRequest)((Object)ListTimelineEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

