/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.AutomationExecution;
import software.amazon.awssdk.services.ssmincidents.model.AutomationExecutionSetCopier;
import software.amazon.awssdk.services.ssmincidents.model.ChatChannel;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordSource;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordStatus;
import software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem;
import software.amazon.awssdk.services.ssmincidents.model.NotificationTargetSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncidentRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IncidentRecord> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(IncidentRecord.getter(IncidentRecord::arn)).setter(IncidentRecord.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<AutomationExecution>> AUTOMATION_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("automationExecutions").getter(IncidentRecord.getter(IncidentRecord::automationExecutions)).setter(IncidentRecord.setter(Builder::automationExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automationExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ChatChannel> CHAT_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("chatChannel").getter(IncidentRecord.getter(IncidentRecord::chatChannel)).setter(IncidentRecord.setter(Builder::chatChannel)).constructor(ChatChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatChannel").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(IncidentRecord.getter(IncidentRecord::creationTime)).setter(IncidentRecord.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DEDUPE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dedupeString").getter(IncidentRecord.getter(IncidentRecord::dedupeString)).setter(IncidentRecord.setter(Builder::dedupeString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedupeString").build()}).build();
    private static final SdkField<Integer> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("impact").getter(IncidentRecord.getter(IncidentRecord::impact)).setter(IncidentRecord.setter(Builder::impact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impact").build()}).build();
    private static final SdkField<IncidentRecordSource> INCIDENT_RECORD_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("incidentRecordSource").getter(IncidentRecord.getter(IncidentRecord::incidentRecordSource)).setter(IncidentRecord.setter(Builder::incidentRecordSource)).constructor(IncidentRecordSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordSource").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedBy").getter(IncidentRecord.getter(IncidentRecord::lastModifiedBy)).setter(IncidentRecord.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(IncidentRecord.getter(IncidentRecord::lastModifiedTime)).setter(IncidentRecord.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<List<NotificationTargetItem>> NOTIFICATION_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationTargets").getter(IncidentRecord.getter(IncidentRecord::notificationTargets)).setter(IncidentRecord.setter(Builder::notificationTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationTargetItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> RESOLVED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("resolvedTime").getter(IncidentRecord.getter(IncidentRecord::resolvedTime)).setter(IncidentRecord.setter(Builder::resolvedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(IncidentRecord.getter(IncidentRecord::statusAsString)).setter(IncidentRecord.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summary").getter(IncidentRecord.getter(IncidentRecord::summary)).setter(IncidentRecord.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(IncidentRecord.getter(IncidentRecord::title)).setter(IncidentRecord.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTOMATION_EXECUTIONS_FIELD, CHAT_CHANNEL_FIELD, CREATION_TIME_FIELD, DEDUPE_STRING_FIELD, IMPACT_FIELD, INCIDENT_RECORD_SOURCE_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, NOTIFICATION_TARGETS_FIELD, RESOLVED_TIME_FIELD, STATUS_FIELD, SUMMARY_FIELD, TITLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<AutomationExecution> automationExecutions;
    private final ChatChannel chatChannel;
    private final Instant creationTime;
    private final String dedupeString;
    private final Integer impact;
    private final IncidentRecordSource incidentRecordSource;
    private final String lastModifiedBy;
    private final Instant lastModifiedTime;
    private final List<NotificationTargetItem> notificationTargets;
    private final Instant resolvedTime;
    private final String status;
    private final String summary;
    private final String title;

    private IncidentRecord(BuilderImpl builder) {
        this.arn = builder.arn;
        this.automationExecutions = builder.automationExecutions;
        this.chatChannel = builder.chatChannel;
        this.creationTime = builder.creationTime;
        this.dedupeString = builder.dedupeString;
        this.impact = builder.impact;
        this.incidentRecordSource = builder.incidentRecordSource;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.notificationTargets = builder.notificationTargets;
        this.resolvedTime = builder.resolvedTime;
        this.status = builder.status;
        this.summary = builder.summary;
        this.title = builder.title;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAutomationExecutions() {
        return this.automationExecutions != null && !(this.automationExecutions instanceof SdkAutoConstructList);
    }

    public final List<AutomationExecution> automationExecutions() {
        return this.automationExecutions;
    }

    public final ChatChannel chatChannel() {
        return this.chatChannel;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String dedupeString() {
        return this.dedupeString;
    }

    public final Integer impact() {
        return this.impact;
    }

    public final IncidentRecordSource incidentRecordSource() {
        return this.incidentRecordSource;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasNotificationTargets() {
        return this.notificationTargets != null && !(this.notificationTargets instanceof SdkAutoConstructList);
    }

    public final List<NotificationTargetItem> notificationTargets() {
        return this.notificationTargets;
    }

    public final Instant resolvedTime() {
        return this.resolvedTime;
    }

    public final IncidentRecordStatus status() {
        return IncidentRecordStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String summary() {
        return this.summary;
    }

    public final String title() {
        return this.title;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomationExecutions() ? this.automationExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.chatChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedupeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.impact());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentRecordSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationTargets() ? this.notificationTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentRecord)) {
            return false;
        }
        IncidentRecord other = (IncidentRecord)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasAutomationExecutions() == other.hasAutomationExecutions() && Objects.equals(this.automationExecutions(), other.automationExecutions()) && Objects.equals(this.chatChannel(), other.chatChannel()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.dedupeString(), other.dedupeString()) && Objects.equals(this.impact(), other.impact()) && Objects.equals(this.incidentRecordSource(), other.incidentRecordSource()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasNotificationTargets() == other.hasNotificationTargets() && Objects.equals(this.notificationTargets(), other.notificationTargets()) && Objects.equals(this.resolvedTime(), other.resolvedTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"IncidentRecord").add("Arn", (Object)this.arn()).add("AutomationExecutions", this.hasAutomationExecutions() ? this.automationExecutions() : null).add("ChatChannel", (Object)this.chatChannel()).add("CreationTime", (Object)this.creationTime()).add("DedupeString", (Object)this.dedupeString()).add("Impact", (Object)this.impact()).add("IncidentRecordSource", (Object)this.incidentRecordSource()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("NotificationTargets", this.hasNotificationTargets() ? this.notificationTargets() : null).add("ResolvedTime", (Object)this.resolvedTime()).add("Status", (Object)this.statusAsString()).add("Summary", (Object)this.summary()).add("Title", (Object)this.title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "automationExecutions": {
                return Optional.ofNullable(clazz.cast(this.automationExecutions()));
            }
            case "chatChannel": {
                return Optional.ofNullable(clazz.cast(this.chatChannel()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "dedupeString": {
                return Optional.ofNullable(clazz.cast(this.dedupeString()));
            }
            case "impact": {
                return Optional.ofNullable(clazz.cast(this.impact()));
            }
            case "incidentRecordSource": {
                return Optional.ofNullable(clazz.cast(this.incidentRecordSource()));
            }
            case "lastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "notificationTargets": {
                return Optional.ofNullable(clazz.cast(this.notificationTargets()));
            }
            case "resolvedTime": {
                return Optional.ofNullable(clazz.cast(this.resolvedTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncidentRecord, T> g) {
        return obj -> g.apply((IncidentRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<AutomationExecution> automationExecutions = DefaultSdkAutoConstructList.getInstance();
        private ChatChannel chatChannel;
        private Instant creationTime;
        private String dedupeString;
        private Integer impact;
        private IncidentRecordSource incidentRecordSource;
        private String lastModifiedBy;
        private Instant lastModifiedTime;
        private List<NotificationTargetItem> notificationTargets = DefaultSdkAutoConstructList.getInstance();
        private Instant resolvedTime;
        private String status;
        private String summary;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(IncidentRecord model) {
            this.arn(model.arn);
            this.automationExecutions(model.automationExecutions);
            this.chatChannel(model.chatChannel);
            this.creationTime(model.creationTime);
            this.dedupeString(model.dedupeString);
            this.impact(model.impact);
            this.incidentRecordSource(model.incidentRecordSource);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.notificationTargets(model.notificationTargets);
            this.resolvedTime(model.resolvedTime);
            this.status(model.status);
            this.summary(model.summary);
            this.title(model.title);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<AutomationExecution.Builder> getAutomationExecutions() {
            List<AutomationExecution.Builder> result = AutomationExecutionSetCopier.copyToBuilder(this.automationExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomationExecutions(Collection<AutomationExecution.BuilderImpl> automationExecutions) {
            this.automationExecutions = AutomationExecutionSetCopier.copyFromBuilder(automationExecutions);
        }

        @Override
        @Transient
        public final Builder automationExecutions(Collection<AutomationExecution> automationExecutions) {
            this.automationExecutions = AutomationExecutionSetCopier.copy(automationExecutions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder automationExecutions(AutomationExecution ... automationExecutions) {
            this.automationExecutions(Arrays.asList(automationExecutions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder automationExecutions(Consumer<AutomationExecution.Builder> ... automationExecutions) {
            this.automationExecutions(Stream.of(automationExecutions).map(c -> (AutomationExecution)((AutomationExecution.Builder)AutomationExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ChatChannel.Builder getChatChannel() {
            return this.chatChannel != null ? this.chatChannel.toBuilder() : null;
        }

        public final void setChatChannel(ChatChannel.BuilderImpl chatChannel) {
            this.chatChannel = chatChannel != null ? chatChannel.build() : null;
        }

        @Override
        @Transient
        public final Builder chatChannel(ChatChannel chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDedupeString() {
            return this.dedupeString;
        }

        public final void setDedupeString(String dedupeString) {
            this.dedupeString = dedupeString;
        }

        @Override
        @Transient
        public final Builder dedupeString(String dedupeString) {
            this.dedupeString = dedupeString;
            return this;
        }

        public final Integer getImpact() {
            return this.impact;
        }

        public final void setImpact(Integer impact) {
            this.impact = impact;
        }

        @Override
        @Transient
        public final Builder impact(Integer impact) {
            this.impact = impact;
            return this;
        }

        public final IncidentRecordSource.Builder getIncidentRecordSource() {
            return this.incidentRecordSource != null ? this.incidentRecordSource.toBuilder() : null;
        }

        public final void setIncidentRecordSource(IncidentRecordSource.BuilderImpl incidentRecordSource) {
            this.incidentRecordSource = incidentRecordSource != null ? incidentRecordSource.build() : null;
        }

        @Override
        @Transient
        public final Builder incidentRecordSource(IncidentRecordSource incidentRecordSource) {
            this.incidentRecordSource = incidentRecordSource;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<NotificationTargetItem.Builder> getNotificationTargets() {
            List<NotificationTargetItem.Builder> result = NotificationTargetSetCopier.copyToBuilder(this.notificationTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationTargets(Collection<NotificationTargetItem.BuilderImpl> notificationTargets) {
            this.notificationTargets = NotificationTargetSetCopier.copyFromBuilder(notificationTargets);
        }

        @Override
        @Transient
        public final Builder notificationTargets(Collection<NotificationTargetItem> notificationTargets) {
            this.notificationTargets = NotificationTargetSetCopier.copy(notificationTargets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationTargets(NotificationTargetItem ... notificationTargets) {
            this.notificationTargets(Arrays.asList(notificationTargets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationTargets(Consumer<NotificationTargetItem.Builder> ... notificationTargets) {
            this.notificationTargets(Stream.of(notificationTargets).map(c -> (NotificationTargetItem)((NotificationTargetItem.Builder)NotificationTargetItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getResolvedTime() {
            return this.resolvedTime;
        }

        public final void setResolvedTime(Instant resolvedTime) {
            this.resolvedTime = resolvedTime;
        }

        @Override
        @Transient
        public final Builder resolvedTime(Instant resolvedTime) {
            this.resolvedTime = resolvedTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(IncidentRecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        @Transient
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public IncidentRecord build() {
            return new IncidentRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IncidentRecord> {
        public Builder arn(String var1);

        public Builder automationExecutions(Collection<AutomationExecution> var1);

        public Builder automationExecutions(AutomationExecution ... var1);

        public Builder automationExecutions(Consumer<AutomationExecution.Builder> ... var1);

        public Builder chatChannel(ChatChannel var1);

        default public Builder chatChannel(Consumer<ChatChannel.Builder> chatChannel) {
            return this.chatChannel((ChatChannel)((ChatChannel.Builder)ChatChannel.builder().applyMutation(chatChannel)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder dedupeString(String var1);

        public Builder impact(Integer var1);

        public Builder incidentRecordSource(IncidentRecordSource var1);

        default public Builder incidentRecordSource(Consumer<IncidentRecordSource.Builder> incidentRecordSource) {
            return this.incidentRecordSource((IncidentRecordSource)((IncidentRecordSource.Builder)IncidentRecordSource.builder().applyMutation(incidentRecordSource)).build());
        }

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder notificationTargets(Collection<NotificationTargetItem> var1);

        public Builder notificationTargets(NotificationTargetItem ... var1);

        public Builder notificationTargets(Consumer<NotificationTargetItem.Builder> ... var1);

        public Builder resolvedTime(Instant var1);

        public Builder status(String var1);

        public Builder status(IncidentRecordStatus var1);

        public Builder summary(String var1);

        public Builder title(String var1);
    }
}

