/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.IntegerListCopier;
import software.amazon.awssdk.services.ssmincidents.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeValueList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeValueList> {
    private static final SdkField<List<Integer>> INTEGER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("integerValues").getter(AttributeValueList.getter(AttributeValueList::integerValues)).setter(AttributeValueList.setter(Builder::integerValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stringValues").getter(AttributeValueList.getter(AttributeValueList::stringValues)).setter(AttributeValueList.setter(Builder::stringValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_VALUES_FIELD, STRING_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Integer> integerValues;
    private final List<String> stringValues;

    private AttributeValueList(BuilderImpl builder) {
        this.integerValues = builder.integerValues;
        this.stringValues = builder.stringValues;
    }

    public final boolean hasIntegerValues() {
        return this.integerValues != null && !(this.integerValues instanceof SdkAutoConstructList);
    }

    public final List<Integer> integerValues() {
        return this.integerValues;
    }

    public final boolean hasStringValues() {
        return this.stringValues != null && !(this.stringValues instanceof SdkAutoConstructList);
    }

    public final List<String> stringValues() {
        return this.stringValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegerValues() ? this.integerValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringValues() ? this.stringValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValueList)) {
            return false;
        }
        AttributeValueList other = (AttributeValueList)obj;
        return this.hasIntegerValues() == other.hasIntegerValues() && Objects.equals(this.integerValues(), other.integerValues()) && this.hasStringValues() == other.hasStringValues() && Objects.equals(this.stringValues(), other.stringValues());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeValueList").add("IntegerValues", this.hasIntegerValues() ? this.integerValues() : null).add("StringValues", this.hasStringValues() ? this.stringValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integerValues": {
                return Optional.ofNullable(clazz.cast(this.integerValues()));
            }
            case "stringValues": {
                return Optional.ofNullable(clazz.cast(this.stringValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValueList, T> g) {
        return obj -> g.apply((AttributeValueList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> integerValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValueList model) {
            this.integerValues(model.integerValues);
            this.stringValues(model.stringValues);
        }

        public final Collection<Integer> getIntegerValues() {
            if (this.integerValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.integerValues;
        }

        public final void setIntegerValues(Collection<Integer> integerValues) {
            this.integerValues = IntegerListCopier.copy(integerValues);
        }

        @Override
        @Transient
        public final Builder integerValues(Collection<Integer> integerValues) {
            this.integerValues = IntegerListCopier.copy(integerValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder integerValues(Integer ... integerValues) {
            this.integerValues(Arrays.asList(integerValues));
            return this;
        }

        public final Collection<String> getStringValues() {
            if (this.stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = StringListCopier.copy(stringValues);
        }

        @Override
        @Transient
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = StringListCopier.copy(stringValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stringValues(String ... stringValues) {
            this.stringValues(Arrays.asList(stringValues));
            return this;
        }

        public AttributeValueList build() {
            return new AttributeValueList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeValueList> {
        public Builder integerValues(Collection<Integer> var1);

        public Builder integerValues(Integer ... var1);

        public Builder stringValues(Collection<String> var1);

        public Builder stringValues(String ... var1);
    }
}

