/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.Action;
import software.amazon.awssdk.services.ssmincidents.model.ActionsListCopier;
import software.amazon.awssdk.services.ssmincidents.model.ChatChannel;
import software.amazon.awssdk.services.ssmincidents.model.EngagementSetCopier;
import software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem;
import software.amazon.awssdk.services.ssmincidents.model.NotificationTargetSetCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResponsePlanRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, UpdateResponsePlanRequest> {
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::actions)).setter(UpdateResponsePlanRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::arn)).setter(UpdateResponsePlanRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<ChatChannel> CHAT_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("chatChannel").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::chatChannel)).setter(UpdateResponsePlanRequest.setter(Builder::chatChannel)).constructor(ChatChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatChannel").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::clientToken)).setter(UpdateResponsePlanRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::displayName)).setter(UpdateResponsePlanRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<String>> ENGAGEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("engagements").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::engagements)).setter(UpdateResponsePlanRequest.setter(Builder::engagements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INCIDENT_TEMPLATE_DEDUPE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("incidentTemplateDedupeString").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::incidentTemplateDedupeString)).setter(UpdateResponsePlanRequest.setter(Builder::incidentTemplateDedupeString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateDedupeString").build()}).build();
    private static final SdkField<Integer> INCIDENT_TEMPLATE_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("incidentTemplateImpact").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::incidentTemplateImpact)).setter(UpdateResponsePlanRequest.setter(Builder::incidentTemplateImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateImpact").build()}).build();
    private static final SdkField<List<NotificationTargetItem>> INCIDENT_TEMPLATE_NOTIFICATION_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("incidentTemplateNotificationTargets").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::incidentTemplateNotificationTargets)).setter(UpdateResponsePlanRequest.setter(Builder::incidentTemplateNotificationTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateNotificationTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationTargetItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INCIDENT_TEMPLATE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("incidentTemplateSummary").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::incidentTemplateSummary)).setter(UpdateResponsePlanRequest.setter(Builder::incidentTemplateSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateSummary").build()}).build();
    private static final SdkField<String> INCIDENT_TEMPLATE_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("incidentTemplateTitle").getter(UpdateResponsePlanRequest.getter(UpdateResponsePlanRequest::incidentTemplateTitle)).setter(UpdateResponsePlanRequest.setter(Builder::incidentTemplateTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateTitle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, ARN_FIELD, CHAT_CHANNEL_FIELD, CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, ENGAGEMENTS_FIELD, INCIDENT_TEMPLATE_DEDUPE_STRING_FIELD, INCIDENT_TEMPLATE_IMPACT_FIELD, INCIDENT_TEMPLATE_NOTIFICATION_TARGETS_FIELD, INCIDENT_TEMPLATE_SUMMARY_FIELD, INCIDENT_TEMPLATE_TITLE_FIELD));
    private final List<Action> actions;
    private final String arn;
    private final ChatChannel chatChannel;
    private final String clientToken;
    private final String displayName;
    private final List<String> engagements;
    private final String incidentTemplateDedupeString;
    private final Integer incidentTemplateImpact;
    private final List<NotificationTargetItem> incidentTemplateNotificationTargets;
    private final String incidentTemplateSummary;
    private final String incidentTemplateTitle;

    private UpdateResponsePlanRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.arn = builder.arn;
        this.chatChannel = builder.chatChannel;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.engagements = builder.engagements;
        this.incidentTemplateDedupeString = builder.incidentTemplateDedupeString;
        this.incidentTemplateImpact = builder.incidentTemplateImpact;
        this.incidentTemplateNotificationTargets = builder.incidentTemplateNotificationTargets;
        this.incidentTemplateSummary = builder.incidentTemplateSummary;
        this.incidentTemplateTitle = builder.incidentTemplateTitle;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<Action> actions() {
        return this.actions;
    }

    public final String arn() {
        return this.arn;
    }

    public final ChatChannel chatChannel() {
        return this.chatChannel;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasEngagements() {
        return this.engagements != null && !(this.engagements instanceof SdkAutoConstructList);
    }

    public final List<String> engagements() {
        return this.engagements;
    }

    public final String incidentTemplateDedupeString() {
        return this.incidentTemplateDedupeString;
    }

    public final Integer incidentTemplateImpact() {
        return this.incidentTemplateImpact;
    }

    public final boolean hasIncidentTemplateNotificationTargets() {
        return this.incidentTemplateNotificationTargets != null && !(this.incidentTemplateNotificationTargets instanceof SdkAutoConstructList);
    }

    public final List<NotificationTargetItem> incidentTemplateNotificationTargets() {
        return this.incidentTemplateNotificationTargets;
    }

    public final String incidentTemplateSummary() {
        return this.incidentTemplateSummary;
    }

    public final String incidentTemplateTitle() {
        return this.incidentTemplateTitle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagements() ? this.engagements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentTemplateDedupeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentTemplateImpact());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidentTemplateNotificationTargets() ? this.incidentTemplateNotificationTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentTemplateSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentTemplateTitle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResponsePlanRequest)) {
            return false;
        }
        UpdateResponsePlanRequest other = (UpdateResponsePlanRequest)((Object)obj);
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.chatChannel(), other.chatChannel()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.displayName(), other.displayName()) && this.hasEngagements() == other.hasEngagements() && Objects.equals(this.engagements(), other.engagements()) && Objects.equals(this.incidentTemplateDedupeString(), other.incidentTemplateDedupeString()) && Objects.equals(this.incidentTemplateImpact(), other.incidentTemplateImpact()) && this.hasIncidentTemplateNotificationTargets() == other.hasIncidentTemplateNotificationTargets() && Objects.equals(this.incidentTemplateNotificationTargets(), other.incidentTemplateNotificationTargets()) && Objects.equals(this.incidentTemplateSummary(), other.incidentTemplateSummary()) && Objects.equals(this.incidentTemplateTitle(), other.incidentTemplateTitle());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResponsePlanRequest").add("Actions", this.hasActions() ? this.actions() : null).add("Arn", (Object)this.arn()).add("ChatChannel", (Object)this.chatChannel()).add("ClientToken", (Object)this.clientToken()).add("DisplayName", (Object)this.displayName()).add("Engagements", this.hasEngagements() ? this.engagements() : null).add("IncidentTemplateDedupeString", (Object)this.incidentTemplateDedupeString()).add("IncidentTemplateImpact", (Object)this.incidentTemplateImpact()).add("IncidentTemplateNotificationTargets", this.hasIncidentTemplateNotificationTargets() ? this.incidentTemplateNotificationTargets() : null).add("IncidentTemplateSummary", (Object)this.incidentTemplateSummary()).add("IncidentTemplateTitle", (Object)this.incidentTemplateTitle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "chatChannel": {
                return Optional.ofNullable(clazz.cast(this.chatChannel()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "engagements": {
                return Optional.ofNullable(clazz.cast(this.engagements()));
            }
            case "incidentTemplateDedupeString": {
                return Optional.ofNullable(clazz.cast(this.incidentTemplateDedupeString()));
            }
            case "incidentTemplateImpact": {
                return Optional.ofNullable(clazz.cast(this.incidentTemplateImpact()));
            }
            case "incidentTemplateNotificationTargets": {
                return Optional.ofNullable(clazz.cast(this.incidentTemplateNotificationTargets()));
            }
            case "incidentTemplateSummary": {
                return Optional.ofNullable(clazz.cast(this.incidentTemplateSummary()));
            }
            case "incidentTemplateTitle": {
                return Optional.ofNullable(clazz.cast(this.incidentTemplateTitle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResponsePlanRequest, T> g) {
        return obj -> g.apply((UpdateResponsePlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private ChatChannel chatChannel;
        private String clientToken;
        private String displayName;
        private List<String> engagements = DefaultSdkAutoConstructList.getInstance();
        private String incidentTemplateDedupeString;
        private Integer incidentTemplateImpact;
        private List<NotificationTargetItem> incidentTemplateNotificationTargets = DefaultSdkAutoConstructList.getInstance();
        private String incidentTemplateSummary;
        private String incidentTemplateTitle;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResponsePlanRequest model) {
            super(model);
            this.actions(model.actions);
            this.arn(model.arn);
            this.chatChannel(model.chatChannel);
            this.clientToken(model.clientToken);
            this.displayName(model.displayName);
            this.engagements(model.engagements);
            this.incidentTemplateDedupeString(model.incidentTemplateDedupeString);
            this.incidentTemplateImpact(model.incidentTemplateImpact);
            this.incidentTemplateNotificationTargets(model.incidentTemplateNotificationTargets);
            this.incidentTemplateSummary(model.incidentTemplateSummary);
            this.incidentTemplateTitle(model.incidentTemplateTitle);
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionsListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsListCopier.copyFromBuilder(actions);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final ChatChannel.Builder getChatChannel() {
            return this.chatChannel != null ? this.chatChannel.toBuilder() : null;
        }

        @Override
        public final Builder chatChannel(ChatChannel chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        public final void setChatChannel(ChatChannel.BuilderImpl chatChannel) {
            this.chatChannel = chatChannel != null ? chatChannel.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Collection<String> getEngagements() {
            if (this.engagements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.engagements;
        }

        @Override
        public final Builder engagements(Collection<String> engagements) {
            this.engagements = EngagementSetCopier.copy(engagements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagements(String ... engagements) {
            this.engagements(Arrays.asList(engagements));
            return this;
        }

        public final void setEngagements(Collection<String> engagements) {
            this.engagements = EngagementSetCopier.copy(engagements);
        }

        public final String getIncidentTemplateDedupeString() {
            return this.incidentTemplateDedupeString;
        }

        @Override
        public final Builder incidentTemplateDedupeString(String incidentTemplateDedupeString) {
            this.incidentTemplateDedupeString = incidentTemplateDedupeString;
            return this;
        }

        public final void setIncidentTemplateDedupeString(String incidentTemplateDedupeString) {
            this.incidentTemplateDedupeString = incidentTemplateDedupeString;
        }

        public final Integer getIncidentTemplateImpact() {
            return this.incidentTemplateImpact;
        }

        @Override
        public final Builder incidentTemplateImpact(Integer incidentTemplateImpact) {
            this.incidentTemplateImpact = incidentTemplateImpact;
            return this;
        }

        public final void setIncidentTemplateImpact(Integer incidentTemplateImpact) {
            this.incidentTemplateImpact = incidentTemplateImpact;
        }

        public final List<NotificationTargetItem.Builder> getIncidentTemplateNotificationTargets() {
            List<NotificationTargetItem.Builder> result = NotificationTargetSetCopier.copyToBuilder(this.incidentTemplateNotificationTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder incidentTemplateNotificationTargets(Collection<NotificationTargetItem> incidentTemplateNotificationTargets) {
            this.incidentTemplateNotificationTargets = NotificationTargetSetCopier.copy(incidentTemplateNotificationTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentTemplateNotificationTargets(NotificationTargetItem ... incidentTemplateNotificationTargets) {
            this.incidentTemplateNotificationTargets(Arrays.asList(incidentTemplateNotificationTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentTemplateNotificationTargets(Consumer<NotificationTargetItem.Builder> ... incidentTemplateNotificationTargets) {
            this.incidentTemplateNotificationTargets(Stream.of(incidentTemplateNotificationTargets).map(c -> (NotificationTargetItem)((NotificationTargetItem.Builder)NotificationTargetItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIncidentTemplateNotificationTargets(Collection<NotificationTargetItem.BuilderImpl> incidentTemplateNotificationTargets) {
            this.incidentTemplateNotificationTargets = NotificationTargetSetCopier.copyFromBuilder(incidentTemplateNotificationTargets);
        }

        public final String getIncidentTemplateSummary() {
            return this.incidentTemplateSummary;
        }

        @Override
        public final Builder incidentTemplateSummary(String incidentTemplateSummary) {
            this.incidentTemplateSummary = incidentTemplateSummary;
            return this;
        }

        public final void setIncidentTemplateSummary(String incidentTemplateSummary) {
            this.incidentTemplateSummary = incidentTemplateSummary;
        }

        public final String getIncidentTemplateTitle() {
            return this.incidentTemplateTitle;
        }

        @Override
        public final Builder incidentTemplateTitle(String incidentTemplateTitle) {
            this.incidentTemplateTitle = incidentTemplateTitle;
            return this;
        }

        public final void setIncidentTemplateTitle(String incidentTemplateTitle) {
            this.incidentTemplateTitle = incidentTemplateTitle;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResponsePlanRequest build() {
            return new UpdateResponsePlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResponsePlanRequest> {
        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder arn(String var1);

        public Builder chatChannel(ChatChannel var1);

        default public Builder chatChannel(Consumer<ChatChannel.Builder> chatChannel) {
            return this.chatChannel((ChatChannel)((ChatChannel.Builder)ChatChannel.builder().applyMutation(chatChannel)).build());
        }

        public Builder clientToken(String var1);

        public Builder displayName(String var1);

        public Builder engagements(Collection<String> var1);

        public Builder engagements(String ... var1);

        public Builder incidentTemplateDedupeString(String var1);

        public Builder incidentTemplateImpact(Integer var1);

        public Builder incidentTemplateNotificationTargets(Collection<NotificationTargetItem> var1);

        public Builder incidentTemplateNotificationTargets(NotificationTargetItem ... var1);

        public Builder incidentTemplateNotificationTargets(Consumer<NotificationTargetItem.Builder> ... var1);

        public Builder incidentTemplateSummary(String var1);

        public Builder incidentTemplateTitle(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

