/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TriggerDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TriggerDetails> {
    private static final SdkField<String> RAW_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rawData").getter(TriggerDetails.getter(TriggerDetails::rawData)).setter(TriggerDetails.setter(Builder::rawData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawData").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(TriggerDetails.getter(TriggerDetails::source)).setter(TriggerDetails.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(TriggerDetails.getter(TriggerDetails::timestamp)).setter(TriggerDetails.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> TRIGGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("triggerArn").getter(TriggerDetails.getter(TriggerDetails::triggerArn)).setter(TriggerDetails.setter(Builder::triggerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAW_DATA_FIELD, SOURCE_FIELD, TIMESTAMP_FIELD, TRIGGER_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String rawData;
    private final String source;
    private final Instant timestamp;
    private final String triggerArn;

    private TriggerDetails(BuilderImpl builder) {
        this.rawData = builder.rawData;
        this.source = builder.source;
        this.timestamp = builder.timestamp;
        this.triggerArn = builder.triggerArn;
    }

    public final String rawData() {
        return this.rawData;
    }

    public final String source() {
        return this.source;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String triggerArn() {
        return this.triggerArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rawData());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerDetails)) {
            return false;
        }
        TriggerDetails other = (TriggerDetails)obj;
        return Objects.equals(this.rawData(), other.rawData()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.triggerArn(), other.triggerArn());
    }

    public final String toString() {
        return ToString.builder((String)"TriggerDetails").add("RawData", (Object)this.rawData()).add("Source", (Object)this.source()).add("Timestamp", (Object)this.timestamp()).add("TriggerArn", (Object)this.triggerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rawData": {
                return Optional.ofNullable(clazz.cast(this.rawData()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "triggerArn": {
                return Optional.ofNullable(clazz.cast(this.triggerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerDetails, T> g) {
        return obj -> g.apply((TriggerDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rawData;
        private String source;
        private Instant timestamp;
        private String triggerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerDetails model) {
            this.rawData(model.rawData);
            this.source(model.source);
            this.timestamp(model.timestamp);
            this.triggerArn(model.triggerArn);
        }

        public final String getRawData() {
            return this.rawData;
        }

        @Override
        public final Builder rawData(String rawData) {
            this.rawData = rawData;
            return this;
        }

        public final void setRawData(String rawData) {
            this.rawData = rawData;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getTriggerArn() {
            return this.triggerArn;
        }

        @Override
        public final Builder triggerArn(String triggerArn) {
            this.triggerArn = triggerArn;
            return this;
        }

        public final void setTriggerArn(String triggerArn) {
            this.triggerArn = triggerArn;
        }

        public TriggerDetails build() {
            return new TriggerDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TriggerDetails> {
        public Builder rawData(String var1);

        public Builder source(String var1);

        public Builder timestamp(Instant var1);

        public Builder triggerArn(String var1);
    }
}

