/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.ChatbotSnsConfigurationSetCopier;
import software.amazon.awssdk.services.ssmincidents.model.EmptyChatChannel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatChannel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChatChannel> {
    private static final SdkField<List<String>> CHATBOT_SNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("chatbotSns").getter(ChatChannel.getter(ChatChannel::chatbotSns)).setter(ChatChannel.setter(Builder::chatbotSns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatbotSns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EmptyChatChannel> EMPTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("empty").getter(ChatChannel.getter(ChatChannel::empty)).setter(ChatChannel.setter(Builder::empty)).constructor(EmptyChatChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("empty").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHATBOT_SNS_FIELD, EMPTY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> chatbotSns;
    private final EmptyChatChannel empty;

    private ChatChannel(BuilderImpl builder) {
        this.chatbotSns = builder.chatbotSns;
        this.empty = builder.empty;
    }

    public final boolean hasChatbotSns() {
        return this.chatbotSns != null && !(this.chatbotSns instanceof SdkAutoConstructList);
    }

    public final List<String> chatbotSns() {
        return this.chatbotSns;
    }

    public final EmptyChatChannel empty() {
        return this.empty;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChatbotSns() ? this.chatbotSns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.empty());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatChannel)) {
            return false;
        }
        ChatChannel other = (ChatChannel)obj;
        return this.hasChatbotSns() == other.hasChatbotSns() && Objects.equals(this.chatbotSns(), other.chatbotSns()) && Objects.equals(this.empty(), other.empty());
    }

    public final String toString() {
        return ToString.builder((String)"ChatChannel").add("ChatbotSns", this.hasChatbotSns() ? this.chatbotSns() : null).add("Empty", (Object)this.empty()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "chatbotSns": {
                return Optional.ofNullable(clazz.cast(this.chatbotSns()));
            }
            case "empty": {
                return Optional.ofNullable(clazz.cast(this.empty()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChatChannel, T> g) {
        return obj -> g.apply((ChatChannel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> chatbotSns = DefaultSdkAutoConstructList.getInstance();
        private EmptyChatChannel empty;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatChannel model) {
            this.chatbotSns(model.chatbotSns);
            this.empty(model.empty);
        }

        public final Collection<String> getChatbotSns() {
            if (this.chatbotSns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.chatbotSns;
        }

        @Override
        public final Builder chatbotSns(Collection<String> chatbotSns) {
            this.chatbotSns = ChatbotSnsConfigurationSetCopier.copy(chatbotSns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chatbotSns(String ... chatbotSns) {
            this.chatbotSns(Arrays.asList(chatbotSns));
            return this;
        }

        public final void setChatbotSns(Collection<String> chatbotSns) {
            this.chatbotSns = ChatbotSnsConfigurationSetCopier.copy(chatbotSns);
        }

        public final EmptyChatChannel.Builder getEmpty() {
            return this.empty != null ? this.empty.toBuilder() : null;
        }

        @Override
        public final Builder empty(EmptyChatChannel empty) {
            this.empty = empty;
            return this;
        }

        public final void setEmpty(EmptyChatChannel.BuilderImpl empty) {
            this.empty = empty != null ? empty.build() : null;
        }

        public ChatChannel build() {
            return new ChatChannel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChatChannel> {
        public Builder chatbotSns(Collection<String> var1);

        public Builder chatbotSns(String ... var1);

        public Builder empty(EmptyChatChannel var1);

        default public Builder empty(Consumer<EmptyChatChannel.Builder> empty) {
            return this.empty((EmptyChatChannel)((EmptyChatChannel.Builder)EmptyChatChannel.builder().applyMutation(empty)).build());
        }
    }
}

