/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmguiconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmguiconnect.model.S3Bucket;
import software.amazon.awssdk.services.ssmguiconnect.model.S3BucketsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordingDestinations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordingDestinations> {
    private static final SdkField<List<S3Bucket>> S3_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3Buckets").getter(RecordingDestinations.getter(RecordingDestinations::s3Buckets)).setter(RecordingDestinations.setter(Builder::s3Buckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Buckets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Bucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecordingDestinations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<S3Bucket> s3Buckets;

    private RecordingDestinations(BuilderImpl builder) {
        this.s3Buckets = builder.s3Buckets;
    }

    public final boolean hasS3Buckets() {
        return this.s3Buckets != null && !(this.s3Buckets instanceof SdkAutoConstructList);
    }

    public final List<S3Bucket> s3Buckets() {
        return this.s3Buckets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Buckets() ? this.s3Buckets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingDestinations)) {
            return false;
        }
        RecordingDestinations other = (RecordingDestinations)obj;
        return this.hasS3Buckets() == other.hasS3Buckets() && Objects.equals(this.s3Buckets(), other.s3Buckets());
    }

    public final String toString() {
        return ToString.builder((String)"RecordingDestinations").add("S3Buckets", this.hasS3Buckets() ? this.s3Buckets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Buckets": {
                return Optional.ofNullable(clazz.cast(this.s3Buckets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<S3Bucket>>> map = new HashMap<String, SdkField<List<S3Bucket>>>();
        map.put("S3Buckets", S3_BUCKETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordingDestinations, T> g) {
        return obj -> g.apply((RecordingDestinations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<S3Bucket> s3Buckets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingDestinations model) {
            this.s3Buckets(model.s3Buckets);
        }

        public final List<S3Bucket.Builder> getS3Buckets() {
            List<S3Bucket.Builder> result = S3BucketsCopier.copyToBuilder(this.s3Buckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Buckets(Collection<S3Bucket.BuilderImpl> s3Buckets) {
            this.s3Buckets = S3BucketsCopier.copyFromBuilder(s3Buckets);
        }

        @Override
        public final Builder s3Buckets(Collection<S3Bucket> s3Buckets) {
            this.s3Buckets = S3BucketsCopier.copy(s3Buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Buckets(S3Bucket ... s3Buckets) {
            this.s3Buckets(Arrays.asList(s3Buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Buckets(Consumer<S3Bucket.Builder> ... s3Buckets) {
            this.s3Buckets(Stream.of(s3Buckets).map(c -> (S3Bucket)((S3Bucket.Builder)S3Bucket.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RecordingDestinations build() {
            return new RecordingDestinations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordingDestinations> {
        public Builder s3Buckets(Collection<S3Bucket> var1);

        public Builder s3Buckets(S3Bucket ... var1);

        public Builder s3Buckets(Consumer<S3Bucket.Builder> ... var1);
    }
}

