/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a shift that belongs to an on-call rotation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotationShift implements SdkPojo, Serializable, ToCopyableBuilder<RotationShift.Builder, RotationShift> {
    private static final SdkField<List<String>> CONTACT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContactIds")
            .getter(getter(RotationShift::contactIds))
            .setter(setter(Builder::contactIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(RotationShift::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(RotationShift::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RotationShift::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ShiftDetails> SHIFT_DETAILS_FIELD = SdkField.<ShiftDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ShiftDetails").getter(getter(RotationShift::shiftDetails)).setter(setter(Builder::shiftDetails))
            .constructor(ShiftDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShiftDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_IDS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, TYPE_FIELD, SHIFT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> contactIds;

    private final Instant startTime;

    private final Instant endTime;

    private final String type;

    private final ShiftDetails shiftDetails;

    private RotationShift(BuilderImpl builder) {
        this.contactIds = builder.contactIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.type = builder.type;
        this.shiftDetails = builder.shiftDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContactIds() {
        return contactIds != null && !(contactIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactIds} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation.
     */
    public final List<String> contactIds() {
        return contactIds;
    }

    /**
     * <p>
     * The time a shift rotation begins.
     * </p>
     * 
     * @return The time a shift rotation begins.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time a shift rotation ends.
     * </p>
     * 
     * @return The time a shift rotation ends.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The type of shift rotation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShiftType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of shift rotation.
     * @see ShiftType
     */
    public final ShiftType type() {
        return ShiftType.fromValue(type);
    }

    /**
     * <p>
     * The type of shift rotation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShiftType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of shift rotation.
     * @see ShiftType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Additional information about an on-call rotation shift.
     * </p>
     * 
     * @return Additional information about an on-call rotation shift.
     */
    public final ShiftDetails shiftDetails() {
        return shiftDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContactIds() ? contactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shiftDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationShift)) {
            return false;
        }
        RotationShift other = (RotationShift) obj;
        return hasContactIds() == other.hasContactIds() && Objects.equals(contactIds(), other.contactIds())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(shiftDetails(), other.shiftDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RotationShift").add("ContactIds", hasContactIds() ? contactIds() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Type", typeAsString())
                .add("ShiftDetails", shiftDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactIds":
            return Optional.ofNullable(clazz.cast(contactIds()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ShiftDetails":
            return Optional.ofNullable(clazz.cast(shiftDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactIds", CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ShiftDetails", SHIFT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotationShift, T> g) {
        return obj -> g.apply((RotationShift) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RotationShift> {
        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation.
         * </p>
         * 
         * @param contactIds
         *        The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactIds(Collection<String> contactIds);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation.
         * </p>
         * 
         * @param contactIds
         *        The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactIds(String... contactIds);

        /**
         * <p>
         * The time a shift rotation begins.
         * </p>
         * 
         * @param startTime
         *        The time a shift rotation begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time a shift rotation ends.
         * </p>
         * 
         * @param endTime
         *        The time a shift rotation ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The type of shift rotation.
         * </p>
         * 
         * @param type
         *        The type of shift rotation.
         * @see ShiftType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShiftType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of shift rotation.
         * </p>
         * 
         * @param type
         *        The type of shift rotation.
         * @see ShiftType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShiftType
         */
        Builder type(ShiftType type);

        /**
         * <p>
         * Additional information about an on-call rotation shift.
         * </p>
         * 
         * @param shiftDetails
         *        Additional information about an on-call rotation shift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shiftDetails(ShiftDetails shiftDetails);

        /**
         * <p>
         * Additional information about an on-call rotation shift.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShiftDetails.Builder} avoiding the need
         * to create one manually via {@link ShiftDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShiftDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #shiftDetails(ShiftDetails)}.
         * 
         * @param shiftDetails
         *        a consumer that will call methods on {@link ShiftDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shiftDetails(ShiftDetails)
         */
        default Builder shiftDetails(Consumer<ShiftDetails.Builder> shiftDetails) {
            return shiftDetails(ShiftDetails.builder().applyMutation(shiftDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> contactIds = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private String type;

        private ShiftDetails shiftDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationShift model) {
            contactIds(model.contactIds);
            startTime(model.startTime);
            endTime(model.endTime);
            type(model.type);
            shiftDetails(model.shiftDetails);
        }

        public final Collection<String> getContactIds() {
            if (contactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return contactIds;
        }

        public final void setContactIds(Collection<String> contactIds) {
            this.contactIds = SsmContactsArnListCopier.copy(contactIds);
        }

        @Override
        public final Builder contactIds(Collection<String> contactIds) {
            this.contactIds = SsmContactsArnListCopier.copy(contactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactIds(String... contactIds) {
            contactIds(Arrays.asList(contactIds));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ShiftType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ShiftDetails.Builder getShiftDetails() {
            return shiftDetails != null ? shiftDetails.toBuilder() : null;
        }

        public final void setShiftDetails(ShiftDetails.BuilderImpl shiftDetails) {
            this.shiftDetails = shiftDetails != null ? shiftDetails.build() : null;
        }

        @Override
        public final Builder shiftDetails(ShiftDetails shiftDetails) {
            this.shiftDetails = shiftDetails;
            return this;
        }

        @Override
        public RotationShift build() {
            return new RotationShift(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
