/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPreviewRotationShiftsRequest extends SsmContactsRequest implements
        ToCopyableBuilder<ListPreviewRotationShiftsRequest.Builder, ListPreviewRotationShiftsRequest> {
    private static final SdkField<Instant> ROTATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RotationStartTime").getter(getter(ListPreviewRotationShiftsRequest::rotationStartTime))
            .setter(setter(Builder::rotationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationStartTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListPreviewRotationShiftsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListPreviewRotationShiftsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<String>> MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Members")
            .getter(getter(ListPreviewRotationShiftsRequest::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZoneId").getter(getter(ListPreviewRotationShiftsRequest::timeZoneId))
            .setter(setter(Builder::timeZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()).build();

    private static final SdkField<RecurrenceSettings> RECURRENCE_FIELD = SdkField
            .<RecurrenceSettings> builder(MarshallingType.SDK_POJO).memberName("Recurrence")
            .getter(getter(ListPreviewRotationShiftsRequest::recurrence)).setter(setter(Builder::recurrence))
            .constructor(RecurrenceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final SdkField<List<PreviewOverride>> OVERRIDES_FIELD = SdkField
            .<List<PreviewOverride>> builder(MarshallingType.LIST)
            .memberName("Overrides")
            .getter(getter(ListPreviewRotationShiftsRequest::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PreviewOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(PreviewOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPreviewRotationShiftsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPreviewRotationShiftsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_START_TIME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, MEMBERS_FIELD, TIME_ZONE_ID_FIELD, RECURRENCE_FIELD, OVERRIDES_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant rotationStartTime;

    private final Instant startTime;

    private final Instant endTime;

    private final List<String> members;

    private final String timeZoneId;

    private final RecurrenceSettings recurrence;

    private final List<PreviewOverride> overrides;

    private final String nextToken;

    private final Integer maxResults;

    private ListPreviewRotationShiftsRequest(BuilderImpl builder) {
        super(builder);
        this.rotationStartTime = builder.rotationStartTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.members = builder.members;
        this.timeZoneId = builder.timeZoneId;
        this.recurrence = builder.recurrence;
        this.overrides = builder.overrides;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The date and time a rotation would begin. The first shift is calculated from this date and time.
     * </p>
     * 
     * @return The date and time a rotation would begin. The first shift is calculated from this date and time.
     */
    public final Instant rotationStartTime() {
        return rotationStartTime;
    }

    /**
     * <p>
     * Used to filter the range of calculated shifts before sending the response back to the user.
     * </p>
     * 
     * @return Used to filter the range of calculated shifts before sending the response back to the user.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time a rotation shift would end.
     * </p>
     * 
     * @return The date and time a rotation shift would end.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Members property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contacts that would be assigned to a rotation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembers} method.
     * </p>
     * 
     * @return The contacts that would be assigned to a rotation.
     */
    public final List<String> members() {
        return members;
    }

    /**
     * <p>
     * The time zone the rotation’s activity would be based on, in Internet Assigned Numbers Authority (IANA) format.
     * For example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
     * </p>
     * 
     * @return The time zone the rotation’s activity would be based on, in Internet Assigned Numbers Authority (IANA)
     *         format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
     */
    public final String timeZoneId() {
        return timeZoneId;
    }

    /**
     * <p>
     * Information about how long a rotation would last before restarting at the beginning of the shift order.
     * </p>
     * 
     * @return Information about how long a rotation would last before restarting at the beginning of the shift order.
     */
    public final RecurrenceSettings recurrence() {
        return recurrence;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about changes that would be made in a rotation override.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return Information about changes that would be made in a rotation override.
     */
    public final List<PreviewOverride> overrides() {
        return overrides;
    }

    /**
     * <p>
     * A token to start the list. This token is used to get the next set of results.
     * </p>
     * 
     * @return A token to start the list. This token is used to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that can be specified in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that can be specified
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rotationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPreviewRotationShiftsRequest)) {
            return false;
        }
        ListPreviewRotationShiftsRequest other = (ListPreviewRotationShiftsRequest) obj;
        return Objects.equals(rotationStartTime(), other.rotationStartTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && hasMembers() == other.hasMembers()
                && Objects.equals(members(), other.members()) && Objects.equals(timeZoneId(), other.timeZoneId())
                && Objects.equals(recurrence(), other.recurrence()) && hasOverrides() == other.hasOverrides()
                && Objects.equals(overrides(), other.overrides()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPreviewRotationShiftsRequest").add("RotationStartTime", rotationStartTime())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Members", hasMembers() ? members() : null)
                .add("TimeZoneId", timeZoneId()).add("Recurrence", recurrence())
                .add("Overrides", hasOverrides() ? overrides() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RotationStartTime":
            return Optional.ofNullable(clazz.cast(rotationStartTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        case "TimeZoneId":
            return Optional.ofNullable(clazz.cast(timeZoneId()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        case "Overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RotationStartTime", ROTATION_START_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Members", MEMBERS_FIELD);
        map.put("TimeZoneId", TIME_ZONE_ID_FIELD);
        map.put("Recurrence", RECURRENCE_FIELD);
        map.put("Overrides", OVERRIDES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPreviewRotationShiftsRequest, T> g) {
        return obj -> g.apply((ListPreviewRotationShiftsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmContactsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPreviewRotationShiftsRequest> {
        /**
         * <p>
         * The date and time a rotation would begin. The first shift is calculated from this date and time.
         * </p>
         * 
         * @param rotationStartTime
         *        The date and time a rotation would begin. The first shift is calculated from this date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationStartTime(Instant rotationStartTime);

        /**
         * <p>
         * Used to filter the range of calculated shifts before sending the response back to the user.
         * </p>
         * 
         * @param startTime
         *        Used to filter the range of calculated shifts before sending the response back to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time a rotation shift would end.
         * </p>
         * 
         * @param endTime
         *        The date and time a rotation shift would end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The contacts that would be assigned to a rotation.
         * </p>
         * 
         * @param members
         *        The contacts that would be assigned to a rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<String> members);

        /**
         * <p>
         * The contacts that would be assigned to a rotation.
         * </p>
         * 
         * @param members
         *        The contacts that would be assigned to a rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(String... members);

        /**
         * <p>
         * The time zone the rotation’s activity would be based on, in Internet Assigned Numbers Authority (IANA)
         * format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
         * </p>
         * 
         * @param timeZoneId
         *        The time zone the rotation’s activity would be based on, in Internet Assigned Numbers Authority (IANA)
         *        format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZoneId(String timeZoneId);

        /**
         * <p>
         * Information about how long a rotation would last before restarting at the beginning of the shift order.
         * </p>
         * 
         * @param recurrence
         *        Information about how long a rotation would last before restarting at the beginning of the shift
         *        order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(RecurrenceSettings recurrence);

        /**
         * <p>
         * Information about how long a rotation would last before restarting at the beginning of the shift order.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecurrenceSettings.Builder} avoiding the
         * need to create one manually via {@link RecurrenceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecurrenceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #recurrence(RecurrenceSettings)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link RecurrenceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(RecurrenceSettings)
         */
        default Builder recurrence(Consumer<RecurrenceSettings.Builder> recurrence) {
            return recurrence(RecurrenceSettings.builder().applyMutation(recurrence).build());
        }

        /**
         * <p>
         * Information about changes that would be made in a rotation override.
         * </p>
         * 
         * @param overrides
         *        Information about changes that would be made in a rotation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Collection<PreviewOverride> overrides);

        /**
         * <p>
         * Information about changes that would be made in a rotation override.
         * </p>
         * 
         * @param overrides
         *        Information about changes that would be made in a rotation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(PreviewOverride... overrides);

        /**
         * <p>
         * Information about changes that would be made in a rotation override.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.PreviewOverride.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmcontacts.model.PreviewOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.PreviewOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #overrides(List<PreviewOverride>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.PreviewOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(java.util.Collection<PreviewOverride>)
         */
        Builder overrides(Consumer<PreviewOverride.Builder>... overrides);

        /**
         * <p>
         * A token to start the list. This token is used to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to start the list. This token is used to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that can be specified in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that can be
         *        specified in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private Instant rotationStartTime;

        private Instant startTime;

        private Instant endTime;

        private List<String> members = DefaultSdkAutoConstructList.getInstance();

        private String timeZoneId;

        private RecurrenceSettings recurrence;

        private List<PreviewOverride> overrides = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPreviewRotationShiftsRequest model) {
            super(model);
            rotationStartTime(model.rotationStartTime);
            startTime(model.startTime);
            endTime(model.endTime);
            members(model.members);
            timeZoneId(model.timeZoneId);
            recurrence(model.recurrence);
            overrides(model.overrides);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Instant getRotationStartTime() {
            return rotationStartTime;
        }

        public final void setRotationStartTime(Instant rotationStartTime) {
            this.rotationStartTime = rotationStartTime;
        }

        @Override
        public final Builder rotationStartTime(Instant rotationStartTime) {
            this.rotationStartTime = rotationStartTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getMembers() {
            if (members instanceof SdkAutoConstructList) {
                return null;
            }
            return members;
        }

        public final void setMembers(Collection<String> members) {
            this.members = RotationPreviewMemberListCopier.copy(members);
        }

        @Override
        public final Builder members(Collection<String> members) {
            this.members = RotationPreviewMemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(String... members) {
            members(Arrays.asList(members));
            return this;
        }

        public final String getTimeZoneId() {
            return timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final RecurrenceSettings.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        public final void setRecurrence(RecurrenceSettings.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(RecurrenceSettings recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final List<PreviewOverride.Builder> getOverrides() {
            List<PreviewOverride.Builder> result = OverrideListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<PreviewOverride.BuilderImpl> overrides) {
            this.overrides = OverrideListCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<PreviewOverride> overrides) {
            this.overrides = OverrideListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(PreviewOverride... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<PreviewOverride.Builder>... overrides) {
            overrides(Stream.of(overrides).map(c -> PreviewOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPreviewRotationShiftsRequest build() {
            return new ListPreviewRotationShiftsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
