/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.RotationShift;
import software.amazon.awssdk.services.ssmcontacts.model.RotationShiftsCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRotationShiftsResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, ListRotationShiftsResponse> {
    private static final SdkField<List<RotationShift>> ROTATION_SHIFTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RotationShifts").getter(ListRotationShiftsResponse.getter(ListRotationShiftsResponse::rotationShifts)).setter(ListRotationShiftsResponse.setter(Builder::rotationShifts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationShifts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RotationShift::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRotationShiftsResponse.getter(ListRotationShiftsResponse::nextToken)).setter(ListRotationShiftsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_SHIFTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRotationShiftsResponse.memberNameToFieldInitializer();
    private final List<RotationShift> rotationShifts;
    private final String nextToken;

    private ListRotationShiftsResponse(BuilderImpl builder) {
        super(builder);
        this.rotationShifts = builder.rotationShifts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRotationShifts() {
        return this.rotationShifts != null && !(this.rotationShifts instanceof SdkAutoConstructList);
    }

    public final List<RotationShift> rotationShifts() {
        return this.rotationShifts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRotationShifts() ? this.rotationShifts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRotationShiftsResponse)) {
            return false;
        }
        ListRotationShiftsResponse other = (ListRotationShiftsResponse)((Object)obj);
        return this.hasRotationShifts() == other.hasRotationShifts() && Objects.equals(this.rotationShifts(), other.rotationShifts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRotationShiftsResponse").add("RotationShifts", this.hasRotationShifts() ? this.rotationShifts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RotationShifts": {
                return Optional.ofNullable(clazz.cast(this.rotationShifts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RotationShifts", ROTATION_SHIFTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRotationShiftsResponse, T> g) {
        return obj -> g.apply((ListRotationShiftsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private List<RotationShift> rotationShifts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRotationShiftsResponse model) {
            super(model);
            this.rotationShifts(model.rotationShifts);
            this.nextToken(model.nextToken);
        }

        public final List<RotationShift.Builder> getRotationShifts() {
            List<RotationShift.Builder> result = RotationShiftsCopier.copyToBuilder(this.rotationShifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRotationShifts(Collection<RotationShift.BuilderImpl> rotationShifts) {
            this.rotationShifts = RotationShiftsCopier.copyFromBuilder(rotationShifts);
        }

        @Override
        public final Builder rotationShifts(Collection<RotationShift> rotationShifts) {
            this.rotationShifts = RotationShiftsCopier.copy(rotationShifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rotationShifts(RotationShift ... rotationShifts) {
            this.rotationShifts(Arrays.asList(rotationShifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rotationShifts(Consumer<RotationShift.Builder> ... rotationShifts) {
            this.rotationShifts(Stream.of(rotationShifts).map(c -> (RotationShift)((RotationShift.Builder)RotationShift.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRotationShiftsResponse build() {
            return new ListRotationShiftsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRotationShiftsResponse> {
        public Builder rotationShifts(Collection<RotationShift> var1);

        public Builder rotationShifts(RotationShift ... var1);

        public Builder rotationShifts(Consumer<RotationShift.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

