/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.RecurrenceSettings;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rotation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rotation> {
    private static final SdkField<String> ROTATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationArn").getter(Rotation.getter(Rotation::rotationArn)).setter(Rotation.setter(Builder::rotationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Rotation.getter(Rotation::name)).setter(Rotation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> CONTACT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactIds").getter(Rotation.getter(Rotation::contactIds)).setter(Rotation.setter(Builder::contactIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Rotation.getter(Rotation::startTime)).setter(Rotation.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZoneId").getter(Rotation.getter(Rotation::timeZoneId)).setter(Rotation.setter(Builder::timeZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()}).build();
    private static final SdkField<RecurrenceSettings> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(Rotation.getter(Rotation::recurrence)).setter(Rotation.setter(Builder::recurrence)).constructor(RecurrenceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_ARN_FIELD, NAME_FIELD, CONTACT_IDS_FIELD, START_TIME_FIELD, TIME_ZONE_ID_FIELD, RECURRENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Rotation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String rotationArn;
    private final String name;
    private final List<String> contactIds;
    private final Instant startTime;
    private final String timeZoneId;
    private final RecurrenceSettings recurrence;

    private Rotation(BuilderImpl builder) {
        this.rotationArn = builder.rotationArn;
        this.name = builder.name;
        this.contactIds = builder.contactIds;
        this.startTime = builder.startTime;
        this.timeZoneId = builder.timeZoneId;
        this.recurrence = builder.recurrence;
    }

    public final String rotationArn() {
        return this.rotationArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasContactIds() {
        return this.contactIds != null && !(this.contactIds instanceof SdkAutoConstructList);
    }

    public final List<String> contactIds() {
        return this.contactIds;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String timeZoneId() {
        return this.timeZoneId;
    }

    public final RecurrenceSettings recurrence() {
        return this.recurrence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactIds() ? this.contactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rotation)) {
            return false;
        }
        Rotation other = (Rotation)obj;
        return Objects.equals(this.rotationArn(), other.rotationArn()) && Objects.equals(this.name(), other.name()) && this.hasContactIds() == other.hasContactIds() && Objects.equals(this.contactIds(), other.contactIds()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.recurrence(), other.recurrence());
    }

    public final String toString() {
        return ToString.builder((String)"Rotation").add("RotationArn", (Object)this.rotationArn()).add("Name", (Object)this.name()).add("ContactIds", this.hasContactIds() ? this.contactIds() : null).add("StartTime", (Object)this.startTime()).add("TimeZoneId", (Object)this.timeZoneId()).add("Recurrence", (Object)this.recurrence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RotationArn": {
                return Optional.ofNullable(clazz.cast(this.rotationArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ContactIds": {
                return Optional.ofNullable(clazz.cast(this.contactIds()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "TimeZoneId": {
                return Optional.ofNullable(clazz.cast(this.timeZoneId()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RotationArn", ROTATION_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ContactIds", CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("TimeZoneId", TIME_ZONE_ID_FIELD);
        map.put("Recurrence", RECURRENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rotation, T> g) {
        return obj -> g.apply((Rotation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rotationArn;
        private String name;
        private List<String> contactIds = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private String timeZoneId;
        private RecurrenceSettings recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(Rotation model) {
            this.rotationArn(model.rotationArn);
            this.name(model.name);
            this.contactIds(model.contactIds);
            this.startTime(model.startTime);
            this.timeZoneId(model.timeZoneId);
            this.recurrence(model.recurrence);
        }

        public final String getRotationArn() {
            return this.rotationArn;
        }

        public final void setRotationArn(String rotationArn) {
            this.rotationArn = rotationArn;
        }

        @Override
        public final Builder rotationArn(String rotationArn) {
            this.rotationArn = rotationArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getContactIds() {
            if (this.contactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contactIds;
        }

        public final void setContactIds(Collection<String> contactIds) {
            this.contactIds = SsmContactsArnListCopier.copy(contactIds);
        }

        @Override
        public final Builder contactIds(Collection<String> contactIds) {
            this.contactIds = SsmContactsArnListCopier.copy(contactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactIds(String ... contactIds) {
            this.contactIds(Arrays.asList(contactIds));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final RecurrenceSettings.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        public final void setRecurrence(RecurrenceSettings.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(RecurrenceSettings recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public Rotation build() {
            return new Rotation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rotation> {
        public Builder rotationArn(String var1);

        public Builder name(String var1);

        public Builder contactIds(Collection<String> var1);

        public Builder contactIds(String ... var1);

        public Builder startTime(Instant var1);

        public Builder timeZoneId(String var1);

        public Builder recurrence(RecurrenceSettings var1);

        default public Builder recurrence(Consumer<RecurrenceSettings.Builder> recurrence) {
            return this.recurrence((RecurrenceSettings)((RecurrenceSettings.Builder)RecurrenceSettings.builder().applyMutation(recurrence)).build());
        }
    }
}

