/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContactPolicyResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, GetContactPolicyResponse> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(GetContactPolicyResponse.getter(GetContactPolicyResponse::contactArn)).setter(GetContactPolicyResponse.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(GetContactPolicyResponse.getter(GetContactPolicyResponse::policy)).setter(GetContactPolicyResponse.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContactArn", CONTACT_ARN_FIELD);
            this.put("Policy", POLICY_FIELD);
        }
    });
    private final String contactArn;
    private final String policy;

    private GetContactPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.policy = builder.policy;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final String policy() {
        return this.policy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactPolicyResponse)) {
            return false;
        }
        GetContactPolicyResponse other = (GetContactPolicyResponse)((Object)obj);
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.policy(), other.policy());
    }

    public final String toString() {
        return ToString.builder((String)"GetContactPolicyResponse").add("ContactArn", (Object)this.contactArn()).add("Policy", (Object)this.policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetContactPolicyResponse, T> g) {
        return obj -> g.apply((GetContactPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String contactArn;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactPolicyResponse model) {
            super(model);
            this.contactArn(model.contactArn);
            this.policy(model.policy);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public GetContactPolicyResponse build() {
            return new GetContactPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContactPolicyResponse> {
        public Builder contactArn(String var1);

        public Builder policy(String var1);
    }
}

