/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Page
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Page> {
    private static final SdkField<String> PAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageArn").getter(Page.getter(Page::pageArn)).setter(Page.setter(Builder::pageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageArn").build()}).build();
    private static final SdkField<String> ENGAGEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementArn").getter(Page.getter(Page::engagementArn)).setter(Page.setter(Builder::engagementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementArn").build()}).build();
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(Page.getter(Page::contactArn)).setter(Page.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> SENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sender").getter(Page.getter(Page::sender)).setter(Page.setter(Builder::sender)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()}).build();
    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncidentId").getter(Page.getter(Page::incidentId)).setter(Page.setter(Builder::incidentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()}).build();
    private static final SdkField<Instant> SENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SentTime").getter(Page.getter(Page::sentTime)).setter(Page.setter(Builder::sentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentTime").build()}).build();
    private static final SdkField<Instant> DELIVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeliveryTime").getter(Page.getter(Page::deliveryTime)).setter(Page.setter(Builder::deliveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTime").build()}).build();
    private static final SdkField<Instant> READ_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReadTime").getter(Page.getter(Page::readTime)).setter(Page.setter(Builder::readTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_ARN_FIELD, ENGAGEMENT_ARN_FIELD, CONTACT_ARN_FIELD, SENDER_FIELD, INCIDENT_ID_FIELD, SENT_TIME_FIELD, DELIVERY_TIME_FIELD, READ_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pageArn;
    private final String engagementArn;
    private final String contactArn;
    private final String sender;
    private final String incidentId;
    private final Instant sentTime;
    private final Instant deliveryTime;
    private final Instant readTime;

    private Page(BuilderImpl builder) {
        this.pageArn = builder.pageArn;
        this.engagementArn = builder.engagementArn;
        this.contactArn = builder.contactArn;
        this.sender = builder.sender;
        this.incidentId = builder.incidentId;
        this.sentTime = builder.sentTime;
        this.deliveryTime = builder.deliveryTime;
        this.readTime = builder.readTime;
    }

    public final String pageArn() {
        return this.pageArn;
    }

    public final String engagementArn() {
        return this.engagementArn;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final String sender() {
        return this.sender;
    }

    public final String incidentId() {
        return this.incidentId;
    }

    public final Instant sentTime() {
        return this.sentTime;
    }

    public final Instant deliveryTime() {
        return this.deliveryTime;
    }

    public final Instant readTime() {
        return this.readTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sender());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.readTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page)obj;
        return Objects.equals(this.pageArn(), other.pageArn()) && Objects.equals(this.engagementArn(), other.engagementArn()) && Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.sender(), other.sender()) && Objects.equals(this.incidentId(), other.incidentId()) && Objects.equals(this.sentTime(), other.sentTime()) && Objects.equals(this.deliveryTime(), other.deliveryTime()) && Objects.equals(this.readTime(), other.readTime());
    }

    public final String toString() {
        return ToString.builder((String)"Page").add("PageArn", (Object)this.pageArn()).add("EngagementArn", (Object)this.engagementArn()).add("ContactArn", (Object)this.contactArn()).add("Sender", (Object)this.sender()).add("IncidentId", (Object)this.incidentId()).add("SentTime", (Object)this.sentTime()).add("DeliveryTime", (Object)this.deliveryTime()).add("ReadTime", (Object)this.readTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PageArn": {
                return Optional.ofNullable(clazz.cast(this.pageArn()));
            }
            case "EngagementArn": {
                return Optional.ofNullable(clazz.cast(this.engagementArn()));
            }
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "Sender": {
                return Optional.ofNullable(clazz.cast(this.sender()));
            }
            case "IncidentId": {
                return Optional.ofNullable(clazz.cast(this.incidentId()));
            }
            case "SentTime": {
                return Optional.ofNullable(clazz.cast(this.sentTime()));
            }
            case "DeliveryTime": {
                return Optional.ofNullable(clazz.cast(this.deliveryTime()));
            }
            case "ReadTime": {
                return Optional.ofNullable(clazz.cast(this.readTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Page, T> g) {
        return obj -> g.apply((Page)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pageArn;
        private String engagementArn;
        private String contactArn;
        private String sender;
        private String incidentId;
        private Instant sentTime;
        private Instant deliveryTime;
        private Instant readTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Page model) {
            this.pageArn(model.pageArn);
            this.engagementArn(model.engagementArn);
            this.contactArn(model.contactArn);
            this.sender(model.sender);
            this.incidentId(model.incidentId);
            this.sentTime(model.sentTime);
            this.deliveryTime(model.deliveryTime);
            this.readTime(model.readTime);
        }

        public final String getPageArn() {
            return this.pageArn;
        }

        public final void setPageArn(String pageArn) {
            this.pageArn = pageArn;
        }

        @Override
        public final Builder pageArn(String pageArn) {
            this.pageArn = pageArn;
            return this;
        }

        public final String getEngagementArn() {
            return this.engagementArn;
        }

        public final void setEngagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
        }

        @Override
        public final Builder engagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
            return this;
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getSender() {
            return this.sender;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final String getIncidentId() {
            return this.incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final Instant getSentTime() {
            return this.sentTime;
        }

        public final void setSentTime(Instant sentTime) {
            this.sentTime = sentTime;
        }

        @Override
        public final Builder sentTime(Instant sentTime) {
            this.sentTime = sentTime;
            return this;
        }

        public final Instant getDeliveryTime() {
            return this.deliveryTime;
        }

        public final void setDeliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        @Override
        public final Builder deliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        public final Instant getReadTime() {
            return this.readTime;
        }

        public final void setReadTime(Instant readTime) {
            this.readTime = readTime;
        }

        @Override
        public final Builder readTime(Instant readTime) {
            this.readTime = readTime;
            return this;
        }

        public Page build() {
            return new Page(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Page> {
        public Builder pageArn(String var1);

        public Builder engagementArn(String var1);

        public Builder contactArn(String var1);

        public Builder sender(String var1);

        public Builder incidentId(String var1);

        public Builder sentTime(Instant var1);

        public Builder deliveryTime(Instant var1);

        public Builder readTime(Instant var1);
    }
}

