/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactResponse;
import software.amazon.awssdk.services.ssmcontacts.model.Page;

public class ListPagesByContactPublisher
implements SdkPublisher<ListPagesByContactResponse> {
    private final SsmContactsAsyncClient client;
    private final ListPagesByContactRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPagesByContactPublisher(SsmContactsAsyncClient client, ListPagesByContactRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPagesByContactPublisher(SsmContactsAsyncClient client, ListPagesByContactRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPagesByContactResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPagesByContactResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Page> pages() {
        Function<ListPagesByContactResponse, Iterator> getIterator = response -> {
            if (response != null && response.pages() != null) {
                return response.pages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPagesByContactResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPagesByContactResponseFetcher
    implements AsyncPageFetcher<ListPagesByContactResponse> {
        private ListPagesByContactResponseFetcher() {
        }

        public boolean hasNextPage(ListPagesByContactResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPagesByContactResponse> nextPage(ListPagesByContactResponse previousPage) {
            if (previousPage == null) {
                return ListPagesByContactPublisher.this.client.listPagesByContact(ListPagesByContactPublisher.this.firstRequest);
            }
            return ListPagesByContactPublisher.this.client.listPagesByContact((ListPagesByContactRequest)((Object)ListPagesByContactPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

