/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.model.ContactChannel;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse;

public class ListContactChannelsIterable
implements SdkIterable<ListContactChannelsResponse> {
    private final SsmContactsClient client;
    private final ListContactChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactChannelsIterable(SsmContactsClient client, ListContactChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListContactChannelsResponseFetcher();
    }

    public Iterator<ListContactChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactChannel> contactChannels() {
        Function<ListContactChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactChannels() != null) {
                return response.contactChannels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactChannelsResponseFetcher
    implements SyncPageFetcher<ListContactChannelsResponse> {
        private ListContactChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactChannelsResponse nextPage(ListContactChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListContactChannelsIterable.this.client.listContactChannels(ListContactChannelsIterable.this.firstRequest);
            }
            return ListContactChannelsIterable.this.client.listContactChannels((ListContactChannelsRequest)((Object)ListContactChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

