/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse;
import software.amazon.awssdk.services.ssmcontacts.model.Page;

public class ListPagesByEngagementIterable
implements SdkIterable<ListPagesByEngagementResponse> {
    private final SsmContactsClient client;
    private final ListPagesByEngagementRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPagesByEngagementIterable(SsmContactsClient client, ListPagesByEngagementRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPagesByEngagementResponseFetcher();
    }

    public Iterator<ListPagesByEngagementResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Page> pages() {
        Function<ListPagesByEngagementResponse, Iterator> getIterator = response -> {
            if (response != null && response.pages() != null) {
                return response.pages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPagesByEngagementResponseFetcher
    implements SyncPageFetcher<ListPagesByEngagementResponse> {
        private ListPagesByEngagementResponseFetcher() {
        }

        public boolean hasNextPage(ListPagesByEngagementResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPagesByEngagementResponse nextPage(ListPagesByEngagementResponse previousPage) {
            if (previousPage == null) {
                return ListPagesByEngagementIterable.this.client.listPagesByEngagement(ListPagesByEngagementIterable.this.firstRequest);
            }
            return ListPagesByEngagementIterable.this.client.listPagesByEngagement((ListPagesByEngagementRequest)((Object)ListPagesByEngagementIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

