/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationOverridesRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationOverridesResponse;
import software.amazon.awssdk.services.ssmcontacts.model.RotationOverride;

public class ListRotationOverridesPublisher
implements SdkPublisher<ListRotationOverridesResponse> {
    private final SsmContactsAsyncClient client;
    private final ListRotationOverridesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRotationOverridesPublisher(SsmContactsAsyncClient client, ListRotationOverridesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRotationOverridesPublisher(SsmContactsAsyncClient client, ListRotationOverridesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRotationOverridesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRotationOverridesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RotationOverride> rotationOverrides() {
        Function<ListRotationOverridesResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotationOverrides() != null) {
                return response.rotationOverrides().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRotationOverridesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRotationOverridesResponseFetcher
    implements AsyncPageFetcher<ListRotationOverridesResponse> {
        private ListRotationOverridesResponseFetcher() {
        }

        public boolean hasNextPage(ListRotationOverridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRotationOverridesResponse> nextPage(ListRotationOverridesResponse previousPage) {
            if (previousPage == null) {
                return ListRotationOverridesPublisher.this.client.listRotationOverrides(ListRotationOverridesPublisher.this.firstRequest);
            }
            return ListRotationOverridesPublisher.this.client.listRotationOverrides((ListRotationOverridesRequest)((Object)ListRotationOverridesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

