/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.Page;
import software.amazon.awssdk.services.ssmcontacts.model.PagesListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPagesByContactResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, ListPagesByContactResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPagesByContactResponse.getter(ListPagesByContactResponse::nextToken)).setter(ListPagesByContactResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Page>> PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pages").getter(ListPagesByContactResponse.getter(ListPagesByContactResponse::pages)).setter(ListPagesByContactResponse.setter(Builder::pages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Page::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PAGES_FIELD));
    private final String nextToken;
    private final List<Page> pages;

    private ListPagesByContactResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pages = builder.pages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPages() {
        return this.pages != null && !(this.pages instanceof SdkAutoConstructList);
    }

    public final List<Page> pages() {
        return this.pages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPages() ? this.pages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPagesByContactResponse)) {
            return false;
        }
        ListPagesByContactResponse other = (ListPagesByContactResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPages() == other.hasPages() && Objects.equals(this.pages(), other.pages());
    }

    public final String toString() {
        return ToString.builder((String)"ListPagesByContactResponse").add("NextToken", (Object)this.nextToken()).add("Pages", this.hasPages() ? this.pages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Pages": {
                return Optional.ofNullable(clazz.cast(this.pages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPagesByContactResponse, T> g) {
        return obj -> g.apply((ListPagesByContactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Page> pages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPagesByContactResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.pages(model.pages);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Page.Builder> getPages() {
            List<Page.Builder> result = PagesListCopier.copyToBuilder(this.pages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPages(Collection<Page.BuilderImpl> pages) {
            this.pages = PagesListCopier.copyFromBuilder(pages);
        }

        @Override
        @Transient
        public final Builder pages(Collection<Page> pages) {
            this.pages = PagesListCopier.copy(pages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pages(Page ... pages) {
            this.pages(Arrays.asList(pages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pages(Consumer<Page.Builder> ... pages) {
            this.pages(Stream.of(pages).map(c -> (Page)((Page.Builder)Page.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPagesByContactResponse build() {
            return new ListPagesByContactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPagesByContactResponse> {
        public Builder nextToken(String var1);

        public Builder pages(Collection<Page> var1);

        public Builder pages(Page ... var1);

        public Builder pages(Consumer<Page.Builder> ... var1);
    }
}

