/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.ContactType;
import software.amazon.awssdk.services.ssmcontacts.model.Plan;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContactResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, GetContactResponse> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(GetContactResponse.getter(GetContactResponse::contactArn)).setter(GetContactResponse.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(GetContactResponse.getter(GetContactResponse::alias)).setter(GetContactResponse.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(GetContactResponse.getter(GetContactResponse::displayName)).setter(GetContactResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetContactResponse.getter(GetContactResponse::typeAsString)).setter(GetContactResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Plan> PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Plan").getter(GetContactResponse.getter(GetContactResponse::plan)).setter(GetContactResponse.setter(Builder::plan)).constructor(Plan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Plan").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, ALIAS_FIELD, DISPLAY_NAME_FIELD, TYPE_FIELD, PLAN_FIELD));
    private final String contactArn;
    private final String alias;
    private final String displayName;
    private final String type;
    private final Plan plan;

    private GetContactResponse(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.alias = builder.alias;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.plan = builder.plan;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final String alias() {
        return this.alias;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ContactType type() {
        return ContactType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Plan plan() {
        return this.plan;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.plan());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactResponse)) {
            return false;
        }
        GetContactResponse other = (GetContactResponse)((Object)obj);
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.plan(), other.plan());
    }

    public final String toString() {
        return ToString.builder((String)"GetContactResponse").add("ContactArn", (Object)this.contactArn()).add("Alias", (Object)this.alias()).add("DisplayName", (Object)this.displayName()).add("Type", (Object)this.typeAsString()).add("Plan", (Object)this.plan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Plan": {
                return Optional.ofNullable(clazz.cast(this.plan()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContactResponse, T> g) {
        return obj -> g.apply((GetContactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String contactArn;
        private String alias;
        private String displayName;
        private String type;
        private Plan plan;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactResponse model) {
            super(model);
            this.contactArn(model.contactArn);
            this.alias(model.alias);
            this.displayName(model.displayName);
            this.type(model.type);
            this.plan(model.plan);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getAlias() {
            return this.alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Plan.Builder getPlan() {
            return this.plan != null ? this.plan.toBuilder() : null;
        }

        @Override
        public final Builder plan(Plan plan) {
            this.plan = plan;
            return this;
        }

        public final void setPlan(Plan.BuilderImpl plan) {
            this.plan = plan != null ? plan.build() : null;
        }

        @Override
        public GetContactResponse build() {
            return new GetContactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContactResponse> {
        public Builder contactArn(String var1);

        public Builder alias(String var1);

        public Builder displayName(String var1);

        public Builder type(String var1);

        public Builder type(ContactType var1);

        public Builder plan(Plan var1);

        default public Builder plan(Consumer<Plan.Builder> plan) {
            return this.plan((Plan)((Plan.Builder)Plan.builder().applyMutation(plan)).build());
        }
    }
}

